/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import mtr.data.EnumHelper;
import mtr.data.NameColorDataBase;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.concurrent.RecursiveEventLoop;

public abstract class PacketTrainDataBase
implements IPacket {
    protected static <T extends NameColorDataBase, U extends RecursiveEventLoop<? extends Runnable>> void updateData(Set<T> dataSet, Map<Long, T> cacheMap, U minecraft, PacketBuffer packet, PacketCallback packetCallback, BiFunction<Long, TransportMode, T> createDataWithId) {
        PacketBuffer packetFullCopy = new PacketBuffer(packet.copy());
        long id = packet.readLong();
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.func_150789_c(Short.MAX_VALUE));
        String key = packet.func_150789_c(Short.MAX_VALUE);
        PacketBuffer packetCopy = new PacketBuffer(packet.copy());
        minecraft.execute(() -> {
            NameColorDataBase data = (NameColorDataBase)cacheMap.get(id);
            if (data == null) {
                if (createDataWithId != null) {
                    NameColorDataBase newData = (NameColorDataBase)createDataWithId.apply(id, transportMode);
                    dataSet.add(newData);
                    newData.update(key, packetCopy);
                }
            } else {
                data.update(key, packetCopy);
            }
            packetCallback.packetCallback(packetCopy, packetFullCopy);
        });
    }

    protected static <T extends NameColorDataBase, U extends RecursiveEventLoop<? extends Runnable>> void deleteData(Set<T> dataSet, U minecraft, PacketBuffer packet, PacketCallback packetCallback) {
        PacketBuffer packetFullCopy = new PacketBuffer(packet.copy());
        long id = packet.readLong();
        minecraft.execute(() -> {
            dataSet.removeIf(data -> data.id == id);
            packetCallback.packetCallback(null, packetFullCopy);
        });
    }

    @FunctionalInterface
    protected static interface PacketCallback {
        public void packetCallback(PacketBuffer var1, PacketBuffer var2);
    }
}

