/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import mtr.RegistryClient;
import mtr.block.BlockTrainAnnouncer;
import mtr.block.BlockTrainScheduleSensor;
import mtr.block.BlockTrainSensorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.EnumHelper;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.TransportMode;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataBase;
import mtr.screen.ArrivalProjectorConfigScreen;
import mtr.screen.DashboardScreen;
import mtr.screen.PIDSConfigScreen;
import mtr.screen.RailwaySignScreen;
import mtr.screen.ResourcePackCreatorScreen;
import mtr.screen.TicketMachineScreen;
import mtr.screen.TrainAnnouncerScreen;
import mtr.screen.TrainBasicSensorScreen;
import mtr.screen.TrainScheduleSensorScreen;
import mtr.screen.TrainSensorScreenBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class PacketTrainDataGuiClient
extends PacketTrainDataBase {
    private static final Map<Integer, ByteBuf> TEMP_PACKETS_RECEIVER = new HashMap<Integer, ByteBuf>();
    private static long tempPacketId = 0L;
    private static int expectedSize = 0;

    public static void openDashboardScreenS2C(Minecraft minecraftClient, PacketBuffer packet) {
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.func_218666_n());
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_71462_r instanceof DashboardScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new DashboardScreen(transportMode));
            }
        });
    }

    public static void openRailwaySignScreenS2C(Minecraft minecraftClient, PacketBuffer packet) {
        BlockPos pos = packet.func_179259_c();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_71462_r instanceof RailwaySignScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new RailwaySignScreen(pos));
            }
        });
    }

    public static void openTrainSensorScreenS2C(Minecraft minecraftClient, PacketBuffer packet) {
        BlockPos pos = packet.func_179259_c();
        minecraftClient.execute(() -> {
            if (minecraftClient.field_71441_e != null && !(minecraftClient.field_71462_r instanceof TrainSensorScreenBase)) {
                TileEntity entity = minecraftClient.field_71441_e.func_175625_s(pos);
                if (entity instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainAnnouncerScreen(pos));
                } else if (entity instanceof BlockTrainScheduleSensor.TileEntityTrainScheduleSensor) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainScheduleSensorScreen(pos));
                } else if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainBasicSensorScreen(pos));
                }
            }
        });
    }

    public static void openTicketMachineScreenS2C(Minecraft minecraftClient, PacketBuffer packet) {
        int balance = packet.readInt();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_71462_r instanceof TicketMachineScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new TicketMachineScreen(balance));
            }
        });
    }

    public static void openPIDSConfigScreenS2C(Minecraft minecraftClient, PacketBuffer packet) {
        BlockPos pos1 = packet.func_179259_c();
        BlockPos pos2 = packet.func_179259_c();
        int maxArrivals = packet.readInt();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_71462_r instanceof PIDSConfigScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new PIDSConfigScreen(pos1, pos2, maxArrivals));
            }
        });
    }

    public static void openArrivalProjectorConfigScreenS2C(Minecraft minecraftClient, PacketBuffer packet) {
        BlockPos pos = packet.func_179259_c();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_71462_r instanceof ArrivalProjectorConfigScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new ArrivalProjectorConfigScreen(pos));
            }
        });
    }

    public static void openResourcePackCreatorScreen(Minecraft minecraftClient) {
        minecraftClient.execute(() -> {
            if (!(minecraftClient.field_71462_r instanceof ResourcePackCreatorScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new ResourcePackCreatorScreen());
            }
        });
    }

    public static void announceS2C(Minecraft minecraftClient, PacketBuffer packet) {
        String message = packet.func_218666_n();
        String soundIdString = packet.func_218666_n();
        minecraftClient.execute(() -> {
            IDrawing.narrateOrAnnounce(message);
            ClientWorld world = minecraftClient.field_71441_e;
            ClientPlayerEntity player = minecraftClient.field_71439_g;
            if (!soundIdString.isEmpty() && world != null && player != null) {
                world.func_184156_a(player.func_233580_cy_(), new SoundEvent(new ResourceLocation(soundIdString)), SoundCategory.BLOCKS, 1000000.0f, 1.0f, true);
            }
        });
    }

    public static void createRailS2C(Minecraft minecraftClient, PacketBuffer packet) {
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.func_218666_n());
        BlockPos pos1 = packet.func_179259_c();
        BlockPos pos2 = packet.func_179259_c();
        Rail rail1 = new Rail(packet);
        Rail rail2 = new Rail(packet);
        long savedRailId = packet.readLong();
        minecraftClient.execute(() -> {
            RailwayData.addRail(ClientData.RAILS, ClientData.PLATFORMS, ClientData.SIDINGS, transportMode, pos1, pos2, rail1, 0L);
            RailwayData.addRail(ClientData.RAILS, ClientData.PLATFORMS, ClientData.SIDINGS, transportMode, pos2, pos1, rail2, savedRailId);
        });
    }

    public static void createSignalS2C(Minecraft minecraftClient, PacketBuffer packet) {
        long id = packet.readLong();
        DyeColor dyeColor = DyeColor.values()[packet.readInt()];
        UUID rail = packet.func_179253_g();
        minecraftClient.execute(() -> ClientData.SIGNAL_BLOCKS.add(id, dyeColor, rail));
    }

    public static void removeNodeS2C(Minecraft minecraftClient, PacketBuffer packet) {
        BlockPos pos = packet.func_179259_c();
        minecraftClient.execute(() -> RailwayData.removeNode(null, ClientData.RAILS, pos));
    }

    public static void removeRailConnectionS2C(Minecraft minecraftClient, PacketBuffer packet) {
        BlockPos pos1 = packet.func_179259_c();
        BlockPos pos2 = packet.func_179259_c();
        minecraftClient.execute(() -> RailwayData.removeRailConnection(null, ClientData.RAILS, pos1, pos2));
    }

    public static void removeSignalsS2C(Minecraft minecraftClient, PacketBuffer packet) {
        long removeCount = packet.readInt();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
        ArrayList<UUID> rails = new ArrayList<UUID>();
        int i = 0;
        while ((long)i < removeCount) {
            ids.add(packet.readLong());
            colors.add(DyeColor.values()[packet.readInt()]);
            rails.add(packet.func_179253_g());
            ++i;
        }
        minecraftClient.execute(() -> {
            int i = 0;
            while ((long)i < removeCount) {
                ClientData.SIGNAL_BLOCKS.remove((Long)ids.get(i), (DyeColor)colors.get(i), (UUID)rails.get(i));
                ++i;
            }
        });
    }

    public static void receiveChunk(Minecraft minecraftClient, PacketBuffer packet) {
        long id = packet.readLong();
        int chunk = packet.readInt();
        boolean complete = packet.readBoolean();
        if (tempPacketId != id) {
            TEMP_PACKETS_RECEIVER.clear();
            tempPacketId = id;
            expectedSize = Integer.MAX_VALUE;
        }
        if (complete) {
            expectedSize = chunk + 1;
        }
        TEMP_PACKETS_RECEIVER.put(chunk, packet.readBytes(packet.readableBytes()));
        if (TEMP_PACKETS_RECEIVER.size() == expectedSize) {
            PacketBuffer newPacket = new PacketBuffer(Unpooled.buffer());
            for (int i = 0; i < expectedSize; ++i) {
                newPacket.writeBytes(TEMP_PACKETS_RECEIVER.get(i));
            }
            TEMP_PACKETS_RECEIVER.clear();
            try {
                minecraftClient.execute(() -> ClientData.receivePacket(newPacket));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends NameColorDataBase> void receiveUpdateOrDeleteS2C(Minecraft minecraftClient, PacketBuffer packet, Set<T> dataSet, Map<Long, T> cacheMap, BiFunction<Long, TransportMode, T> createDataWithId, boolean isDelete) {
        PacketTrainDataBase.PacketCallback packetCallback = (updatePacket, fullPacket) -> ClientData.DATA_CACHE.sync();
        if (isDelete) {
            PacketTrainDataGuiClient.deleteData(dataSet, minecraftClient, packet, packetCallback);
        } else {
            PacketTrainDataGuiClient.updateData(dataSet, cacheMap, minecraftClient, packet, packetCallback, createDataWithId);
        }
    }

    public static void sendUpdate(ResourceLocation packetId, PacketBuffer packet) {
        RegistryClient.sendToServer(packetId, packet);
        ClientData.DATA_CACHE.sync();
    }

    public static void sendDeleteData(ResourceLocation packetId, long id) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(id);
        PacketTrainDataGuiClient.sendUpdate(packetId, packet);
    }

    public static void sendTrainSensorC2S(BlockPos pos, Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos);
        packet.writeInt(filterRouteIds.size());
        filterRouteIds.forEach(arg_0 -> ((PacketBuffer)packet).writeLong(arg_0));
        packet.writeBoolean(stoppedOnly);
        packet.writeBoolean(movingOnly);
        packet.writeInt(number);
        packet.writeInt(strings.length);
        for (String string : strings) {
            packet.func_180714_a(string);
        }
        RegistryClient.sendToServer(PACKET_UPDATE_TRAIN_SENSOR, packet);
    }

    public static void generatePathS2C(Minecraft minecraftClient, PacketBuffer packet) {
        long depotId = packet.readLong();
        int successfulSegments = packet.readInt();
        minecraftClient.execute(() -> {
            Depot depot = (Depot)ClientData.DATA_CACHE.depotIdMap.get(depotId);
            if (depot != null) {
                depot.clientPathGenerationSuccessfulSegments = successfulSegments;
            }
        });
    }

    public static void generatePathC2S(long sidingId) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(sidingId);
        RegistryClient.sendToServer(PACKET_GENERATE_PATH, packet);
    }

    public static void clearTrainsC2S(Collection<Siding> sidings) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeInt(sidings.size());
        sidings.forEach(siding -> packet.writeLong(siding.id));
        RegistryClient.sendToServer(PACKET_CLEAR_TRAINS, packet);
    }

    public static void sendSignIdsC2S(BlockPos signPos, Set<Long> selectedIds, String[] signIds) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(signPos);
        packet.writeInt(selectedIds.size());
        selectedIds.forEach(arg_0 -> ((PacketBuffer)packet).writeLong(arg_0));
        packet.writeInt(signIds.length);
        for (String signType : signIds) {
            packet.func_180714_a(signType == null ? "" : signType);
        }
        RegistryClient.sendToServer(PACKET_SIGN_TYPES, packet);
    }

    public static void addBalanceC2S(int addAmount, int emeralds) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeInt(addAmount);
        packet.writeInt(emeralds);
        RegistryClient.sendToServer(PACKET_ADD_BALANCE, packet);
    }

    public static void sendPIDSConfigC2S(BlockPos pos1, BlockPos pos2, String[] messages, boolean[] hideArrival) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos1);
        packet.func_179255_a(pos2);
        packet.writeInt(messages.length);
        for (int i = 0; i < messages.length; ++i) {
            packet.func_180714_a(messages[i]);
            packet.writeBoolean(hideArrival[i]);
        }
        RegistryClient.sendToServer(PACKET_PIDS_UPDATE, packet);
    }

    public static void sendArrivalProjectorConfigC2S(BlockPos pos, Set<Long> filterPlatformIds) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos);
        packet.writeInt(filterPlatformIds.size());
        filterPlatformIds.forEach(arg_0 -> ((PacketBuffer)packet).writeLong(arg_0));
        RegistryClient.sendToServer(PACKET_ARRIVAL_PROJECTOR_UPDATE, packet);
    }
}

