/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import mtr.Registry;
import mtr.block.BlockArrivalProjectorBase;
import mtr.block.BlockPIDSBase;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockRouteSignBase;
import mtr.block.BlockTrainSensorBase;
import mtr.data.Depot;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TicketSystem;
import mtr.data.TransportMode;
import mtr.mappings.Utilities;
import mtr.packet.PacketTrainDataBase;
import mtr.packet.UpdateBlueMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.scoreboard.Score;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketTrainDataGuiServer
extends PacketTrainDataBase {
    private static final int PACKET_CHUNK_SIZE = (int)Math.pow(2.0, 14.0);

    public static void openDashboardScreenS2C(ServerPlayerEntity player, TransportMode transportMode) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_180714_a(transportMode.toString());
        Registry.sendToPlayer(player, PACKET_OPEN_DASHBOARD_SCREEN, packet);
    }

    public static void openRailwaySignScreenS2C(ServerPlayerEntity player, BlockPos signPos) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(signPos);
        Registry.sendToPlayer(player, PACKET_OPEN_RAILWAY_SIGN_SCREEN, packet);
    }

    public static void openTicketMachineScreenS2C(World world, ServerPlayerEntity player) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeInt(TicketSystem.getPlayerScore(world, (PlayerEntity)player, "mtr_balance").func_96652_c());
        Registry.sendToPlayer(player, PACKET_OPEN_TICKET_MACHINE_SCREEN, packet);
    }

    public static void openTrainSensorScreenS2C(ServerPlayerEntity player, BlockPos blockPos) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(blockPos);
        Registry.sendToPlayer(player, PACKET_OPEN_TRAIN_SENSOR_SCREEN, packet);
    }

    public static void openPIDSConfigScreenS2C(ServerPlayerEntity player, BlockPos pos1, BlockPos pos2, int maxArrivals) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos1);
        packet.func_179255_a(pos2);
        packet.writeInt(maxArrivals);
        Registry.sendToPlayer(player, PACKET_OPEN_PIDS_CONFIG_SCREEN, packet);
    }

    public static void openArrivalProjectorConfigScreenS2C(ServerPlayerEntity player, BlockPos pos) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos);
        Registry.sendToPlayer(player, PACKET_OPEN_ARRIVAL_PROJECTOR_CONFIG_SCREEN, packet);
    }

    public static void openResourcePackCreatorScreenS2C(ServerPlayerEntity player) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        Registry.sendToPlayer(player, PACKET_OPEN_RESOURCE_PACK_CREATOR_SCREEN, packet);
    }

    public static void announceS2C(ServerPlayerEntity player, String message, ResourceLocation soundId) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_180714_a(message);
        packet.func_180714_a(soundId == null ? "" : soundId.toString());
        Registry.sendToPlayer(player, PACKET_ANNOUNCE, packet);
    }

    public static void createRailS2C(World world, TransportMode transportMode, BlockPos pos1, BlockPos pos2, Rail rail1, Rail rail2, long savedRailId) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_180714_a(transportMode.toString());
        packet.func_179255_a(pos1);
        packet.func_179255_a(pos2);
        rail1.writePacket(packet);
        rail2.writePacket(packet);
        packet.writeLong(savedRailId);
        world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_CREATE_RAIL, packet));
    }

    public static void createSignalS2C(World world, long id, DyeColor dyeColor, UUID rail) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(id);
        packet.writeInt(dyeColor.ordinal());
        packet.func_179252_a(rail);
        world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_CREATE_SIGNAL, packet));
    }

    public static void updateRailActionsS2C(World world, List<Rail.RailActions> railActions) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeInt(railActions.size());
        railActions.forEach(railAction -> railAction.writePacket(packet));
        world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_UPDATE_RAIL_ACTIONS, packet));
    }

    public static void removeNodeS2C(World world, BlockPos pos) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos);
        world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_REMOVE_NODE, packet));
    }

    public static void removeRailConnectionS2C(World world, BlockPos pos1, BlockPos pos2) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.func_179255_a(pos1);
        packet.func_179255_a(pos2);
        world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_REMOVE_RAIL, packet));
    }

    public static void removeSignalS2C(World world, long id, DyeColor dyeColor, UUID rail) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeInt(1);
        packet.writeLong(id);
        packet.writeInt(dyeColor.ordinal());
        packet.func_179252_a(rail);
        world.func_217369_A().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, PACKET_REMOVE_SIGNALS, packet));
    }

    public static void sendAllInChunks(ServerPlayerEntity player, Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots, SignalBlocks signalBlocks) {
        long tempPacketId = new Random().nextLong();
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        PacketTrainDataGuiServer.serializeData(packet, stations);
        PacketTrainDataGuiServer.serializeData(packet, platforms);
        PacketTrainDataGuiServer.serializeData(packet, sidings);
        PacketTrainDataGuiServer.serializeData(packet, routes);
        PacketTrainDataGuiServer.serializeData(packet, depots);
        PacketTrainDataGuiServer.serializeData(packet, signalBlocks.signalBlocks);
        int i = 0;
        while (!PacketTrainDataGuiServer.sendChunk(player, packet, tempPacketId, i)) {
            ++i;
        }
    }

    public static <T extends NameColorDataBase> void receiveUpdateOrDeleteC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet, ResourceLocation packetId, Function<RailwayData, Set<T>> dataSet, Function<RailwayData, Map<Long, T>> cacheMap, BiFunction<Long, TransportMode, T> createDataWithId, boolean isDelete) {
        if (RailwayData.hasNoPermission(player)) {
            return;
        }
        World world = player.field_70170_p;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        PacketTrainDataBase.PacketCallback packetCallback = (updatePacket, fullPacket) -> world.func_217369_A().forEach(worldPlayer -> {
            if (!worldPlayer.func_110124_au().equals(player.func_110124_au())) {
                Registry.sendToPlayer((ServerPlayerEntity)worldPlayer, packetId, fullPacket);
            }
            railwayData.dataCache.sync();
        });
        if (isDelete) {
            PacketTrainDataGuiServer.deleteData(dataSet.apply(railwayData), minecraftServer, packet, packetCallback);
        } else {
            PacketTrainDataGuiServer.updateData(dataSet.apply(railwayData), cacheMap.apply(railwayData), minecraftServer, packet, packetCallback, createDataWithId);
        }
        if (packetId.equals((Object)PACKET_UPDATE_STATION) || packetId.equals((Object)PACKET_DELETE_STATION)) {
            try {
                UpdateBlueMap.updateBlueMap(world);
            }
            catch (NoClassDefFoundError ignored) {
                System.out.println("BlueMap is not loaded");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void generatePathS2C(World world, long depotId, int successfulSegments) {
        PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
        packet.writeLong(depotId);
        packet.writeInt(successfulSegments);
        world.func_217369_A().forEach(player -> Registry.sendToPlayer((ServerPlayerEntity)player, PACKET_GENERATE_PATH, packet));
    }

    public static void generatePathC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        World world = player.field_70170_p;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long depotId = packet.readLong();
            minecraftServer.execute(() -> railwayData.railwayDataPathGenerationModule.generatePath(minecraftServer, depotId));
        }
    }

    public static void clearTrainsC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        if (RailwayData.hasNoPermission(player)) {
            return;
        }
        World world = player.field_70170_p;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            int sidingCount = packet.readInt();
            HashSet<Long> sidingIds = new HashSet<Long>();
            for (int i = 0; i < sidingCount; ++i) {
                sidingIds.add(packet.readLong());
            }
            minecraftServer.execute(() -> sidingIds.forEach(sidingId -> {
                Siding siding = railwayData.dataCache.sidingIdMap.get(sidingId);
                if (siding != null) {
                    siding.clearTrains();
                }
            }));
        }
    }

    public static void receiveTrainSensorC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        BlockPos pos = packet.func_179259_c();
        HashSet<Long> filterIds = new HashSet<Long>();
        int filterLength = packet.readInt();
        for (int i = 0; i < filterLength; ++i) {
            filterIds.add(packet.readLong());
        }
        boolean stoppedOnly = packet.readBoolean();
        boolean movingOnly = packet.readBoolean();
        int number = packet.readInt();
        int stringCount = packet.readInt();
        String[] strings = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            strings[i] = packet.func_150789_c(Short.MAX_VALUE);
        }
        minecraftServer.execute(() -> {
            TileEntity entity = player.field_70170_p.func_175625_s(pos);
            if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).setData(filterIds, stoppedOnly, movingOnly, number, strings);
            }
        });
    }

    public static void receiveSignIdsC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        BlockPos signPos = packet.func_179259_c();
        int selectedIdsLength = packet.readInt();
        HashSet<Long> selectedIds = new HashSet<Long>();
        for (int i = 0; i < selectedIdsLength; ++i) {
            selectedIds.add(packet.readLong());
        }
        int signLength = packet.readInt();
        String[] signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packet.func_150789_c(Short.MAX_VALUE);
            signIds[i] = signId.isEmpty() ? null : signId;
        }
        minecraftServer.execute(() -> {
            TileEntity entity = player.field_70170_p.func_175625_s(signPos);
            if (entity instanceof BlockRailwaySign.TileEntityRailwaySign) {
                ((BlockRailwaySign.TileEntityRailwaySign)entity).setData(selectedIds, signIds);
            } else if (entity instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                long platformId = selectedIds.isEmpty() ? 0L : (Long)selectedIds.toArray()[0];
                ((BlockRouteSignBase.TileEntityRouteSignBase)entity).setPlatformId(platformId);
                TileEntity entityAbove = player.field_70170_p.func_175625_s(signPos.func_177984_a());
                if (entityAbove instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                    ((BlockRouteSignBase.TileEntityRouteSignBase)entityAbove).setPlatformId(platformId);
                }
            }
        });
    }

    public static void receiveAddBalanceC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        int addAmount = packet.readInt();
        int emeralds = packet.readInt();
        minecraftServer.execute(() -> {
            World world = player.field_70170_p;
            TicketSystem.addObjectivesIfMissing(world);
            Score balanceScore = TicketSystem.getPlayerScore(world, (PlayerEntity)player, "mtr_balance");
            balanceScore.func_96647_c(balanceScore.func_96652_c() + addAmount);
            ItemStackHelper.func_233534_a_((IInventory)Utilities.getInventory((PlayerEntity)player), itemStack -> itemStack.func_77973_b() == Items.field_151166_bC, (int)emeralds, (boolean)false);
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 1.0f, 1.0f);
        });
    }

    public static void receivePIDSMessageC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        BlockPos pos1 = packet.func_179259_c();
        BlockPos pos2 = packet.func_179259_c();
        int maxArrivals = packet.readInt();
        String[] messages = new String[maxArrivals];
        boolean[] hideArrivals = new boolean[maxArrivals];
        for (int i = 0; i < maxArrivals; ++i) {
            messages[i] = packet.func_150789_c(Short.MAX_VALUE);
            hideArrivals[i] = packet.readBoolean();
        }
        minecraftServer.execute(() -> {
            TileEntity entity2;
            TileEntity entity1 = player.field_70170_p.func_175625_s(pos1);
            if (entity1 instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
                ((BlockPIDSBase.TileEntityBlockPIDSBase)entity1).setData(messages, hideArrivals);
            }
            if ((entity2 = player.field_70170_p.func_175625_s(pos2)) instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
                ((BlockPIDSBase.TileEntityBlockPIDSBase)entity2).setData(messages, hideArrivals);
            }
        });
    }

    public static void receiveArrivalProjectorMessageC2S(MinecraftServer minecraftServer, ServerPlayerEntity player, PacketBuffer packet) {
        BlockPos pos = packet.func_179259_c();
        int platformIdCount = packet.readInt();
        HashSet<Long> platformIds = new HashSet<Long>();
        for (int i = 0; i < platformIdCount; ++i) {
            platformIds.add(packet.readLong());
        }
        minecraftServer.execute(() -> {
            TileEntity entity = player.field_70170_p.func_175625_s(pos);
            if (entity instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase) {
                ((BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity).setData(platformIds);
            }
        });
    }

    public static void receiveRemoveRailAction(MinecraftServer minecraftServer, PlayerEntity player, PacketBuffer packet) {
        World world = player.field_70170_p;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long id = packet.readLong();
            minecraftServer.execute(() -> railwayData.railwayDataRailActionsModule.removeRailAction(id));
        }
    }

    public static void receiveUpdateTrainPassengerPosition(MinecraftServer minecraftServer, PlayerEntity player, PacketBuffer packet) {
        PacketBuffer packetFullCopy = new PacketBuffer(packet.copy());
        minecraftServer.execute(() -> player.field_70170_p.func_217369_A().forEach(sendPlayer -> {
            if (sendPlayer != player) {
                Registry.sendToPlayer((ServerPlayerEntity)sendPlayer, PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packetFullCopy);
            }
        }));
    }

    private static <T extends SerializedDataBase> void serializeData(PacketBuffer packet, Collection<T> objects) {
        packet.writeInt(objects.size());
        objects.forEach(object -> object.writePacket(packet));
    }

    private static boolean sendChunk(ServerPlayerEntity player, PacketBuffer packet, long tempPacketId, int chunk) {
        PacketBuffer packetChunk = new PacketBuffer(Unpooled.buffer());
        packetChunk.writeLong(tempPacketId);
        packetChunk.writeInt(chunk);
        boolean success = chunk * PACKET_CHUNK_SIZE > packet.readableBytes();
        packetChunk.writeBoolean(success);
        if (!success) {
            packetChunk.writeBytes(packet.copy(chunk * PACKET_CHUNK_SIZE, Math.min(PACKET_CHUNK_SIZE, packet.readableBytes() - chunk * PACKET_CHUNK_SIZE)));
        }
        try {
            Registry.sendToPlayer(player, PACKET_CHUNK_S2C, packetChunk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }
}

