/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.Shape;
import de.bluecolored.bluemap.api.marker.ShapeMarker;
import java.awt.Color;
import java.io.IOException;
import java.util.Set;
import mtr.data.RailwayData;
import mtr.data.Station;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UpdateBlueMap {
    private static final String BLUE_MAP_MARKER_SET_STATIONS_ID = "mtr_stations";
    private static final String BLUE_MAP_MARKER_SET_STATIONS_TITLE = "Minecraft Transit Railway Stations";

    public static void updateBlueMap(World world) throws IOException {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
        if (api == null) {
            return;
        }
        BlueMapMap map = api.getMaps().stream().filter(map1 -> world.func_234923_W_().func_240901_a_().func_110623_a().contains(map1.getId())).findFirst().orElse(null);
        if (map == null) {
            return;
        }
        Set<Station> stations = railwayData.stations;
        MarkerAPI markerApi = api.getMarkerAPI();
        MarkerSet markerSetStations = markerApi.createMarkerSet(BLUE_MAP_MARKER_SET_STATIONS_ID);
        markerSetStations.setLabel(BLUE_MAP_MARKER_SET_STATIONS_TITLE);
        markerSetStations.getMarkers().forEach(arg_0 -> ((MarkerSet)markerSetStations).removeMarker(arg_0));
        int stationY = world.func_181545_F();
        stations.forEach(station -> {
            BlockPos stationPos = station.getCenter();
            if (stationPos != null) {
                int stationX = stationPos.func_177958_n();
                int stationZ = stationPos.func_177952_p();
                ShapeMarker marker = markerSetStations.createShapeMarker(String.valueOf(station.id), map, (double)stationX, (double)stationY, (double)stationZ, Shape.createCircle((double)stationX, (double)stationZ, (double)4.0, (int)32), (float)stationY);
                marker.setLabel(station.name.replace("|", "\n"));
                Color stationColor = new Color(station.color);
                marker.setFillColor(stationColor);
                marker.setLineColor(stationColor.darker());
            }
        });
        markerApi.save();
    }
}

