/*
 * Decompiled with CFR 0.152.
 */
package mtr.path;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import mtr.data.MessagePackHelper;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.SerializedDataBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class PathData
extends SerializedDataBase {
    public final Rail rail;
    public final long savedRailBaseId;
    public final int dwellTime;
    public final int stopIndex;
    private final BlockPos startingPos;
    private final BlockPos endingPos;
    private static final String KEY_RAIL = "rail";
    private static final String KEY_SAVED_RAIL_BASE_ID = "saved_rail_base_id";
    private static final String KEY_DWELL_TIME = "dwell_time";
    private static final String KEY_STOP_INDEX = "stop_index";
    private static final String KEY_STARTING_POS = "starting_pos";
    private static final String KEY_ENDING_POS = "ending_pos";

    public PathData(Rail rail, long savedRailBaseId, int dwellTime, BlockPos startingPos, BlockPos endingPos, int stopIndex) {
        this.rail = rail;
        this.savedRailBaseId = savedRailBaseId;
        this.dwellTime = dwellTime;
        this.startingPos = startingPos;
        this.endingPos = endingPos;
        this.stopIndex = stopIndex;
    }

    public PathData(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.rail = new Rail(RailwayData.castMessagePackValueToSKMap(map.get(KEY_RAIL)));
        this.savedRailBaseId = messagePackHelper.getLong(KEY_SAVED_RAIL_BASE_ID);
        this.dwellTime = messagePackHelper.getInt(KEY_DWELL_TIME);
        this.stopIndex = messagePackHelper.getInt(KEY_STOP_INDEX);
        this.startingPos = BlockPos.func_218283_e((long)messagePackHelper.getLong(KEY_STARTING_POS));
        this.endingPos = BlockPos.func_218283_e((long)messagePackHelper.getLong(KEY_ENDING_POS));
    }

    @Deprecated
    public PathData(CompoundNBT compoundTag) {
        this.rail = new Rail(compoundTag.func_74775_l(KEY_RAIL));
        this.savedRailBaseId = compoundTag.func_74763_f(KEY_SAVED_RAIL_BASE_ID);
        this.dwellTime = compoundTag.func_74762_e(KEY_DWELL_TIME);
        this.stopIndex = compoundTag.func_74762_e(KEY_STOP_INDEX);
        this.startingPos = BlockPos.func_218283_e((long)compoundTag.func_74763_f(KEY_STARTING_POS));
        this.endingPos = BlockPos.func_218283_e((long)compoundTag.func_74763_f(KEY_ENDING_POS));
    }

    public PathData(PacketBuffer packet) {
        this.rail = new Rail(packet);
        this.savedRailBaseId = packet.readLong();
        this.dwellTime = packet.readInt();
        this.stopIndex = packet.readInt();
        this.startingPos = BlockPos.func_218283_e((long)packet.readLong());
        this.endingPos = BlockPos.func_218283_e((long)packet.readLong());
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_RAIL);
        messagePacker.packMapHeader(this.rail.messagePackLength());
        this.rail.toMessagePack(messagePacker);
        messagePacker.packString(KEY_SAVED_RAIL_BASE_ID).packLong(this.savedRailBaseId);
        messagePacker.packString(KEY_DWELL_TIME).packInt(this.dwellTime);
        messagePacker.packString(KEY_STOP_INDEX).packInt(this.stopIndex);
        messagePacker.packString(KEY_STARTING_POS).packLong(this.startingPos.func_218275_a());
        messagePacker.packString(KEY_ENDING_POS).packLong(this.endingPos.func_218275_a());
    }

    @Override
    public int messagePackLength() {
        return 6;
    }

    @Override
    public void writePacket(PacketBuffer packet) {
        this.rail.writePacket(packet);
        packet.writeLong(this.savedRailBaseId);
        packet.writeInt(this.dwellTime);
        packet.writeInt(this.stopIndex);
        packet.writeLong(this.startingPos.func_218275_a());
        packet.writeLong(this.endingPos.func_218275_a());
    }

    public boolean isSameRail(PathData pathData) {
        return this.startingPos.equals((Object)pathData.startingPos) && this.endingPos.equals((Object)pathData.endingPos);
    }

    public boolean isOppositeRail(PathData pathData) {
        return this.startingPos.equals((Object)pathData.endingPos) && this.endingPos.equals((Object)pathData.startingPos);
    }

    public UUID getRailProduct() {
        return PathData.getRailProduct(this.startingPos, this.endingPos);
    }

    public static UUID getRailProduct(BlockPos startingPos, BlockPos endingPos) {
        long startingPosLong = startingPos.func_218275_a();
        long endingPosLong = endingPos.func_218275_a();
        return new UUID(Math.min(startingPosLong, endingPosLong), Math.max(startingPosLong, endingPosLong));
    }
}

