/*
 * Decompiled with CFR 0.152.
 */
package mtr.path;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SavedRailBase;
import mtr.path.PathData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class PathFinder {
    public static int findPath(List<PathData> path, Map<BlockPos, Map<BlockPos, Rail>> rails, List<SavedRailBase> savedRailBases, int stopIndexOffset) {
        path.clear();
        if (savedRailBases.size() < 2) {
            return 0;
        }
        for (int i = 0; i < savedRailBases.size() - 1; ++i) {
            SavedRailBase savedRailBaseEnd;
            SavedRailBase savedRailBaseStart = savedRailBases.get(i);
            List<PathData> partialPath = PathFinder.findPath(rails, savedRailBaseStart, savedRailBaseEnd = savedRailBases.get(i + 1), i + stopIndexOffset);
            if (partialPath.isEmpty()) {
                path.clear();
                return i + 1;
            }
            PathFinder.appendPath(path, partialPath);
        }
        return savedRailBases.size();
    }

    public static void appendPath(List<PathData> path, List<PathData> partialPath) {
        if (partialPath.isEmpty()) {
            path.clear();
        } else {
            boolean sameFirstRail = !path.isEmpty() && path.get(path.size() - 1).isSameRail(partialPath.get(0));
            for (int j = 0; j < partialPath.size(); ++j) {
                if (j == 0 && sameFirstRail) continue;
                path.add(partialPath.get(j));
            }
        }
    }

    private static List<PathData> findPath(Map<BlockPos, Map<BlockPos, Rail>> rails, SavedRailBase savedRailBaseStart, SavedRailBase savedRailBaseEnd, int stopIndex) {
        BlockPos savedRailBaseEndMidPos = savedRailBaseEnd.getMidPos();
        Function<Map<BlockPos, Rail>, Comparator<BlockPos>> comparator = newConnections -> (pos1, pos2) -> {
            if (((Rail)newConnections.get((Object)pos1)).railType.speedLimit == ((Rail)newConnections.get((Object)pos2)).railType.speedLimit) {
                return pos1.func_177951_i((Vector3i)savedRailBaseEndMidPos) > pos2.func_177951_i((Vector3i)savedRailBaseEndMidPos) ? 1 : -1;
            }
            return ((Rail)newConnections.get((Object)pos2)).railType.speedLimit - ((Rail)newConnections.get((Object)pos1)).railType.speedLimit;
        };
        for (int i = 0; i < 2; ++i) {
            ArrayList<PathPart> path = new ArrayList<PathPart>();
            HashSet<BlockPos> turnBacks = new HashSet<BlockPos>();
            List<BlockPos> startPositions = savedRailBaseStart.getOrderedPositions(savedRailBaseEndMidPos, i == 0);
            path.add(new PathPart(null, startPositions.get(0), new ArrayList()));
            PathFinder.addPathPart(rails, startPositions.get(1), startPositions.get(0), path, turnBacks, comparator);
            while (path.size() >= 2) {
                PathPart lastPathPart = (PathPart)path.get(path.size() - 1);
                if (lastPathPart.otherOptions.isEmpty()) {
                    path.remove(lastPathPart);
                    continue;
                }
                BlockPos newPos = (BlockPos)lastPathPart.otherOptions.remove(0);
                PathFinder.addPathPart(rails, newPos, lastPathPart.pos, path, turnBacks, comparator);
                if (!savedRailBaseEnd.containsPos(newPos)) continue;
                ArrayList<PathData> railPath = new ArrayList<PathData>();
                for (int j = 0; j < path.size() - 1; ++j) {
                    BlockPos pos2;
                    BlockPos pos1 = ((PathPart)path.get(j)).pos;
                    if (!RailwayData.containsRail(rails, pos1, pos2 = ((PathPart)path.get(j + 1)).pos)) {
                        return new ArrayList<PathData>();
                    }
                    Rail rail = rails.get(pos1).get(pos2);
                    boolean turningBack = rail.railType == RailType.TURN_BACK && j < path.size() - 2 && ((PathPart)path.get(j + 2)).pos.equals((Object)pos1);
                    railPath.add(new PathData(rail, j == 0 ? savedRailBaseStart.id : 0L, turningBack ? 1 : 0, pos1, pos2, stopIndex));
                }
                BlockPos endPos = savedRailBaseEnd.getOtherPosition(newPos);
                if (RailwayData.containsRail(rails, newPos, endPos)) {
                    railPath.add(new PathData(rails.get(newPos).get(endPos), savedRailBaseEnd.id, savedRailBaseEnd instanceof Platform ? ((Platform)savedRailBaseEnd).getDwellTime() : 0, newPos, endPos, stopIndex + 1));
                    return railPath;
                }
                return new ArrayList<PathData>();
            }
        }
        return new ArrayList<PathData>();
    }

    private static void addPathPart(Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos newPos, BlockPos lastPos, List<PathPart> path, Set<BlockPos> turnBacks, Function<Map<BlockPos, Rail>, Comparator<BlockPos>> comparator) {
        Map<BlockPos, Rail> newConnections = rails.get(newPos);
        Rail oldRail = rails.get(lastPos).get(newPos);
        if (oldRail == null) {
            return;
        }
        RailAngle newDirection = oldRail.facingEnd.getOpposite();
        ArrayList<BlockPos> otherOptions = new ArrayList<BlockPos>();
        if (newConnections != null) {
            boolean canTurnBack = oldRail.railType == RailType.TURN_BACK && !turnBacks.contains(newPos);
            newConnections.forEach((connectedPos, rail) -> {
                if (canTurnBack || rail.railType != RailType.NONE && rail.facingStart != newDirection.getOpposite() && path.stream().noneMatch(pathPart -> ((PathPart)pathPart).isSame(newPos, newDirection))) {
                    otherOptions.add((BlockPos)connectedPos);
                    if (canTurnBack) {
                        turnBacks.add(newPos);
                    }
                }
            });
        }
        if (!otherOptions.isEmpty()) {
            otherOptions.sort(comparator.apply(newConnections));
            path.add(new PathPart(newDirection, newPos, otherOptions));
        }
    }

    private static class PathPart {
        private final RailAngle direction;
        private final BlockPos pos;
        private final List<BlockPos> otherOptions;

        private PathPart(RailAngle direction, BlockPos pos, List<BlockPos> otherOptions) {
            this.direction = direction;
            this.pos = pos;
            this.otherOptions = otherOptions;
        }

        private boolean isSame(BlockPos newPos, RailAngle newDirection) {
            return newPos.equals((Object)this.pos) && newDirection == this.direction;
        }
    }
}

