/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mtr.mappings.RenderLayerMapper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;

public class MoreRenderLayers
extends RenderLayerMapper {
    private static final Map<String, RenderType> LIGHT_CACHE = new HashMap<String, RenderType>();
    private static final Map<ResourceLocation, RenderType> INTERIOR_CACHE = new HashMap<ResourceLocation, RenderType>();
    private static final Map<ResourceLocation, RenderType> INTERIOR_TRANSLUCENT_CACHE = new HashMap<ResourceLocation, RenderType>();
    private static final Map<ResourceLocation, RenderType> EXTERIOR_CACHE = new HashMap<ResourceLocation, RenderType>();
    private static final Map<ResourceLocation, RenderType> EXTERIOR_TRANSLUCENT_CACHE = new HashMap<ResourceLocation, RenderType>();

    public static RenderType getLight(ResourceLocation texture, boolean isTranslucent) {
        return MoreRenderLayers.checkCache(texture.toString() + isTranslucent, () -> MoreRenderLayers.func_228637_a_((ResourceLocation)texture, (boolean)isTranslucent), LIGHT_CACHE);
    }

    public static RenderType getInterior(ResourceLocation texture) {
        return MoreRenderLayers.checkCache(texture, () -> MoreRenderLayers.func_228638_b_((ResourceLocation)texture), INTERIOR_CACHE);
    }

    public static RenderType getInteriorTranslucent(ResourceLocation texture) {
        return MoreRenderLayers.checkCache(texture, () -> MoreRenderLayers.func_228642_d_((ResourceLocation)texture), INTERIOR_TRANSLUCENT_CACHE);
    }

    public static RenderType getExterior(ResourceLocation texture) {
        return MoreRenderLayers.checkCache(texture, () -> MoreRenderLayers.func_228638_b_((ResourceLocation)texture), EXTERIOR_CACHE);
    }

    public static RenderType getExteriorTranslucent(ResourceLocation texture) {
        return MoreRenderLayers.checkCache(texture, () -> MoreRenderLayers.func_228642_d_((ResourceLocation)texture), EXTERIOR_TRANSLUCENT_CACHE);
    }

    private static <T> RenderType checkCache(T identifier, Supplier<RenderType> supplier, Map<T, RenderType> cache) {
        if (cache.containsKey(identifier)) {
            return cache.get(identifier);
        }
        RenderType renderLayer = supplier.get();
        cache.put(identifier, renderLayer);
        return renderLayer;
    }
}

