/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.block.BlockAPGGlass;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderRouteBase;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class RenderAPGGlass
extends RenderRouteBase<BlockAPGGlass.TileEntityAPGGlass> {
    private static final float COLOR_STRIP_START = 0.75f;
    private static final float COLOR_STRIP_END = 0.78125f;

    public RenderAPGGlass(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher, 4.0f, 8.0f, false, (Property<Integer>)BlockAPGGlass.ARROW_DIRECTION);
        this.bottomPadding = 0.25f;
        this.topPadding = 0.5f;
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(IBlockReader world, BlockPos pos, BlockState state) {
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.LOWER) {
            return RenderRouteBase.RenderType.NONE;
        }
        if (Math.floorMod(pos.func_177958_n(), 8) < 4 == Math.floorMod(pos.func_177952_p(), 8) < 4) {
            return RenderRouteBase.RenderType.ARROW;
        }
        return RenderRouteBase.RenderType.ROUTE;
    }

    @Override
    protected void renderAdditional(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            IVertexBuilder vertexConsumer1 = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getColorStrip(platformId)));
            IDrawing.drawTexture(matrices, vertexConsumer1, isLeft ? this.sidePadding : 0.0f, 0.75f, 0.0f, isRight ? 1.0f - this.sidePadding : 1.0f, 0.78125f, 0.0f, facing, color, light);
            IDrawing.drawTexture(matrices, vertexConsumer1, isRight ? 1.0f - this.sidePadding : 1.0f, 0.75f, 0.125f, isLeft ? this.sidePadding : 0.0f, 0.78125f, 0.125f, facing, color, light);
            float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
            float height = 1.0f - this.topPadding - this.bottomPadding;
            IVertexBuilder vertexConsumer2 = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getStationName(platformId, width / height)));
            IDrawing.drawTexture(matrices, vertexConsumer2, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), this.topPadding, 0.125f, leftBlocks == 0 ? this.sidePadding : 0.0f, 1.0f - this.bottomPadding, 0.125f, ((float)rightBlocks - (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)leftBlocks + (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing, color, light);
        }
    }
}

