/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.block.BlockNode;
import mtr.block.IBlock;
import mtr.client.IDrawing;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RenderBoatNode
extends BlockEntityRendererMapper<BlockNode.TileEntityBoatNode> {
    public RenderBoatNode(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BlockNode.TileEntityBoatNode entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = world.func_180495_p(entity.func_174877_v());
        if (state.func_177230_c() instanceof BlockNode.BlockBoatNode && !((Boolean)IBlock.getStatePropertySafe(state, BlockNode.IS_CONNECTED)).booleanValue()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !RenderTrains.isHoldingRailRelated((PlayerEntity)player)) {
            return;
        }
        matrices.func_227860_a_();
        IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new ResourceLocation("textures/block/oak_log.png")));
        IDrawing.drawTexture(matrices, vertexConsumer, 0.25f, 0.0f, 0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.0f, 0.75f, 0.75f, 0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, Direction.EAST, -1, light);
        IDrawing.drawTexture(matrices, vertexConsumer, 0.75f, 0.0f, 0.25f, 0.75f, 0.0f, 0.75f, 0.25f, 0.0f, 0.75f, 0.25f, 0.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.75f, Direction.DOWN, -1, light);
        matrices.func_227865_b_();
    }
}

