/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.block.BlockClock;
import mtr.block.IBlock;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderClock
extends BlockEntityRendererMapper<BlockClock.TileEntityClock>
implements IGui,
IBlock {
    public RenderClock(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BlockClock.TileEntityClock entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        BlockState state = world.func_180495_p(pos);
        boolean rotated = (Boolean)IBlock.getStatePropertySafe(state, BlockClock.FACING);
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.3125, 0.5);
        if (rotated) {
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        }
        long time = world.func_72820_D() + 6000L;
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 12000.0f, true);
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 1000.0f, false);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 12000.0f, true);
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 1000.0f, false);
        matrices.func_227865_b_();
    }

    private static void drawHand(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, float rotation, boolean isHourHand) {
        matrices.func_227860_a_();
        matrices.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(rotation));
        IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
        IDrawing.drawTexture(matrices, vertexConsumer, -0.01f, isHourHand ? 0.15f : 0.24f, isHourHand ? 0.1f : 0.105f, 0.01f, -0.03f, isHourHand ? 0.1f : 0.105f, Direction.UP, -5592406, 0xF000B0);
        matrices.func_227865_b_();
    }
}

