/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mtr.MTRClient;
import mtr.block.BlockArrivalProjectorBase;
import mtr.block.BlockPIDSBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.data.Station;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.RenderTrains;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RenderPIDS<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui {
    private final float scale;
    private final float totalScaledWidth;
    private final float destinationStart;
    private final float destinationMaxWidth;
    private final float platformMaxWidth;
    private final float arrivalMaxWidth;
    private final int maxArrivals;
    private final float maxHeight;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final boolean rotate90;
    private final boolean renderArrivalNumber;
    private final boolean showAllPlatforms;
    private final int textColor;
    private final int firstTrainColor;
    private final boolean appendDotAfterMin;
    private static final int SWITCH_LANGUAGE_TICKS = 60;
    private static final int CAR_TEXT_COLOR = 0xFF0000;
    private static final int MAX_VIEW_DISTANCE = 16;

    public RenderPIDS(TileEntityRendererDispatcher dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, boolean showAllPlatforms, int textColor, int firstTrainColor, float textPadding, boolean appendDotAfterMin) {
        super(dispatcher);
        this.scale = (float)(160 * maxArrivals) / maxHeight * textPadding;
        this.totalScaledWidth = this.scale * (float)maxWidth / 16.0f;
        this.destinationStart = renderArrivalNumber ? this.scale * 2.0f / 16.0f : 0.0f;
        this.destinationMaxWidth = this.totalScaledWidth * 0.7f;
        this.platformMaxWidth = showAllPlatforms ? this.scale * 2.0f / 16.0f : 0.0f;
        this.arrivalMaxWidth = this.totalScaledWidth - this.destinationStart - this.destinationMaxWidth - this.platformMaxWidth;
        this.maxArrivals = maxArrivals;
        this.maxHeight = maxHeight;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.rotate90 = rotate90;
        this.renderArrivalNumber = renderArrivalNumber;
        this.showAllPlatforms = showAllPlatforms;
        this.textColor = textColor;
        this.firstTrainColor = firstTrainColor;
        this.appendDotAfterMin = appendDotAfterMin;
    }

    public RenderPIDS(TileEntityRendererDispatcher dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, boolean showAllPlatforms, int textColor, int firstTrainColor) {
        this(dispatcher, maxArrivals, startX, startY, startZ, maxHeight, maxWidth, rotate90, renderArrivalNumber, showAllPlatforms, textColor, firstTrainColor, 1.0f, false);
    }

    public void render(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        Direction facing = (Direction)IBlock.getStatePropertySafe((IBlockReader)world, pos, HorizontalBlock.field_185512_D);
        if (RenderTrains.shouldNotRender(pos, Math.min(16, RenderTrains.maxTrainRenderDistance), this.rotate90 ? null : facing)) {
            return;
        }
        String[] customMessages = new String[this.maxArrivals];
        boolean[] hideArrival = new boolean[this.maxArrivals];
        for (int i = 0; i < this.maxArrivals; ++i) {
            if (entity instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
                customMessages[i] = ((BlockPIDSBase.TileEntityBlockPIDSBase)((Object)entity)).getMessage(i);
                hideArrival[i] = ((BlockPIDSBase.TileEntityBlockPIDSBase)((Object)entity)).getHideArrival(i);
                continue;
            }
            customMessages[i] = "";
        }
        try {
            float carLengthMaxWidth;
            boolean showCarLength;
            HashSet schedules;
            HashMap platformIdToName = new HashMap();
            if (this.showAllPlatforms) {
                Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
                if (station == null) {
                    return;
                }
                Map<Long, Platform> platforms = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
                if (platforms.isEmpty()) {
                    return;
                }
                Set<Long> platformIds = entity instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase ? ((BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)((Object)entity)).getPlatformIds() : new HashSet<Long>();
                schedules = new HashSet();
                platforms.values().forEach(platform -> {
                    Set<ScheduleEntry> scheduleForPlatform;
                    if ((platformIds.isEmpty() || platformIds.contains(platform.id)) && (scheduleForPlatform = ClientData.SCHEDULES_FOR_PLATFORM.get(platform.id)) != null) {
                        scheduleForPlatform.forEach(scheduleEntry -> {
                            Route route = (Route)ClientData.DATA_CACHE.routeIdMap.get(scheduleEntry.routeId);
                            if (route != null && scheduleEntry.currentStationIndex < route.platformIds.size() - 1) {
                                schedules.add(scheduleEntry);
                                platformIdToName.put(platform.id, platform.name);
                            }
                        });
                    }
                });
            } else {
                HashSet schedulesForPlatform;
                long platformId = RailwayData.getClosePlatformId(ClientData.PLATFORMS, ClientData.DATA_CACHE, pos);
                schedules = platformId == 0L ? new HashSet() : ((schedulesForPlatform = ClientData.SCHEDULES_FOR_PLATFORM.get(platformId)) == null ? new HashSet() : schedulesForPlatform);
            }
            ArrayList scheduleList = new ArrayList(schedules);
            Collections.sort(scheduleList);
            if (!this.showAllPlatforms) {
                int maxCars = 0;
                int minCars = Integer.MAX_VALUE;
                for (ScheduleEntry scheduleEntry : scheduleList) {
                    int trainCars = scheduleEntry.trainCars;
                    if (trainCars > maxCars) {
                        maxCars = trainCars;
                    }
                    if (trainCars >= minCars) continue;
                    minCars = trainCars;
                }
                showCarLength = minCars != maxCars;
                carLengthMaxWidth = showCarLength ? this.scale * 6.0f / 16.0f : 0.0f;
            } else {
                showCarLength = false;
                carLengthMaxWidth = 0.0f;
            }
            for (int i = 0; i < this.maxArrivals; ++i) {
                boolean useCustomMessage;
                String destinationString;
                String[] destinationSplit;
                Route route;
                int languageTicks = (int)Math.floor(MTRClient.getGameTick()) / 60;
                ScheduleEntry currentSchedule = i < scheduleList.size() ? (ScheduleEntry)scheduleList.get(i) : null;
                Route route2 = route = currentSchedule == null ? null : (Route)ClientData.DATA_CACHE.routeIdMap.get(currentSchedule.routeId);
                if (i < scheduleList.size() && !hideArrival[i] && route != null) {
                    destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                    boolean isLightRailRoute = route.isLightRailRoute;
                    String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                    if (customMessages[i].isEmpty()) {
                        destinationString = (isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled(destinationSplit[languageTicks % destinationSplit.length]);
                        useCustomMessage = false;
                    } else {
                        String[] customMessageSplit = customMessages[i].split("\\|");
                        int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                        int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                        if (indexToUse < destinationMaxIndex) {
                            destinationString = (isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled(destinationSplit[languageTicks % destinationSplit.length]);
                            useCustomMessage = false;
                        } else {
                            destinationString = customMessageSplit[indexToUse - destinationMaxIndex];
                            useCustomMessage = true;
                        }
                    }
                } else {
                    destinationSplit = customMessages[i].split("\\|");
                    destinationString = destinationSplit[languageTicks % destinationSplit.length];
                    useCustomMessage = true;
                }
                matrices.func_227860_a_();
                matrices.func_227861_a_(0.5, 0.0, 0.5);
                matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(this.rotate90 ? 90 : 0) - facing.func_185119_l()));
                matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                matrices.func_227861_a_((double)((this.startX - 8.0f) / 16.0f), (double)(-this.startY / 16.0f + (float)i * this.maxHeight / (float)this.maxArrivals / 16.0f), (double)((this.startZ - 8.0f) / 16.0f - 0.00625f));
                matrices.func_227862_a_(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
                FontRenderer textRenderer = Minecraft.func_71410_x().field_71466_p;
                if (useCustomMessage) {
                    int destinationWidth = textRenderer.func_78256_a(destinationString);
                    if ((float)destinationWidth > this.totalScaledWidth) {
                        matrices.func_227862_a_(this.totalScaledWidth / (float)destinationWidth, 1.0f, 1.0f);
                    }
                    textRenderer.func_238421_b_(matrices, destinationString, 0.0f, 0.0f, this.textColor);
                } else {
                    String platformName;
                    int seconds = (int)((currentSchedule.arrivalMillis - System.currentTimeMillis()) / 1000L);
                    boolean isCJK = destinationString.codePoints().anyMatch(Character::isIdeographic);
                    IFormattableTextComponent arrivalText = seconds >= 60 ? new TranslationTextComponent(isCJK ? "gui.mtr.arrival_min_cjk" : "gui.mtr.arrival_min", new Object[]{seconds / 60}).func_240702_b_(this.appendDotAfterMin && !isCJK ? "." : "") : (seconds > 0 ? new TranslationTextComponent(isCJK ? "gui.mtr.arrival_sec_cjk" : "gui.mtr.arrival_sec", new Object[]{seconds}).func_240702_b_(this.appendDotAfterMin && !isCJK ? "." : "") : null);
                    TranslationTextComponent carText = new TranslationTextComponent(isCJK ? "gui.mtr.arrival_car_cjk" : "gui.mtr.arrival_car", new Object[]{currentSchedule.trainCars});
                    if (this.renderArrivalNumber) {
                        textRenderer.func_238421_b_(matrices, String.valueOf(i + 1), 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                    }
                    float newDestinationMaxWidth = this.destinationMaxWidth - carLengthMaxWidth;
                    if (this.showAllPlatforms && (platformName = (String)platformIdToName.get(route.platformIds.get(currentSchedule.currentStationIndex))) != null) {
                        textRenderer.func_238421_b_(matrices, platformName, this.destinationStart + newDestinationMaxWidth, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                    }
                    if (showCarLength) {
                        matrices.func_227860_a_();
                        matrices.func_227861_a_((double)(this.destinationStart + newDestinationMaxWidth + this.platformMaxWidth), 0.0, 0.0);
                        int carTextWidth = textRenderer.func_238414_a_((ITextProperties)carText);
                        if ((float)carTextWidth > carLengthMaxWidth) {
                            matrices.func_227862_a_(carLengthMaxWidth / (float)carTextWidth, 1.0f, 1.0f);
                        }
                        textRenderer.func_243248_b(matrices, (ITextComponent)carText, 0.0f, 0.0f, 0xFF0000);
                        matrices.func_227865_b_();
                    }
                    matrices.func_227860_a_();
                    matrices.func_227861_a_((double)this.destinationStart, 0.0, 0.0);
                    int destinationWidth = textRenderer.func_78256_a(destinationString);
                    if ((float)destinationWidth > newDestinationMaxWidth) {
                        matrices.func_227862_a_(newDestinationMaxWidth / (float)destinationWidth, 1.0f, 1.0f);
                    }
                    textRenderer.func_238421_b_(matrices, destinationString, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                    matrices.func_227865_b_();
                    if (arrivalText != null) {
                        matrices.func_227860_a_();
                        int arrivalWidth = textRenderer.func_238414_a_((ITextProperties)arrivalText);
                        if ((float)arrivalWidth > this.arrivalMaxWidth) {
                            matrices.func_227861_a_((double)(this.destinationStart + newDestinationMaxWidth + this.platformMaxWidth + carLengthMaxWidth), 0.0, 0.0);
                            matrices.func_227862_a_(this.arrivalMaxWidth / (float)arrivalWidth, 1.0f, 1.0f);
                        } else {
                            matrices.func_227861_a_((double)(this.totalScaledWidth - (float)arrivalWidth), 0.0, 0.0);
                        }
                        textRenderer.func_243248_b(matrices, (ITextComponent)arrivalText, 0.0f, 0.0f, this.textColor);
                        matrices.func_227865_b_();
                    }
                }
                matrices.func_227865_b_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

