/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockPSDAPGGlassEndBase;
import mtr.block.BlockPSDTop;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderRouteBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class RenderPSDTop
extends RenderRouteBase<BlockPSDTop.TileEntityPSDTop> {
    private static final float END_FRONT_OFFSET = 1.0f / (MathHelper.field_180189_a * 16.0f);
    private static final float BOTTOM_DIAGONAL_OFFSET = ((float)Math.sqrt(3.0) - 1.0f) / 32.0f;
    private static final float ROOT_TWO_SCALED = MathHelper.field_180189_a / 16.0f;
    private static final float BOTTOM_END_DIAGONAL_OFFSET = END_FRONT_OFFSET - BOTTOM_DIAGONAL_OFFSET / MathHelper.field_180189_a;
    private static final float TOP_PADDING = 0.46875f;
    private static final float BOTTOM_PADDING = 0.09375f;
    private static final float COLOR_STRIP_START = 0.90625f;
    private static final float COLOR_STRIP_END = 0.9375f;

    public RenderPSDTop(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher, 1.95f, 0.125f, true, (Property<Integer>)BlockPSDTop.ARROW_DIRECTION);
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(IBlockReader world, BlockPos pos, BlockState state) {
        BlockPSDTop.EnumPersistent persistent = IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT);
        if (persistent == BlockPSDTop.EnumPersistent.NONE) {
            this.topPadding = 0.46875f;
            this.bottomPadding = 0.09375f;
            Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (blockBelow instanceof BlockPSDAPGDoorBase) {
                return RenderRouteBase.RenderType.ARROW;
            }
            if (!(blockBelow instanceof BlockPSDAPGGlassEndBase)) {
                return RenderRouteBase.RenderType.ROUTE;
            }
            return RenderRouteBase.RenderType.NONE;
        }
        this.topPadding = 0.0f;
        this.bottomPadding = 0.5625f;
        return persistent == BlockPSDTop.EnumPersistent.ARROW ? RenderRouteBase.RenderType.ARROW : (persistent == BlockPSDTop.EnumPersistent.ROUTE ? RenderRouteBase.RenderType.ROUTE : RenderRouteBase.RenderType.NONE);
    }

    @Override
    protected void renderAdditionalUnmodified(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, BlockState state, Direction facing, int light) {
        boolean persistent;
        boolean airLeft = (Boolean)IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_LEFT);
        boolean airRight = (Boolean)IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_RIGHT);
        boolean bl = persistent = IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT) != BlockPSDTop.EnumPersistent.NONE;
        if (!airLeft && !airRight || persistent) {
            return;
        }
        IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new ResourceLocation("mtr:textures/block/psd_top.png")));
        if (airLeft) {
            IDrawing.drawTexture(matrices, vertexConsumer, -0.125f, 0.0f, 0.5f, 0.5f, 0.0f, -0.125f, 0.5f, 1.0f, -0.125f, -0.125f, 1.0f, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, -0.25f - END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, -0.25f - END_FRONT_OFFSET, 1.0f, 0.25f - END_FRONT_OFFSET, 0.5f - END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.0f, 1.0f, 0.9375f, facing.func_176734_d(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, -0.25f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, -0.25f - END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.9375f, 1.0f, 0.96875f, facing.func_176734_d(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f, 0.0f, -0.5f, -0.25f, 0.0f, 0.25f, -0.25f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, 0.5f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, 0.0f, 0.96875f, 1.0f, 1.0f, facing.func_176734_d(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f, 0.003125f, -0.125f, -0.125f, 0.003125f, 0.5f, -0.125f, 0.003125f, 0.125f, 0.5f, 0.003125f, -0.5f, 0.125f, 0.125f, 0.1875f, 0.1875f, facing, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f, 0.996875f, -0.5f, -0.125f, 0.996875f, 0.125f, -0.125f, 0.996875f, 0.5f, 0.5f, 0.996875f, -0.125f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f - END_FRONT_OFFSET, 0.996875f, -0.5f - END_FRONT_OFFSET, -0.125f - ROOT_TWO_SCALED, 0.996875f, 0.125f, -0.125f, 0.996875f, 0.125f, 0.5f, 0.996875f, -0.5f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f, 0.0625f, -0.5f, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.5f - END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.5f, 1.0f, -0.5f, 0.9375f, 0.0f, 1.0f, 0.9375f, facing, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.5f, 0.0f, -0.5f, 0.5f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.5f, 0.0625f, -0.5f, 0.9375f, 0.9375f, 1.0f, 1.0f, facing, -1, light);
        }
        if (airRight) {
            IDrawing.drawTexture(matrices, vertexConsumer, -0.5f, 0.0f, -0.125f, 0.125f, 0.0f, 0.5f, 0.125f, 1.0f, 0.5f, -0.5f, 1.0f, -0.125f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.25f + END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, -0.5f + END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.25f + END_FRONT_OFFSET, 1.0f, 0.25f - END_FRONT_OFFSET, 0.0f, 0.0f, 1.0f, 0.9375f, facing.func_176734_d(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.25f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, -0.5f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.25f + END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, 0.0f, 0.9375f, 1.0f, 0.96875f, facing.func_176734_d(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.25f, 0.0f, 0.25f, -0.5f, 0.0f, -0.5f, -0.5f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, 0.25f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, 0.0f, 0.96875f, 1.0f, 1.0f, facing.func_176734_d(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.125f, 0.003125f, 0.5f, -0.5f, 0.003125f, -0.125f, -0.5f, 0.003125f, -0.5f, 0.125f, 0.003125f, 0.125f, 0.125f, 0.125f, 0.1875f, 0.1875f, facing, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.125f, 0.996875f, 0.125f, -0.5f, 0.996875f, -0.5f, -0.5f, 0.996875f, -0.125f, 0.125f, 0.996875f, 0.5f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, 0.125f + ROOT_TWO_SCALED, 0.996875f, 0.125f, -0.5f + END_FRONT_OFFSET, 0.996875f, -0.5f - END_FRONT_OFFSET, -0.5f, 0.996875f, -0.5f, 0.125f, 0.996875f, 0.125f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, -0.5f, 0.0625f, -0.5f, -0.5f, 1.0f, -0.5f, -0.5f + END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.0f, 0.0625f, 0.9375f, facing, -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer, -0.5f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, -0.5f, 0.0f, -0.5f, -0.5f, 0.0625f, -0.5f, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.9375f, 0.0625f, 1.0f, facing, -1, light);
        }
    }

    @Override
    protected void renderAdditional(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
        boolean isNotPersistent = IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT) == BlockPSDTop.EnumPersistent.NONE;
        boolean airLeft = isNotPersistent && (Boolean)IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_LEFT) != false;
        boolean airRight = isNotPersistent && (Boolean)IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_RIGHT) != false;
        float persistentOffset = isNotPersistent ? 0.0f : 0.46875f;
        IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getColorStrip(platformId)));
        IDrawing.drawTexture(matrices, vertexConsumer, airLeft ? 0.625f : 0.0f, 0.90625f - persistentOffset, 0.0f, airRight ? 0.375f : 1.0f, 0.9375f - persistentOffset, 0.0f, facing, color, light);
        if (airLeft) {
            IDrawing.drawTexture(matrices, vertexConsumer, END_FRONT_OFFSET, 0.90625f - persistentOffset, -0.625f - END_FRONT_OFFSET, 0.75f + END_FRONT_OFFSET, 0.9375f - persistentOffset, 0.125f - END_FRONT_OFFSET, facing, -1, light);
        }
        if (airRight) {
            IDrawing.drawTexture(matrices, vertexConsumer, 0.25f - END_FRONT_OFFSET, 0.90625f - persistentOffset, 0.125f - END_FRONT_OFFSET, 1.0f - END_FRONT_OFFSET, 0.9375f - persistentOffset, -0.625f - END_FRONT_OFFSET, facing, -1, light);
        }
    }
}

