/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.CustomResources;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderRailwaySign<T extends BlockRailwaySign.TileEntityRailwaySign>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui,
IDrawing {
    public static final int HEIGHT_TO_SCALE = 27;

    public RenderRailwaySign(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockRailwaySign)) {
            return;
        }
        BlockRailwaySign block = (BlockRailwaySign)state.func_177230_c();
        if (((BlockRailwaySign.TileEntityRailwaySign)((Object)entity)).getSignIds().length != block.length) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, BlockStationNameBase.field_185512_D);
        String[] signIds = ((BlockRailwaySign.TileEntityRailwaySign)((Object)entity)).getSignIds();
        boolean renderBackground = false;
        int backgroundColor = 0;
        for (String signId : signIds) {
            CustomResources.CustomSign sign;
            if (signId == null || (sign = RenderRailwaySign.getSign(signId)) == null) continue;
            renderBackground = true;
            if (sign.backgroundColor == 0) continue;
            backgroundColor = sign.backgroundColor;
            break;
        }
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.53125, 0.5);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
        matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrices.func_227861_a_((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.07187500037252903);
        if (renderBackground) {
            IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
            IDrawing.drawTexture(matrices, vertexConsumer, 0.0f, 0.0f, 0.00625f, 0.5f * (float)signIds.length, 0.5f, 0.00625f, facing, backgroundColor | 0xFF000000, 0xF000F0);
        }
        for (int i = 0; i < signIds.length; ++i) {
            if (signIds[i] == null) continue;
            RenderRailwaySign.drawSign(matrices, vertexConsumers, Minecraft.func_71410_x().field_71466_p, pos, signIds[i], 0.5f * (float)i, 0.0f, 0.5f, i, signIds.length - i - 1, ((BlockRailwaySign.TileEntityRailwaySign)((Object)entity)).getSelectedIds(), facing, (textureId, x, y, size, flipTexture) -> {
                IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation(textureId.toString()), true));
                IDrawing.drawTexture(matrices, vertexConsumer, x, y, size, size, flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f, facing, -1, 0xF000F0);
            });
        }
        matrices.func_227865_b_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public static void drawSign(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, FontRenderer textRenderer, BlockPos pos, String signId, float x, float y, float size, float maxWidthLeft, float maxWidthRight, Set<Long> selectedIds, Direction facing, DrawTexture drawTexture) {
        IRenderTypeBuffer.Impl immediate;
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, facing)) {
            return;
        }
        CustomResources.CustomSign sign = RenderRailwaySign.getSign(signId);
        if (sign == null) {
            return;
        }
        float signSize = (sign.small ? 0.75f : 1.0f) * size;
        float margin = (size - signSize) / 2.0f;
        boolean hasCustomText = sign.hasCustomText();
        boolean flipCustomText = sign.flipCustomText;
        boolean flipTexture = sign.flipTexture;
        boolean isExit = signId.equals(BlockRailwaySign.SignType.EXIT_LETTER.toString()) || signId.equals(BlockRailwaySign.SignType.EXIT_LETTER_FLIPPED.toString());
        boolean isLine = signId.equals(BlockRailwaySign.SignType.LINE.toString()) || signId.equals(BlockRailwaySign.SignType.LINE_FLIPPED.toString());
        boolean isPlatform = signId.equals(BlockRailwaySign.SignType.PLATFORM.toString()) || signId.equals(BlockRailwaySign.SignType.PLATFORM_FLIPPED.toString());
        IRenderTypeBuffer.Impl impl = immediate = RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance / 2, null) ? null : IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        if (vertexConsumers != null && isExit) {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station == null) {
                return;
            }
            Map<String, List<String>> exits = station.getGeneratedExits();
            List selectedExitsSorted = selectedIds.stream().map(Station::deserializeExit).filter(exits::containsKey).sorted(String::compareTo).collect(Collectors.toList());
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(x + margin + (flipCustomText ? signSize : 0.0f)), (double)(y + margin), 0.0);
            float maxWidth = ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f;
            float exitWidth = signSize * (float)selectedExitsSorted.size();
            matrices.func_227862_a_(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
            IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/sign/exit_letter_blank.png"), true));
            for (int i = 0; i < selectedExitsSorted.size(); ++i) {
                String selectedExit = (String)selectedExitsSorted.get(flipCustomText ? selectedExitsSorted.size() - i - 1 : i);
                float offset = (float)(flipCustomText ? -1 : 1) * signSize * (float)i - (flipCustomText ? signSize : 0.0f);
                IDrawing.drawTexture(matrices, vertexConsumer, offset, 0.0f, 0.003125f, offset + signSize, signSize, 0.003125f, facing, -1, 0xF000F0);
                String selectedExitLetter = selectedExit.substring(0, 1);
                String selectedExitNumber = selectedExit.substring(1);
                boolean hasNumber = !selectedExitNumber.isEmpty();
                float space = hasNumber ? margin * 1.5f : 0.0f;
                IDrawing.drawStringWithFont(matrices, textRenderer, immediate, selectedExitLetter, hasNumber ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, offset + (hasNumber ? margin : signSize / 2.0f), signSize / 2.0f + margin, signSize - margin * 2.0f - space, signSize - margin, 1.0f, -1, false, 0xF000F0, null);
                if (hasNumber) {
                    IDrawing.drawStringWithFont(matrices, textRenderer, immediate, selectedExitNumber, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, offset + signSize - margin, signSize / 2.0f, space, signSize / 2.0f - margin / 4.0f, 1.0f, -1, false, 0xF000F0, null);
                }
                if (!(maxWidth > exitWidth) || selectedExitsSorted.size() != 1 || exits.get(selectedExit).isEmpty()) continue;
                IDrawing.drawStringWithFont(matrices, textRenderer, immediate, exits.get(selectedExit).get(0), flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, flipCustomText ? offset - margin : offset + signSize + margin, signSize / 2.0f, maxWidth - exitWidth - margin * 2.0f, signSize, 27.0f / signSize, -1, false, 0xF000F0, null);
            }
            matrices.func_227865_b_();
        } else if (vertexConsumers != null && isLine) {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station == null) {
                return;
            }
            Map<Integer, ClientCache.ColorNameTuple> routesInStation = ClientData.DATA_CACHE.stationIdToRoutes.get(station.id);
            if (routesInStation != null) {
                List selectedIdsSorted = selectedIds.stream().filter(selectedId -> RailwayData.isBetween(selectedId.longValue(), -2.147483648E9, 2.147483647E9)).map(Math::toIntExact).filter(routesInStation::containsKey).map(routesInStation::get).sorted(Comparator.comparingInt(route -> route.color)).collect(Collectors.toList());
                int selectedCount = selectedIdsSorted.size();
                float maxWidth = Math.max(0.0f, ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 1.5f);
                ArrayList textWidths = new ArrayList();
                for (ClientCache.ColorNameTuple route2 : selectedIdsSorted) {
                    IDrawing.drawStringWithFont(matrices, textRenderer, null, route2.name, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0.0f, 10000.0f, -1.0f, size - margin * 3.0f, 27.0f / (size - margin * 3.0f), 0, false, 0xF000F0, (x1, y1, x2, y2) -> textWidths.add(Float.valueOf(x2)));
                }
                matrices.func_227860_a_();
                matrices.func_227861_a_(flipCustomText ? (double)(x + size - margin) : (double)(x + margin), 0.0, 0.0);
                float totalTextWidth = textWidths.stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue() + 1.5f * margin * (float)selectedCount;
                if (totalTextWidth > maxWidth) {
                    matrices.func_227862_a_((maxWidth - margin / 2.0f) / (totalTextWidth - margin / 2.0f), 1.0f, 1.0f);
                }
                IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
                float xOffset = margin * 0.5f;
                for (int i = 0; i < selectedIdsSorted.size(); ++i) {
                    ClientCache.ColorNameTuple route3 = (ClientCache.ColorNameTuple)selectedIdsSorted.get(i);
                    IDrawing.drawStringWithFont(matrices, textRenderer, immediate, route3.name, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, flipCustomText ? -xOffset : xOffset, y + size / 2.0f, -1.0f, size - margin * 3.0f, 27.0f / (size - margin * 3.0f), -1, false, 0xF000F0, (x1, y1, x2, y2) -> IDrawing.drawTexture(matrices, vertexConsumer, x1 - margin / 2.0f, y + margin, 0.003125f, x2 + margin / 2.0f, y + size - margin, 0.003125f, facing, route.color | 0xFF000000, 0xF000F0));
                    xOffset += ((Float)textWidths.get(i)).floatValue() + margin * 1.5f;
                }
                matrices.func_227865_b_();
            }
        } else if (vertexConsumers != null && isPlatform) {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station == null) {
                return;
            }
            Map<Long, Platform> platformPositions = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
            if (platformPositions != null) {
                List selectedIdsSorted = selectedIds.stream().filter(platformPositions::containsKey).sorted(Comparator.comparing(platformPositions::get)).collect(Collectors.toList());
                int selectedCount = selectedIdsSorted.size();
                float extraMargin = margin - margin / (float)selectedCount;
                float height = (size - extraMargin * 2.0f) / (float)selectedCount;
                for (int i = 0; i < selectedIdsSorted.size(); ++i) {
                    float topOffset = (float)i * height + extraMargin;
                    float bottomOffset = (float)(i + 1) * height + extraMargin;
                    float left = flipCustomText ? x - maxWidthLeft * size : x + margin;
                    float right = flipCustomText ? x + size - margin : x + (maxWidthRight + 1.0f) * size;
                    IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(ClientData.DATA_CACHE.getDirectionArrow((Long)selectedIdsSorted.get(i), true, false, false, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, false, margin / size, (right - left) / (bottomOffset - topOffset), false), false));
                    IDrawing.drawTexture(matrices, vertexConsumer, left, topOffset, 0.0f, right, bottomOffset, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, 0xF000F0);
                }
            }
        } else {
            drawTexture.drawTexture(sign.textureId, x + margin, y + margin, signSize, flipTexture);
            if (hasCustomText) {
                float fixedMargin = size * 0.25f / 2.0f;
                boolean isSmall = sign.small;
                float maxWidth = Math.max(0.0f, (flipCustomText ? maxWidthLeft : maxWidthRight) * size - fixedMargin * (float)(isSmall ? 1 : 2));
                float start = flipCustomText ? x - (isSmall ? 0.0f : fixedMargin) : x + size + (isSmall ? 0.0f : fixedMargin);
                IDrawing.drawStringWithFont(matrices, textRenderer, immediate, isExit || isLine ? "..." : sign.customText, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, start, y + fixedMargin, maxWidth, size - fixedMargin * 2.0f, 0.01f, -1, false, 0xF000F0, null);
            }
        }
        if (immediate != null) {
            immediate.func_228461_a_();
        }
    }

    public static CustomResources.CustomSign getSign(String signId) {
        try {
            BlockRailwaySign.SignType sign = BlockRailwaySign.SignType.valueOf(signId);
            return new CustomResources.CustomSign(sign.textureId, sign.flipTexture, sign.customText, sign.flipCustomText, sign.small, sign.backgroundColor);
        }
        catch (Exception ignored) {
            return signId == null ? null : CustomResources.CUSTOM_SIGNS.get(signId);
        }
    }

    @FunctionalInterface
    public static interface DrawTexture {
        public void drawTexture(ResourceLocation var1, float var2, float var3, float var4, boolean var5);
    }
}

