/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class RenderRouteBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    protected float bottomPadding;
    protected float topPadding;
    protected final float sidePadding;
    private final float z;
    private final boolean transparentWhite;
    private final Property<Integer> arrowDirectionProperty;

    public RenderRouteBase(TileEntityRendererDispatcher dispatcher, float z, float sidePadding, boolean transparentWhite, Property<Integer> arrowDirectionProperty) {
        super(dispatcher);
        this.z = z / 16.0f;
        this.sidePadding = sidePadding / 16.0f;
        this.transparentWhite = transparentWhite;
        this.arrowDirectionProperty = arrowDirectionProperty;
    }

    public final void render(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        long platformId;
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        BlockState state = world.func_180495_p(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalBlock.field_185512_D);
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.0, 0.5);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
        this.renderAdditionalUnmodified(matrices, vertexConsumers, state, facing, light);
        if (!RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null) && (platformId = RailwayData.getClosePlatformId(ClientData.PLATFORMS, ClientData.DATA_CACHE, pos)) != 0L) {
            matrices.func_227861_a_(0.0, 1.0, 0.0);
            matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrices.func_227861_a_(-0.5, 0.0, (double)this.z);
            int leftBlocks = this.getTextureNumber((IBlockReader)world, pos, facing, true);
            int rightBlocks = this.getTextureNumber((IBlockReader)world, pos, facing, false);
            int colorByte = this.transparentWhite && facing.func_176740_k() == Direction.Axis.X ? 191 : 255;
            int color = 0xFF000000 | (colorByte << 16) + (colorByte << 8) + colorByte;
            RenderType renderType = this.getRenderType((IBlockReader)world, pos.func_177967_a(facing.func_176735_f(), leftBlocks), state);
            if ((renderType == RenderType.ARROW || renderType == RenderType.ROUTE) && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                int arrowDirection = IBlock.getStatePropertySafe(state, this.arrowDirectionProperty);
                IVertexBuilder vertexConsumer = renderType == RenderType.ARROW ? vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getDirectionArrow(platformId, false, (arrowDirection & 1) > 0, (arrowDirection & 2) > 0, IGui.HorizontalAlignment.CENTER, true, 0.25f, width / height, this.transparentWhite))) : vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getRouteMap(platformId, false, arrowDirection == 2, width / height, this.transparentWhite)));
                IDrawing.drawTexture(matrices, vertexConsumer, leftBlocks == 0 ? this.sidePadding : 0.0f, this.topPadding, 0.0f, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), 1.0f - this.bottomPadding, 0.0f, ((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing.func_176734_d(), color, light);
            }
            this.renderAdditional(matrices, vertexConsumers, platformId, state, leftBlocks, rightBlocks, facing.func_176734_d(), color, light);
        }
        matrices.func_227865_b_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    protected void renderAdditionalUnmodified(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, BlockState state, Direction facing, int light) {
    }

    protected boolean isLeft(BlockState state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.LEFT;
    }

    protected boolean isRight(BlockState state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.RIGHT;
    }

    protected abstract RenderType getRenderType(IBlockReader var1, BlockPos var2, BlockState var3);

    protected abstract void renderAdditional(MatrixStack var1, IRenderTypeBuffer var2, long var3, BlockState var5, int var6, int var7, Direction var8, int var9, int var10);

    private int getTextureNumber(IBlockReader world, BlockPos pos, Direction facing, boolean searchLeft) {
        BlockState state;
        int number = 0;
        Block thisBlock = world.func_180495_p(pos).func_177230_c();
        while ((state = world.func_180495_p(pos.func_177967_a(searchLeft ? facing.func_176735_f() : facing.func_176746_e(), number))).func_177230_c() == thisBlock) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            if (number != 0 && !(searchLeft ? !isRight : !isLeft)) break;
            ++number;
            if (!(searchLeft ? isLeft : isRight)) continue;
            break;
        }
        return number - 1;
    }

    protected static enum RenderType {
        ARROW,
        ROUTE,
        NONE;

    }
}

