/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import mtr.block.BlockRouteSignBase;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderRouteSign<T extends BlockRouteSignBase.TileEntityRouteSignBase>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    private static final float SIDE = 0.15625f;
    private static final float BOTTOM = 0.65625f;
    private static final float MIDDLE = 0.8125f;
    private static final float TOP = 0.96875f;
    private static final float WIDTH = 0.6875f;
    private static final float HEIGHT_BOTTOM = 1.15625f;
    private static final float HEIGHT_TOP = 0.15625f;
    private static final float TEXTURE_BREAK = 0.7027027f;

    public RenderRouteSign(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        BlockState state;
        Direction facing;
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, facing = (Direction)IBlock.getStatePropertySafe(state = world.func_180495_p(pos), BlockStationNameBase.field_185512_D))) {
            return;
        }
        boolean isTop = IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER;
        int arrowDirection = (Integer)IBlock.getStatePropertySafe(state, BlockRouteSignBase.ARROW_DIRECTION);
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        if (station == null) {
            return;
        }
        Map<Long, Platform> platformPositions = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
        if (platformPositions == null || platformPositions.isEmpty()) {
            return;
        }
        Platform platform = platformPositions.get(((BlockRouteSignBase.TileEntityRouteSignBase)((Object)entity)).getPlatformId());
        if (platform == null) {
            return;
        }
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.0, 0.5);
        matrices.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(facing.func_185119_l()));
        matrices.func_227861_a_(-0.5, 0.0, 0.43124999990686774);
        IVertexBuilder vertexConsumer1 = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getDirectionArrow(platform.id, true, (arrowDirection & 1) > 0, (arrowDirection & 2) > 0, IGui.HorizontalAlignment.CENTER, true, 0.2f, 4.4f, false)));
        IDrawing.drawTexture(matrices, vertexConsumer1, 0.84375f, 0.96875f + (float)(!isTop ? 1 : 0), 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing.func_176734_d(), -1, light);
        IVertexBuilder vertexConsumer2 = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(ClientData.DATA_CACHE.getRouteMap(platform.id, true, false, 1.6818181f, false)));
        IDrawing.drawTexture(matrices, vertexConsumer2, 0.84375f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.84375f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, isTop ? 0.7027027f : 1.0f, 1.0f, facing.func_176734_d(), -1, light);
        matrices.func_227865_b_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }
}

