/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import mtr.block.BlockNode;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.Rail;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class RenderSignalBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    protected final boolean isSingleSided;

    public RenderSignalBase(TileEntityRendererDispatcher dispatcher, boolean isSingleSided) {
        super(dispatcher);
        this.isSingleSided = isSingleSided;
    }

    public final void render(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockSignalLightBase) && !(state.func_177230_c() instanceof BlockSignalSemaphoreBase)) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalBlock.field_185512_D);
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        BlockPos startPos = RenderSignalBase.getNodePos((IBlockReader)world, pos, facing);
        if (startPos == null) {
            return;
        }
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.0, 0.5);
        for (int i = 0; i < 2; ++i) {
            Direction newFacing = i == 1 ? facing.func_176734_d() : facing;
            boolean isOccupied = false;
            boolean render = false;
            Map<BlockPos, Rail> railMap = ClientData.RAILS.get(startPos);
            if (railMap != null) {
                for (BlockPos endPos : railMap.keySet()) {
                    if (!railMap.get((Object)endPos).facingStart.similarFacing(newFacing.func_185119_l() + 90.0f)) continue;
                    render = true;
                    if (!ClientData.SIGNAL_BLOCKS.isOccupied(PathData.getRailProduct(startPos, endPos))) continue;
                    isOccupied = true;
                    break;
                }
            }
            if (render) {
                matrices.func_227860_a_();
                matrices.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(newFacing.func_185119_l()));
                IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
                this.render(matrices, vertexConsumers, vertexConsumer, entity, tickDelta, newFacing, isOccupied, i == 1);
                matrices.func_227865_b_();
            }
            if (this.isSingleSided) break;
        }
        matrices.func_227865_b_();
    }

    protected abstract void render(MatrixStack var1, IRenderTypeBuffer var2, IVertexBuilder var3, T var4, float var5, Direction var6, boolean var7, boolean var8);

    private static BlockPos getNodePos(IBlockReader world, BlockPos pos, Direction facing) {
        int[] checkDistance;
        for (int z : checkDistance = new int[]{0, 1, -1, 2, -2, 3, -3, 4, -4}) {
            for (int x : checkDistance) {
                for (int y = -5; y <= 0; ++y) {
                    BlockPos checkPos = pos.func_177981_b(y).func_177967_a(facing.func_176746_e(), x).func_177967_a(facing, z);
                    BlockState checkState = world.func_180495_p(checkPos);
                    if (!(checkState.func_177230_c() instanceof BlockNode)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

