/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.render.RenderTrains;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class RenderStationNameBase<T extends BlockStationNameBase.TileEntityStationNameBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    public RenderStationNameBase(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        int color;
        BlockState state;
        Direction facing;
        if (!((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).shouldRender()) {
            return;
        }
        World world = entity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.func_174877_v();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, facing = (Direction)IBlock.getStatePropertySafe(state = world.func_180495_p(pos), BlockStationNameBase.field_185512_D))) {
            return;
        }
        switch ((Integer)IBlock.getStatePropertySafe(state, BlockStationNameBase.COLOR)) {
            case 1: {
                color = -5592406;
                break;
            }
            case 2: {
                color = -16777216;
                break;
            }
            default: {
                color = -1;
            }
        }
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.5 + (double)((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).yOffset, 0.5);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
        matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrices.func_227861_a_(0.0, 0.0, 0.5 - (double)((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).zOffset - (double)0.003125f);
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.drawStationName((BlockStationNameBase.TileEntityStationNameBase)((Object)entity), matrices, vertexConsumers, immediate, station == null ? new TranslationTextComponent("gui.mtr.untitled").getString() : station.name, color, light);
        immediate.func_228461_a_();
        matrices.func_227865_b_();
    }

    protected abstract void drawStationName(BlockStationNameBase.TileEntityStationNameBase var1, MatrixStack var2, IRenderTypeBuffer var3, IRenderTypeBuffer.Impl var4, String var5, int var6, int var7);
}

