/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mtr.block.BlockStationNameBase;
import mtr.block.BlockStationNameEntrance;
import mtr.block.IBlock;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderStationNameBase;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RenderStationNameEntrance
extends RenderStationNameBase<BlockStationNameEntrance.TileEntityStationNameEntrance> {
    public RenderStationNameEntrance(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void drawStationName(BlockStationNameBase.TileEntityStationNameBase entity, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, IRenderTypeBuffer.Impl immediate, String stationName, int color, int light) {
        World world = entity.func_145831_w();
        BlockPos pos = entity.func_174877_v();
        if (world == null) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe((IBlockReader)world, pos, BlockStationNameBase.field_185512_D);
        int propagateProperty = (Integer)IBlock.getStatePropertySafe((IBlockReader)world, pos, BlockStationNameEntrance.STYLE);
        float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
        int length = this.getLength((IBlockReader)world, pos);
        IDrawing.drawStringWithFont(matrices, Minecraft.func_71410_x().field_71466_p, immediate, IGui.insertTranslation("gui.mtr.station_cjk", "gui.mtr.station", 1, stationName), IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, ((float)length + logoSize) / 2.0f - 0.5f, 0.0f, (float)length - logoSize, logoSize - 0.125f, 40.0f / logoSize, propagateProperty < 2 || propagateProperty >= 4 ? -1 : -16777216, false, 0xF000F0, (x1, y1, x2, y2) -> {
            IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getInterior(new ResourceLocation("mtr:textures/sign/logo.png")));
            IDrawing.drawTexture(matrices, vertexConsumer, x1 - logoSize, -logoSize / 2.0f, logoSize, logoSize, facing, 0xF000F0);
        });
    }

    private int getLength(IBlockReader world, BlockPos pos) {
        BlockState state;
        if (world == null) {
            return 1;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(world, pos, BlockStationNameEntrance.field_185512_D);
        int length = 1;
        while ((state = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), length))).func_177230_c() instanceof BlockStationNameEntrance) {
            ++length;
        }
        return length;
    }
}

