/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mtr.MTRClient;
import mtr.block.BlockNode;
import mtr.block.BlockPlatform;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.data.IGui;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TrainClient;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.entity.EntitySeat;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.EntityRendererMapper;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class RenderTrains
extends EntityRendererMapper<EntitySeat>
implements IGui {
    public static int maxTrainRenderDistance;
    public static String creatorModelFileName;
    public static JsonObject creatorModel;
    public static String creatorPropertiesFileName;
    public static JsonObject creatorProperties;
    public static String creatorTextureFileName;
    public static ResourceLocation creatorTexture;
    private static float lastRenderedTick;
    private static int prevPlatformCount;
    private static int prevSidingCount;
    private static UUID renderedUuid;
    public static final int PLAYER_RENDER_OFFSET = 1000;
    private static final Set<String> AVAILABLE_TEXTURES;
    private static final Set<String> UNAVAILABLE_TEXTURES;
    private static final int DETAIL_RADIUS = 32;
    private static final int DETAIL_RADIUS_SQUARED = 1024;
    private static final int MAX_RADIUS_REPLAY_MOD = 1024;
    private static final int TICKS_PER_SECOND = 20;
    private static final EntityModel<MinecartEntity> MODEL_MINECART;
    private static final EntityModel<BoatEntity> MODEL_BOAT;
    private static final Map<Long, FakeBoat> BOATS;

    public RenderTrains(Object parameter) {
        super(parameter);
    }

    public void render(EntitySeat entity, float entityYaw, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int entityLight) {
        RenderTrains.render(entity, tickDelta, matrices, vertexConsumers);
    }

    public ResourceLocation getTextureLocation(EntitySeat entity) {
        return null;
    }

    public static void render(EntitySeat entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers) {
        boolean useAnnouncements;
        boolean alreadyRendered;
        Minecraft client = Minecraft.func_71410_x();
        boolean backupRendering = entity == null;
        boolean bl = alreadyRendered = renderedUuid != null && (backupRendering || entity.func_110124_au() != renderedUuid);
        if (backupRendering) {
            renderedUuid = null;
        }
        ClientPlayerEntity player = client.field_71439_g;
        ClientWorld world = client.field_71441_e;
        if (alreadyRendered || player == null || world == null) {
            return;
        }
        if (!backupRendering) {
            renderedUuid = entity.func_110124_au();
        }
        int renderDistanceChunks = client.field_71474_y.field_151451_c;
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        boolean bl2 = useAnnouncements = Config.useTTSAnnouncements() || Config.showAnnouncementMessages();
        if (Config.useDynamicFPS()) {
            if ((double)lastFrameDuration > 0.5) {
                maxTrainRenderDistance = Math.max(maxTrainRenderDistance - (maxTrainRenderDistance - 32) / 2, 32);
            } else if ((double)lastFrameDuration < 0.4) {
                maxTrainRenderDistance = Math.min(maxTrainRenderDistance + 1, renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1));
            }
        } else {
            maxTrainRenderDistance = renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1);
        }
        matrices.func_227860_a_();
        if (!backupRendering) {
            double entityX = MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
            double entityY = MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
            double entityZ = MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
            matrices.func_227861_a_(-entityX, -entityY, -entityZ);
        }
        ActiveRenderInfo camera = client.field_71460_t.func_215316_n();
        float cameraYaw = camera.func_216778_f();
        Vector3d cameraOffset = camera.func_216770_i() ? player.func_174824_e(client.func_184121_ak()) : camera.func_216785_c();
        boolean secondF5 = Math.abs(Utilities.getYaw((Entity)player) - cameraYaw) > 90.0f;
        ClientData.TRAINS.forEach(arg_0 -> RenderTrains.lambda$render$15((World)world, client, lastFrameDuration, matrices, cameraOffset, player, cameraYaw, secondF5, vertexConsumers, camera, useAnnouncements, arg_0));
        if (!Config.hideTranslucentParts()) {
            ClientData.TRAINS.forEach(TrainClient::renderTranslucent);
        }
        matrices.func_227861_a_(0.0, 0.06562500004656613, 0.0);
        boolean renderColors = RenderTrains.isHoldingRailRelated((PlayerEntity)player);
        int maxRailDistance = renderDistanceChunks * 16;
        ClientData.RAILS.forEach((arg_0, arg_1) -> RenderTrains.lambda$render$19(renderColors, player, maxRailDistance, (World)world, vertexConsumers, matrices, arg_0, arg_1));
        matrices.func_227865_b_();
        lastRenderedTick = MTRClient.getGameTick();
        if (prevPlatformCount != ClientData.PLATFORMS.size() || prevSidingCount != ClientData.SIDINGS.size()) {
            ClientData.DATA_CACHE.sync();
        }
        prevPlatformCount = ClientData.PLATFORMS.size();
        prevSidingCount = ClientData.SIDINGS.size();
        ClientData.DATA_CACHE.clearDataIfNeeded();
    }

    public static boolean shouldNotRender(BlockPos pos, int maxDistance, Direction facing) {
        Entity camera = Minecraft.func_71410_x().field_175622_Z;
        return RenderTrains.shouldNotRender(camera == null ? null : camera.func_213303_ch(), pos, maxDistance, facing);
    }

    public static void clearTextureAvailability() {
        AVAILABLE_TEXTURES.clear();
        UNAVAILABLE_TEXTURES.clear();
    }

    public static boolean isHoldingRailRelated(PlayerEntity player) {
        return Utilities.isHolding(player, item -> item instanceof ItemNodeModifierBase || Block.func_149634_a((Item)item) instanceof BlockSignalLightBase || Block.func_149634_a((Item)item) instanceof BlockNode || Block.func_149634_a((Item)item) instanceof BlockSignalSemaphoreBase || Block.func_149634_a((Item)item) instanceof BlockPlatform);
    }

    private static double maxDistanceXZ(Vector3d pos1, BlockPos pos2) {
        return Math.max(Math.abs(pos1.field_72450_a - (double)pos2.func_177958_n()), Math.abs(pos1.field_72449_c - (double)pos2.func_177952_p()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldNotRender(Vector3d cameraPos, BlockPos pos, int maxDistance, Direction facing) {
        double playerZOffset;
        double playerXOffset;
        boolean playerFacingAway = cameraPos == null || facing == null ? false : (facing.func_176740_k() == Direction.Axis.X ? Math.signum(playerXOffset = cameraPos.field_72450_a - (double)pos.func_177958_n() - 0.5) == (double)facing.func_82601_c() && Math.abs(playerXOffset) >= 0.5 : Math.signum(playerZOffset = cameraPos.field_72449_c - (double)pos.func_177952_p() - 0.5) == (double)facing.func_82599_e() && Math.abs(playerZOffset) >= 0.5);
        if (cameraPos == null) return true;
        if (playerFacingAway) return true;
        double d = RenderTrains.maxDistanceXZ(cameraPos, pos);
        int n = MTRClient.isReplayMod() ? 1024 : maxDistance;
        if (!(d > (double)n)) return false;
        return true;
    }

    private static void renderWithLight(World world, double x, double y, double z, boolean noOffset, RenderCallback renderCallback) {
        BlockPos posAverage;
        Entity camera = Minecraft.func_71410_x().field_175622_Z;
        Vector3d cameraPos = camera == null ? null : camera.func_213303_ch();
        if (!RenderTrains.shouldNotRender(cameraPos, posAverage = new BlockPos(x + (noOffset || cameraPos == null ? 0.0 : cameraPos.field_72450_a), y + (noOffset || cameraPos == null ? 0.0 : cameraPos.field_72448_b), z + (noOffset || cameraPos == null ? 0.0 : cameraPos.field_72449_c)), Minecraft.func_71410_x().field_71474_y.field_151451_c * (Config.trainRenderDistanceRatio() + 1), null)) {
            renderCallback.renderCallback(LightTexture.func_228451_a_((int)world.func_226658_a_(LightType.BLOCK, posAverage), (int)world.func_226658_a_(LightType.SKY, posAverage)), posAverage);
        }
    }

    private static ITextComponent getStationText(Station station, String textKey) {
        if (station != null) {
            return new StringTextComponent(IGui.formatStationName(IGui.insertTranslation("gui.mtr." + textKey + "_station_cjk", "gui.mtr." + textKey + "_station", 1, IGui.textOrUntitled(station.name))));
        }
        return new StringTextComponent("");
    }

    private static void drawTexture(MatrixStack matrices, IVertexBuilder vertexConsumer, Vector3d pos1, Vector3d pos2, Vector3d pos3, Vector3d pos4, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, (float)pos1.field_72450_a, (float)pos1.field_72448_b, (float)pos1.field_72449_c, (float)pos2.field_72450_a, (float)pos2.field_72448_b, (float)pos2.field_72449_c, (float)pos3.field_72450_a, (float)pos3.field_72448_b, (float)pos3.field_72449_c, (float)pos4.field_72450_a, (float)pos4.field_72448_b, (float)pos4.field_72449_c, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -1, light);
    }

    private static ResourceLocation resolveTexture(TrainClientRegistry.TrainProperties trainProperties, Function<String, String> formatter) {
        boolean available;
        String textureString = formatter.apply(trainProperties.textureId);
        ResourceLocation id = new ResourceLocation(textureString);
        if (!AVAILABLE_TEXTURES.contains(textureString) && !UNAVAILABLE_TEXTURES.contains(textureString)) {
            available = Minecraft.func_71410_x().func_195551_G().func_219533_b(id);
            (available ? AVAILABLE_TEXTURES : UNAVAILABLE_TEXTURES).add(textureString);
            if (!available) {
                System.out.println("Texture " + textureString + " not found, using default");
            }
        } else {
            available = AVAILABLE_TEXTURES.contains(textureString);
        }
        if (available) {
            return id;
        }
        String textureId = TrainClientRegistry.getTrainProperties((String)trainProperties.baseTrainType.toString(), (TrainType)trainProperties.baseTrainType).textureId;
        return new ResourceLocation(textureId == null ? "mtr:textures/block/transparent.png" : formatter.apply(textureId));
    }

    private static ResourceLocation getConnectorTextureString(TrainClientRegistry.TrainProperties trainProperties, String connectorPart) {
        return RenderTrains.resolveTexture(trainProperties, textureId -> textureId + "_connector_" + connectorPart + ".png");
    }

    @Deprecated
    public static float getGameTicks() {
        return MTRClient.getGameTick();
    }

    private static /* synthetic */ void lambda$render$19(boolean renderColors, ClientPlayerEntity player, int maxRailDistance, World world, IRenderTypeBuffer vertexConsumers, MatrixStack matrices, BlockPos startPos, Map railMap) {
        railMap.forEach((endPos, rail) -> {
            boolean isBoat;
            boolean bl = isBoat = rail.transportMode == TransportMode.BOAT;
            if (isBoat && !renderColors || !RailwayData.isBetween(player.func_226277_ct_(), startPos.func_177958_n(), endPos.func_177958_n(), maxRailDistance) || !RailwayData.isBetween(player.func_226281_cx_(), startPos.func_177952_p(), endPos.func_177952_p(), maxRailDistance)) {
                return;
            }
            rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                BlockPos pos2 = new BlockPos(x1, y1, z1);
                if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                    return;
                }
                int light2 = LightTexture.func_228451_a_((int)world.func_226658_a_(LightType.BLOCK, pos2), (int)world.func_226658_a_(LightType.SKY, pos2));
                if (rail.railType == RailType.NONE) {
                    if (renderColors) {
                        IVertexBuilder vertexConsumerArrow = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new ResourceLocation("mtr:textures/block/one_way_rail_arrow.png")));
                        IDrawing.drawTexture(matrices, vertexConsumerArrow, (float)x1, (float)y1, (float)z1, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x3, (float)y2, (float)z3, (float)x4, (float)y2 + 0.003125f, (float)z4, 0.0f, 0.25f, 1.0f, 0.75f, Direction.UP, -1, light2);
                        IDrawing.drawTexture(matrices, vertexConsumerArrow, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x1, (float)y1, (float)z1, (float)x4, (float)y2 + 0.003125f, (float)z4, (float)x3, (float)y2, (float)z3, 0.0f, 0.25f, 1.0f, 0.75f, Direction.UP, -1, light2);
                    }
                } else {
                    float textureOffset = (float)((int)(x1 + z1) % 4) * 0.25f + (float)Config.trackTextureOffset() / 32.0f;
                    int color = renderColors || !Config.hideSpecialRailColors() && rail.railType.hasSavedRail ? rail.railType.color : -1;
                    IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new ResourceLocation(renderColors && rail.railType == RailType.QUARTZ ? "mtr:textures/block/rail_preview.png" : "textures/block/rail.png")));
                    IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1, (float)z1, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x3, (float)y2, (float)z3, (float)x4, (float)y2 + 0.003125f, (float)z4, 0.0f, 0.1875f + textureOffset, 1.0f, 0.3125f + textureOffset, Direction.UP, color, light2);
                    IDrawing.drawTexture(matrices, vertexConsumer, (float)x4, (float)y2 + 0.003125f, (float)z4, (float)x3, (float)y2, (float)z3, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x1, (float)y1, (float)z1, 0.0f, 0.1875f + textureOffset, 1.0f, 0.3125f + textureOffset, Direction.UP, color, light2);
                }
            }, isBoat ? -0.5f : -1.0f, isBoat ? 0.5f : 1.0f);
            if (renderColors) {
                List<SignalBlocks.SignalBlock> signalBlocks = ClientData.SIGNAL_BLOCKS.getSignalBlocksAtTrack(PathData.getRailProduct(startPos, endPos));
                float width = 1.0f / (float)DyeColor.values().length;
                for (int i = 0; i < signalBlocks.size(); ++i) {
                    SignalBlocks.SignalBlock signalBlock = signalBlocks.get(i);
                    boolean shouldGlow = signalBlock.isOccupied() && (int)Math.floor(MTRClient.getGameTick()) % 20 < 10;
                    IVertexBuilder vertexConsumer = shouldGlow ? vertexConsumers.getBuffer(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false)) : vertexConsumers.getBuffer(MoreRenderLayers.getExterior(new ResourceLocation("textures/block/white_wool.png")));
                    float u1 = width * (float)i + 1.0f - width * (float)signalBlocks.size() / 2.0f;
                    float u2 = u1 + width;
                    int color = 0xFF000000 | signalBlock.color.func_196055_e().field_76291_p;
                    rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                        BlockPos pos2 = new BlockPos(x1, y1, z1);
                        if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                            return;
                        }
                        int light2 = shouldGlow ? 0xF000F0 : LightTexture.func_228451_a_((int)world.func_226658_a_(LightType.BLOCK, pos2), (int)world.func_226658_a_(LightType.SKY, pos2));
                        IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1, (float)z1, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x3, (float)y2, (float)z3, (float)x4, (float)y2 + 0.003125f, (float)z4, u1, 0.0f, u2, 1.0f, Direction.UP, color, light2);
                        IDrawing.drawTexture(matrices, vertexConsumer, (float)x4, (float)y2 + 0.003125f, (float)z4, (float)x3, (float)y2, (float)z3, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x1, (float)y1, (float)z1, u1, 0.0f, u2, 1.0f, Direction.UP, color, light2);
                    }, u1 - 1.0f, u2 - 1.0f);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$render$15(World world, Minecraft client, float lastFrameDuration, MatrixStack matrices, Vector3d cameraOffset, ClientPlayerEntity player, float cameraYaw, boolean secondF5, IRenderTypeBuffer vertexConsumers, ActiveRenderInfo camera, boolean useAnnouncements, TrainClient train) {
        train.simulateTrain(world, client.func_147113_T() || lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration, (x, y, z, yaw, pitch, trainId, baseTrainType, isEnd1Head, isEnd2Head, head1IsFront, doorLeftValue, doorRightValue, opening, lightsOn, isTranslucent, playerOffset, ridingPositions) -> RenderTrains.renderWithLight(world, x, y, z, playerOffset == null, (light, posAverage) -> {
            TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId, baseTrainType);
            if (trainProperties.model == null && isTranslucent) {
                return;
            }
            matrices.func_227860_a_();
            if (playerOffset != null) {
                matrices.func_227861_a_(cameraOffset.field_72450_a, cameraOffset.field_72448_b, cameraOffset.field_72449_c);
                matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(Utilities.getYaw((Entity)player) - cameraYaw + (float)(secondF5 ? 180 : 0)));
                matrices.func_227861_a_(-playerOffset.field_72450_a, -playerOffset.field_72448_b, -playerOffset.field_72449_c);
            }
            matrices.func_227860_a_();
            matrices.func_227861_a_(x, y, z);
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.PI + yaw));
            matrices.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)Math.PI + pitch));
            if (trainProperties.model == null || trainProperties.textureId == null) {
                boolean isBoat = baseTrainType.transportMode == TransportMode.BOAT;
                matrices.func_227861_a_(0.0, isBoat ? 0.875 : 0.5, 0.0);
                matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                EntityModel<BoatEntity> model = isBoat ? MODEL_BOAT : MODEL_MINECART;
                IVertexBuilder vertexConsumer = vertexConsumers.getBuffer(model.func_228282_a_(RenderTrains.resolveTexture(trainProperties, textureId -> textureId + ".png")));
                if (isBoat) {
                    if (!BOATS.containsKey(train.id)) {
                        BOATS.put(train.id, new FakeBoat());
                    }
                    MODEL_BOAT.func_225597_a_((Entity)BOATS.get(train.id), (train.getSpeed() + 0.01f) * (doorLeftValue == 0.0f && doorRightValue == 0.0f ? lastFrameDuration : 0.0f), 0.0f, -0.1f, 0.0f, 0.0f);
                } else {
                    model.func_225597_a_(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
                }
                model.func_225598_a_(matrices, vertexConsumer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                boolean renderDetails = MTRClient.isReplayMod() || posAverage.func_177951_i((Vector3i)camera.func_216780_d()) <= 1024.0;
                trainProperties.model.render(matrices, vertexConsumers, RenderTrains.resolveTexture(trainProperties, textureId -> textureId + ".png"), light, doorLeftValue, doorRightValue, opening, isEnd1Head, isEnd2Head, head1IsFront, lightsOn, isTranslucent, renderDetails);
            }
            matrices.func_227865_b_();
            EntityRendererManager entityRenderDispatcher = client.func_175598_ae();
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 1000.0, 0.0);
            ridingPositions.forEach((uuid, offset) -> {
                PlayerEntity renderPlayer = world.func_217371_b(uuid);
                if (renderPlayer != null && (!uuid.equals(player.func_110124_au()) || camera.func_216770_i())) {
                    entityRenderDispatcher.func_229084_a_((Entity)renderPlayer, offset.field_72450_a, offset.field_72448_b, offset.field_72449_c, 0.0f, 1.0f, matrices, vertexConsumers, 0xF000F0);
                }
            });
            matrices.func_227865_b_();
            matrices.func_227865_b_();
        }), (prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, trainId, baseTrainType, lightsOn, playerOffset) -> RenderTrains.renderWithLight(world, x, y, z, playerOffset == null, (light, posAverage) -> {
            TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(trainId, baseTrainType);
            if (trainProperties.textureId == null) {
                return;
            }
            matrices.func_227860_a_();
            if (playerOffset != null) {
                matrices.func_227861_a_(cameraOffset.field_72450_a, cameraOffset.field_72448_b, cameraOffset.field_72449_c);
                matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(Utilities.getYaw((Entity)player) - cameraYaw + (float)(secondF5 ? 180 : 0)));
                matrices.func_227861_a_(-playerOffset.field_72450_a, -playerOffset.field_72448_b, -playerOffset.field_72449_c);
            }
            IVertexBuilder vertexConsumerExterior = vertexConsumers.getBuffer(MoreRenderLayers.getExterior(RenderTrains.getConnectorTextureString(trainProperties, "exterior")));
            RenderTrains.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, light);
            RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, light);
            RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos3, prevPos2, light);
            RenderTrains.drawTexture(matrices, vertexConsumerExterior, prevPos1, thisPos4, thisPos1, prevPos4, light);
            int lightOnLevel = lightsOn ? 0xF000B0 : light;
            IVertexBuilder vertexConsumerSide = vertexConsumers.getBuffer(MoreRenderLayers.getInterior(RenderTrains.getConnectorTextureString(trainProperties, "side")));
            RenderTrains.drawTexture(matrices, vertexConsumerSide, thisPos3, prevPos2, prevPos1, thisPos4, lightOnLevel);
            RenderTrains.drawTexture(matrices, vertexConsumerSide, prevPos3, thisPos2, thisPos1, prevPos4, lightOnLevel);
            RenderTrains.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getInterior(RenderTrains.getConnectorTextureString(trainProperties, "roof"))), prevPos2, thisPos3, thisPos2, prevPos3, lightOnLevel);
            RenderTrains.drawTexture(matrices, vertexConsumers.getBuffer(MoreRenderLayers.getInterior(RenderTrains.getConnectorTextureString(trainProperties, "floor"))), prevPos4, thisPos1, thisPos4, prevPos1, lightOnLevel);
            matrices.func_227865_b_();
        }), (speed, stopIndex, routeIds) -> {
            if (!(speed <= 5.0f) || !RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                ITextComponent text;
                switch ((int)(System.currentTimeMillis() / 1000L % 3L)) {
                    default: {
                        text = RenderTrains.getStationText(thisStation, "this");
                        break;
                    }
                    case 1: {
                        if (nextStation == null) {
                            text = RenderTrains.getStationText(thisStation, "this");
                            break;
                        }
                        text = RenderTrains.getStationText(nextStation, "next");
                        break;
                    }
                    case 2: {
                        text = RenderTrains.getStationText(lastStation, "last_" + thisRoute.transportMode.toString().toLowerCase());
                    }
                }
                player.func_146105_b(text, true);
            })) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.mtr.vehicle_speed", new Object[]{Float.valueOf(RailwayData.round(speed, 1)), Float.valueOf(RailwayData.round(speed * 3.6f, 1))}), true);
            }
        }, (stopIndex, routeIds) -> {
            if (useAnnouncements) {
                RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                    String nextRouteSplit;
                    ArrayList<String> messages = new ArrayList<String>();
                    String thisRouteSplit = thisRoute.name.split("\\|\\|")[0];
                    String string = nextRouteSplit = nextRoute == null ? null : nextRoute.name.split("\\|\\|")[0];
                    if (nextStation != null) {
                        Station nextFinalStation;
                        List<String> interchangeRoutes;
                        String mergedStations;
                        boolean isLightRailRoute = thisRoute.isLightRailRoute;
                        messages.add(IGui.insertTranslation(isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement_cjk" : "gui.mtr.next_station_announcement_cjk", isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement" : "gui.mtr.next_station_announcement", 1, nextStation.name));
                        Map<Integer, ClientCache.ColorNameTuple> routesInStation = ClientData.DATA_CACHE.stationIdToRoutes.get(nextStation.id);
                        if (routesInStation != null && !(mergedStations = IGui.mergeStations(interchangeRoutes = routesInStation.values().stream().filter(interchangeRoute -> {
                            String routeName = interchangeRoute.name.split("\\|\\|")[0];
                            return !routeName.equals(thisRouteSplit) && (nextRoute == null || !routeName.equals(nextRouteSplit));
                        }).map(interchangeRoute -> interchangeRoute.name).collect(Collectors.toList()), ", ")).isEmpty()) {
                            messages.add(IGui.insertTranslation("gui.mtr.interchange_announcement_cjk", "gui.mtr.interchange_announcement", 1, mergedStations));
                        }
                        if (lastStation != null && nextStation.id == lastStation.id && nextRoute != null && !nextRoute.platformIds.isEmpty() && !nextRouteSplit.equals(thisRouteSplit) && (nextFinalStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(nextRoute.platformIds.get(nextRoute.platformIds.size() - 1))) != null) {
                            String modeString = thisRoute.transportMode.toString().toLowerCase();
                            if (nextRoute.isLightRailRoute) {
                                messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_light_rail_announcement_cjk", "gui.mtr.next_route_" + modeString + "_light_rail_announcement", nextRoute.lightRailRouteNumber, 1, nextFinalStation.name.split("\\|\\|")[0]));
                            } else {
                                messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_announcement_cjk", "gui.mtr.next_route_" + modeString + "_announcement", 2, nextRouteSplit, nextFinalStation.name.split("\\|\\|")[0]));
                            }
                        }
                    }
                    IDrawing.narrateOrAnnounce(IGui.mergeStations(messages, " "));
                });
            }
        }, (stopIndex, routeIds) -> {
            if (useAnnouncements) {
                RailwayData.useRoutesAndStationsFromIndex(stopIndex, routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                    if (thisRoute.isLightRailRoute && lastStation != null) {
                        IDrawing.narrateOrAnnounce(IGui.insertTranslation("gui.mtr.light_rail_route_announcement_cjk", "gui.mtr.light_rail_route_announcement", thisRoute.lightRailRouteNumber, 1, lastStation.name));
                    }
                });
            }
        });
    }

    static {
        creatorModelFileName = "";
        creatorModel = new JsonObject();
        creatorPropertiesFileName = "";
        creatorProperties = new JsonObject();
        creatorTextureFileName = "";
        AVAILABLE_TEXTURES = new HashSet<String>();
        UNAVAILABLE_TEXTURES = new HashSet<String>();
        MODEL_MINECART = UtilitiesClient.getMinecartModel();
        MODEL_BOAT = UtilitiesClient.getBoatModel();
        BOATS = new HashMap<Long, FakeBoat>();
    }

    @FunctionalInterface
    private static interface RenderCallback {
        public void renderCallback(int var1, BlockPos var2);
    }

    private static class FakeBoat
    extends BoatEntity {
        private float progress;

        public FakeBoat() {
            super(EntityType.field_200793_g, null);
        }

        public float func_184448_a(int paddle, float newProgress) {
            this.progress += newProgress;
            return this.progress;
        }
    }
}

