/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.block.BlockArrivalProjectorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.ScreenMapper;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.WidgetBetterCheckbox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArrivalProjectorConfigScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final BlockPos pos;
    private final Set<Long> filterPlatformIds;
    private final WidgetBetterCheckbox selectAllCheckbox;
    private final Button filterButton;

    public ArrivalProjectorConfigScreen(BlockPos pos) {
        super((ITextComponent)new StringTextComponent(""));
        TileEntity entity;
        this.pos = pos;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        this.filterPlatformIds = world == null ? new HashSet<Long>() : ((entity = world.func_175625_s(pos)) instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase ? ((BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity).getPlatformIds() : new HashSet<Long>());
        this.selectAllCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.select_all_platforms"), checked -> {});
        this.filterButton = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> {
            Station station;
            if (this.field_230706_i_ != null && (station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos)) != null) {
                ArrayList<NameColorDataBase> platformsForList = new ArrayList<NameColorDataBase>();
                ArrayList<Platform> platforms = new ArrayList<Platform>(ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id).values());
                Collections.sort(platforms);
                platforms.stream().map(platform -> new DataConverter(platform.id, platform.name + " " + IGui.mergeStations(ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id).stream().map(route -> route.stationDetails.get((int)(route.stationDetails.size() - 1)).stationName).collect(Collectors.toList())), 0)).forEach(platformsForList::add);
                if (this.selectAllCheckbox.func_212942_a()) {
                    this.filterPlatformIds.clear();
                }
                UtilitiesClient.setScreen(this.field_230706_i_, new DashboardListSelectorScreen(() -> {
                    UtilitiesClient.setScreen(this.field_230706_i_, this);
                    this.selectAllCheckbox.setChecked(this.filterPlatformIds.isEmpty());
                }, platformsForList, this.filterPlatformIds, false, false));
            }
        });
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        IDrawing.setPositionAndWidth((Widget)this.selectAllCheckbox, 20, 20, 144);
        this.selectAllCheckbox.setChecked(this.filterPlatformIds.isEmpty());
        this.addDrawableChild(this.selectAllCheckbox);
        IDrawing.setPositionAndWidth((Widget)this.filterButton, 20, 60, 72);
        this.filterButton.func_238482_a_((ITextComponent)new TranslationTextComponent("selectWorld.edit"));
        this.addDrawableChild(this.filterButton);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.field_230712_o_.func_243248_b(matrices, (ITextComponent)new TranslationTextComponent("gui.mtr.filtered_platforms", new Object[]{this.selectAllCheckbox.func_212942_a() ? 0 : this.filterPlatformIds.size()}), 20.0f, 46.0f, -1);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_231175_as__() {
        if (this.selectAllCheckbox.func_212942_a()) {
            this.filterPlatformIds.clear();
        }
        PacketTrainDataGuiClient.sendArrivalProjectorConfigC2S(this.pos, this.filterPlatformIds);
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return false;
    }
}

