/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetSilentImageButton;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;

public class DashboardList
implements IGui {
    public int x;
    public int y;
    public int width;
    public int height;
    private final WidgetBetterTextField textFieldSearch;
    private final ImageButton buttonPrevPage;
    private final ImageButton buttonNextPage;
    private final ImageButton buttonFind;
    private final ImageButton buttonDrawArea;
    private final ImageButton buttonEdit;
    private final ImageButton buttonUp;
    private final ImageButton buttonDown;
    private final ImageButton buttonAdd;
    private final ImageButton buttonDelete;
    private final Supplier<String> getSearch;
    private final Consumer<String> setSearch;
    private List<NameColorDataBase> dataSorted = new ArrayList<NameColorDataBase>();
    private final Map<Integer, NameColorDataBase> dataFiltered = new HashMap<Integer, NameColorDataBase>();
    private int hoverIndex;
    private int page;
    private int totalPages;
    private boolean hasFind;
    private boolean hasDrawArea;
    private boolean hasEdit;
    private boolean hasSort;
    private boolean hasAdd;
    private boolean hasDelete;
    private static final int TOP_OFFSET = 24;

    public <T> DashboardList(BiConsumer<NameColorDataBase, Integer> onFind, BiConsumer<NameColorDataBase, Integer> onDrawArea, BiConsumer<NameColorDataBase, Integer> onEdit, Runnable onSort, BiConsumer<NameColorDataBase, Integer> onAdd, BiConsumer<NameColorDataBase, Integer> onDelete, Supplier<List<T>> getList, Supplier<String> getSearch, Consumer<String> setSearch) {
        this(onFind, onDrawArea, onEdit, onSort, onAdd, onDelete, getList, getSearch, setSearch, true);
    }

    public <T> DashboardList(BiConsumer<NameColorDataBase, Integer> onFind, BiConsumer<NameColorDataBase, Integer> onDrawArea, BiConsumer<NameColorDataBase, Integer> onEdit, Runnable onSort, BiConsumer<NameColorDataBase, Integer> onAdd, BiConsumer<NameColorDataBase, Integer> onDelete, Supplier<List<T>> getList, Supplier<String> getSearch, Consumer<String> setSearch, boolean playSound) {
        this.getSearch = getSearch;
        this.setSearch = setSearch;
        this.textFieldSearch = new WidgetBetterTextField(null, new TranslationTextComponent("gui.mtr.search").getString());
        this.buttonPrevPage = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_left.png"), 20, 40, button -> this.setPage(this.page - 1));
        this.buttonNextPage = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_right.png"), 20, 40, button -> this.setPage(this.page + 1));
        this.buttonFind = new WidgetSilentImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_find.png"), 20, 40, button -> this.onClick(onFind), playSound);
        this.buttonDrawArea = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_draw_area.png"), 20, 40, button -> this.onClick(onDrawArea));
        this.buttonEdit = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_edit.png"), 20, 40, button -> this.onClick(onEdit));
        this.buttonUp = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_up.png"), 20, 40, button -> {
            this.onUp(getList);
            onSort.run();
        });
        this.buttonDown = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_down.png"), 20, 40, button -> {
            this.onDown(getList);
            onSort.run();
        });
        this.buttonAdd = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_add.png"), 20, 40, button -> this.onClick(onAdd));
        this.buttonDelete = new ImageButton(0, 0, 0, 20, 0, 0, 20, new ResourceLocation("mtr:textures/gui/icon_delete.png"), 20, 40, button -> this.onClick(onDelete));
    }

    public void init(Consumer<Widget> addDrawableChild) {
        IDrawing.setPositionAndWidth((Widget)this.buttonPrevPage, this.x, this.y + 2, 20);
        IDrawing.setPositionAndWidth((Widget)this.buttonNextPage, this.x + 60, this.y + 2, 20);
        IDrawing.setPositionAndWidth((Widget)this.textFieldSearch, this.x + 80 + 2, this.y + 2, this.width - 80 - 4);
        this.textFieldSearch.func_212954_a(this.setSearch);
        this.textFieldSearch.func_146180_a(this.getSearch.get());
        this.buttonFind.field_230694_p_ = false;
        this.buttonDrawArea.field_230694_p_ = false;
        this.buttonEdit.field_230694_p_ = false;
        this.buttonUp.field_230694_p_ = false;
        this.buttonDown.field_230694_p_ = false;
        this.buttonAdd.field_230694_p_ = false;
        this.buttonDelete.field_230694_p_ = false;
        addDrawableChild.accept((Widget)this.buttonPrevPage);
        addDrawableChild.accept((Widget)this.buttonNextPage);
        addDrawableChild.accept((Widget)this.buttonFind);
        addDrawableChild.accept((Widget)this.buttonDrawArea);
        addDrawableChild.accept((Widget)this.buttonEdit);
        addDrawableChild.accept((Widget)this.buttonUp);
        addDrawableChild.accept((Widget)this.buttonDown);
        addDrawableChild.accept((Widget)this.buttonAdd);
        addDrawableChild.accept((Widget)this.buttonDelete);
        addDrawableChild.accept((Widget)this.textFieldSearch);
    }

    public void tick() {
        this.textFieldSearch.func_146178_a();
        this.buttonPrevPage.field_230690_l_ = this.x;
        this.buttonNextPage.field_230690_l_ = this.x + 60;
        this.textFieldSearch.field_230690_l_ = this.x + 80 + 2;
        String text = this.textFieldSearch.func_146179_b();
        this.dataFiltered.clear();
        for (int i = 0; i < this.dataSorted.size(); ++i) {
            if (!this.dataSorted.get((int)i).name.toLowerCase().contains(text.toLowerCase())) continue;
            this.dataFiltered.put(i, this.dataSorted.get(i));
        }
        int dataSize = this.dataFiltered.size();
        this.totalPages = dataSize == 0 ? 1 : (int)Math.ceil((double)dataSize / (double)this.itemsToShow());
        this.setPage(this.page);
    }

    public void setData(Set<? extends NameColorDataBase> dataSet, boolean hasFind, boolean hasDrawArea, boolean hasEdit, boolean hasSort, boolean hasAdd, boolean hasDelete) {
        ArrayList<? extends NameColorDataBase> dataList = new ArrayList<NameColorDataBase>(dataSet);
        Collections.sort(dataList);
        this.setData(dataList, hasFind, hasDrawArea, hasEdit, hasSort, hasAdd, hasDelete);
    }

    public void setData(List<? extends NameColorDataBase> dataList, boolean hasFind, boolean hasDrawArea, boolean hasEdit, boolean hasSort, boolean hasAdd, boolean hasDelete) {
        this.dataSorted = new ArrayList<NameColorDataBase>(dataList);
        this.hasFind = hasFind;
        boolean hasPermission = ClientData.hasPermission();
        this.hasDrawArea = hasPermission && hasDrawArea;
        this.hasEdit = hasPermission && hasEdit;
        this.hasSort = hasPermission && hasSort;
        this.hasAdd = hasPermission && hasAdd;
        this.hasDelete = hasPermission && hasDelete;
    }

    public void render(MatrixStack matrices, FontRenderer textRenderer) {
        IngameGui.func_238471_a_((MatrixStack)matrices, (FontRenderer)textRenderer, (String)String.format("%s/%s", this.page + 1, this.totalPages), (int)(this.x + 40), (int)(this.y + 6 + 2), (int)-1);
        int itemsToShow = this.itemsToShow();
        for (int i = 0; i < itemsToShow; ++i) {
            if (i + itemsToShow * this.page >= this.dataFiltered.size()) continue;
            int drawY = 20 * i + 6 + 24;
            ArrayList<Integer> sortedKeys = new ArrayList<Integer>(this.dataFiltered.keySet());
            Collections.sort(sortedKeys);
            NameColorDataBase data = this.dataFiltered.get(sortedKeys.get(i + itemsToShow * this.page));
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder buffer = tesselator.func_178180_c();
            UtilitiesClient.beginDrawingRectangle(buffer);
            IDrawing.drawRectangle((IVertexBuilder)buffer, this.x + 6, this.y + drawY, this.x + 6 + 8, this.y + drawY + 8, 0xFF000000 | data.color);
            tesselator.func_78381_a();
            UtilitiesClient.finishDrawingRectangle();
            String drawString = IGui.formatStationName(data.name);
            int textStart = 20;
            int textWidth = textRenderer.func_78256_a(drawString);
            int availableSpace = this.width - 20;
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(this.x + 20), 0.0, 0.0);
            if (textWidth > availableSpace) {
                matrices.func_227862_a_((float)availableSpace / (float)textWidth, 1.0f, 1.0f);
            }
            textRenderer.func_238421_b_(matrices, drawString, 0.0f, (float)(this.y + drawY), -1);
            matrices.func_227865_b_();
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.buttonFind.field_230694_p_ = false;
        this.buttonDrawArea.field_230694_p_ = false;
        this.buttonEdit.field_230694_p_ = false;
        this.buttonUp.field_230694_p_ = false;
        this.buttonDown.field_230694_p_ = false;
        this.buttonAdd.field_230694_p_ = false;
        this.buttonDelete.field_230694_p_ = false;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)(this.y + 24) && mouseY < (double)(this.y + 24 + 20 * this.itemsToShow())) {
            boolean hasSortFiltered;
            this.hoverIndex = ((int)mouseY - this.y - 24) / 20;
            int dataSize = this.dataFiltered.size();
            int itemsToShow = this.itemsToShow();
            boolean bl = hasSortFiltered = this.hasSort && dataSize == this.dataSorted.size();
            if (this.hoverIndex >= 0 && this.hoverIndex + this.page * itemsToShow < dataSize) {
                this.buttonFind.field_230694_p_ = this.hasFind;
                this.buttonDrawArea.field_230694_p_ = this.hasDrawArea;
                this.buttonEdit.field_230694_p_ = this.hasEdit;
                this.buttonUp.field_230694_p_ = hasSortFiltered;
                this.buttonDown.field_230694_p_ = hasSortFiltered;
                this.buttonAdd.field_230694_p_ = this.hasAdd;
                this.buttonDelete.field_230694_p_ = this.hasDelete;
                this.buttonUp.field_230693_o_ = this.hoverIndex + itemsToShow * this.page > 0;
                this.buttonDown.field_230693_o_ = this.hoverIndex + itemsToShow * this.page < dataSize - 1;
                int renderOffset = this.y + this.hoverIndex * 20 + 24;
                IDrawing.setPositionAndWidth((Widget)this.buttonFind, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0) + (this.hasEdit ? 1 : 0) + (this.hasDrawArea ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((Widget)this.buttonDrawArea, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0) + (this.hasEdit ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((Widget)this.buttonEdit, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0) + (hasSortFiltered ? 2 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((Widget)this.buttonUp, this.x + this.width - 20 * (2 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((Widget)this.buttonDown, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0) + (this.hasAdd ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((Widget)this.buttonAdd, this.x + this.width - 20 * (1 + (this.hasDelete ? 1 : 0)), renderOffset, 20);
                IDrawing.setPositionAndWidth((Widget)this.buttonDelete, this.x + this.width - 20, renderOffset, 20);
            }
        }
    }

    public void mouseScrolled(double mouseX, double mouseY, double amount) {
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            this.setPage(this.page + (int)Math.signum(-amount));
        }
    }

    public void clearSearch() {
        this.textFieldSearch.func_146180_a("");
    }

    private void setPage(int newPage) {
        this.page = MathHelper.func_76125_a((int)newPage, (int)0, (int)(this.totalPages - 1));
        this.buttonPrevPage.field_230694_p_ = this.page > 0;
        this.buttonNextPage.field_230694_p_ = this.page < this.totalPages - 1;
    }

    private void onClick(BiConsumer<NameColorDataBase, Integer> onClick) {
        int index;
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(this.dataFiltered.keySet());
        Collections.sort(sortedKeys);
        int sortedIndex = this.hoverIndex + this.itemsToShow() * this.page;
        if (sortedIndex >= 0 && sortedIndex < sortedKeys.size() && (index = ((Integer)sortedKeys.get(sortedIndex)).intValue()) >= 0 && index < this.dataSorted.size()) {
            onClick.accept(this.dataSorted.get(index), index);
        }
    }

    private <T> void onUp(Supplier<List<T>> getList) {
        if (this.textFieldSearch.func_146179_b().isEmpty()) {
            int index = this.hoverIndex + this.itemsToShow() * this.page;
            List<T> list = getList.get();
            T aboveItem = list.get(index - 1);
            T thisItem = list.get(index);
            list.set(index - 1, thisItem);
            list.set(index, aboveItem);
        }
    }

    private <T> void onDown(Supplier<List<T>> getList) {
        if (this.textFieldSearch.func_146179_b().isEmpty()) {
            int index = this.hoverIndex + this.itemsToShow() * this.page;
            List<T> list = getList.get();
            T thisItem = list.get(index);
            T belowItem = list.get(index + 1);
            list.set(index, belowItem);
            list.set(index + 1, thisItem);
        }
    }

    private int itemsToShow() {
        return (this.height - 24) / 20;
    }
}

