/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.mappings.ScreenMapper;
import mtr.mappings.UtilitiesClient;
import mtr.screen.DashboardList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DashboardListSelectorScreen
extends ScreenMapper
implements IGui {
    private final DashboardList availableList;
    private final DashboardList selectedList;
    private final Button buttonDone;
    private final ScreenMapper previousScreen;
    private final Runnable onClose;
    private final List<NameColorDataBase> allData;
    private final Collection<Long> selectedIds;
    private final boolean isSingleSelect;
    private final boolean canRepeat;

    public DashboardListSelectorScreen(Runnable onClose, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        this(null, onClose, allData, selectedIds, isSingleSelect, canRepeat);
    }

    public DashboardListSelectorScreen(ScreenMapper previousScreen, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        this(previousScreen, null, allData, selectedIds, isSingleSelect, canRepeat);
    }

    private DashboardListSelectorScreen(ScreenMapper previousScreen, Runnable onClose, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        super((ITextComponent)new StringTextComponent(""));
        this.previousScreen = previousScreen;
        this.onClose = onClose;
        this.allData = allData;
        this.selectedIds = selectedIds;
        this.isSingleSelect = isSingleSelect;
        this.canRepeat = canRepeat;
        this.availableList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.ROUTES_PLATFORMS_SEARCH, text -> {
            ClientData.ROUTES_PLATFORMS_SEARCH = text;
        });
        this.selectedList = new DashboardList(null, null, null, this::updateList, null, this::onDelete, () -> selectedIds instanceof ArrayList ? (List)selectedIds : new ArrayList(), () -> ClientData.ROUTES_PLATFORMS_SELECTED_SEARCH, text -> {
            ClientData.ROUTES_PLATFORMS_SELECTED_SEARCH = text;
        });
        this.buttonDone = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.func_231175_as__());
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.availableList.x = this.field_230708_k_ / 2 - 144 - 20;
        this.selectedList.x = this.field_230708_k_ / 2 + 20;
        this.selectedList.y = 40;
        this.availableList.y = 40;
        this.availableList.height = this.selectedList.height = this.field_230709_l_ - 100;
        this.selectedList.width = 144;
        this.availableList.width = 144;
        this.availableList.init(this::addDrawableChild);
        this.selectedList.init(this::addDrawableChild);
        IDrawing.setPositionAndWidth((Widget)this.buttonDone, (this.field_230708_k_ - 144) / 2, this.field_230709_l_ - 40, 144);
        this.addDrawableChild(this.buttonDone);
        this.updateList();
    }

    public void func_231023_e_() {
        this.availableList.tick();
        this.selectedList.tick();
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.availableList.render(matrices, this.field_230712_o_);
            this.selectedList.render(matrices, this.field_230712_o_);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
            DashboardListSelectorScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.mtr.available"), (int)(this.field_230708_k_ / 2 - 72 - 20), (int)26, (int)-1);
            DashboardListSelectorScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.mtr.selected"), (int)(this.field_230708_k_ / 2 + 72 + 20), (int)26, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.availableList.mouseMoved(mouseX, mouseY);
        this.selectedList.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        this.availableList.mouseScrolled(mouseX, mouseY, amount);
        this.selectedList.mouseScrolled(mouseX, mouseY, amount);
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        if (this.onClose != null) {
            this.onClose.run();
        }
        if (this.field_230706_i_ != null && this.previousScreen != null) {
            UtilitiesClient.setScreen(this.field_230706_i_, this.previousScreen);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void updateList() {
        ArrayList<NameColorDataBase> availableData = new ArrayList<NameColorDataBase>();
        for (NameColorDataBase data2 : this.allData) {
            if (!this.canRepeat && this.selectedIds.contains(data2.id)) continue;
            availableData.add(data2);
        }
        ArrayList selectedData = new ArrayList();
        for (long selectedId : this.selectedIds) {
            this.allData.stream().filter(data -> data.id == selectedId).findFirst().ifPresent(selectedData::add);
        }
        this.availableList.setData(availableData, false, false, false, false, true, false);
        this.selectedList.setData(selectedData, false, false, false, this.canRepeat, false, true);
    }

    private void onAdd(NameColorDataBase data, int index) {
        if (this.isSingleSelect) {
            this.selectedIds.clear();
        }
        this.selectedIds.add(data.id);
        this.updateList();
    }

    private void onDelete(NameColorDataBase data, int index) {
        if (this.canRepeat && this.selectedIds instanceof ArrayList) {
            ((ArrayList)this.selectedIds).remove(index);
        } else {
            this.selectedIds.remove(data.id);
        }
        this.updateList();
    }
}

