/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.AreaBase;
import mtr.data.DataConverter;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.ScreenMapper;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.ConfigScreen;
import mtr.screen.DashboardList;
import mtr.screen.DeleteConfirmationScreen;
import mtr.screen.EditDepotScreen;
import mtr.screen.EditRouteScreen;
import mtr.screen.EditStationScreen;
import mtr.screen.PlatformScreen;
import mtr.screen.RailActionsScreen;
import mtr.screen.SidingScreen;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetColorSelector;
import mtr.screen.WidgetMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DashboardScreen
extends ScreenMapper
implements IGui,
IPacket {
    private SelectedTab selectedTab;
    private AreaBase editingArea;
    private Route editingRoute;
    private boolean isNew;
    private final TransportMode transportMode;
    private final WidgetMap widgetMap;
    private final Button buttonTabStations;
    private final Button buttonTabRoutes;
    private final Button buttonTabDepots;
    private final Button buttonAddStation;
    private final Button buttonAddRoute;
    private final Button buttonAddDepot;
    private final Button buttonDoneEditingStation;
    private final Button buttonDoneEditingRoute;
    private final Button buttonDoneEditingDepot;
    private final Button buttonZoomIn;
    private final Button buttonZoomOut;
    private final Button buttonRailActions;
    private final Button buttonOptions;
    private final WidgetBetterTextField textFieldName;
    private final WidgetColorSelector colorSelector;
    private final DashboardList dashboardList;
    public static final int MAX_COLOR_ZONE_LENGTH = 6;
    private static final int COLOR_WIDTH = 48;

    public DashboardScreen(TransportMode transportMode) {
        super((ITextComponent)new StringTextComponent(""));
        this.transportMode = transportMode;
        this.textFieldName = new WidgetBetterTextField(null, new TranslationTextComponent("gui.mtr.name").getString());
        this.colorSelector = new WidgetColorSelector(this, this::toggleButtons);
        this.widgetMap = new WidgetMap(transportMode, this::onDrawCorners, this::onDrawCornersMouseRelease, this::onClickAddPlatformToRoute, this::onClickEditSavedRail, (arg_0, arg_1) -> ((WidgetColorSelector)this.colorSelector).func_231047_b_(arg_0, arg_1));
        this.buttonTabStations = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.stations"), button -> this.onSelectTab(SelectedTab.STATIONS));
        this.buttonTabRoutes = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.routes"), button -> this.onSelectTab(SelectedTab.ROUTES));
        this.buttonTabDepots = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.depots"), button -> this.onSelectTab(SelectedTab.DEPOTS));
        this.buttonAddStation = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.add_station"), button -> this.startEditingArea(new Station(), true));
        this.buttonAddRoute = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.add_route"), button -> this.startEditingRoute(new Route(transportMode), true));
        this.buttonAddDepot = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.add_depot"), button -> this.startEditingArea(new Depot(transportMode), true));
        this.buttonDoneEditingStation = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.onDoneEditingArea(true));
        this.buttonDoneEditingRoute = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.onDoneEditingRoute());
        this.buttonDoneEditingDepot = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.onDoneEditingArea(false));
        this.buttonZoomIn = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent("+"), button -> this.widgetMap.scale(1.0));
        this.buttonZoomOut = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent("-"), button -> this.widgetMap.scale(-1.0));
        this.buttonRailActions = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.rail_actions_button"), button -> {
            if (this.field_230706_i_ != null) {
                UtilitiesClient.setScreen(this.field_230706_i_, new RailActionsScreen());
            }
        });
        this.buttonOptions = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("menu.options"), button -> {
            if (this.field_230706_i_ != null) {
                UtilitiesClient.setScreen(this.field_230706_i_, new ConfigScreen());
            }
        });
        this.dashboardList = new DashboardList(this::onFind, this::onDrawArea, this::onEdit, this::onSort, null, this::onDelete, this::getList, () -> ClientData.DASHBOARD_SEARCH, text -> {
            ClientData.DASHBOARD_SEARCH = text;
        });
        this.onSelectTab(SelectedTab.STATIONS);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int tabCount = 3;
        int bottomRowY = this.field_230709_l_ - 20;
        this.widgetMap.setPositionAndSize(144, 0, this.field_230708_k_ - 144, this.field_230709_l_);
        IDrawing.setPositionAndWidth((Widget)this.buttonTabStations, 0, 0, 48);
        IDrawing.setPositionAndWidth((Widget)this.buttonTabRoutes, 48, 0, 48);
        IDrawing.setPositionAndWidth((Widget)this.buttonTabDepots, 96, 0, 48);
        IDrawing.setPositionAndWidth((Widget)this.buttonAddStation, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonAddRoute, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonAddDepot, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonDoneEditingStation, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonDoneEditingRoute, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonDoneEditingDepot, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonZoomIn, this.field_230708_k_ - 40, bottomRowY, 20);
        IDrawing.setPositionAndWidth((Widget)this.buttonZoomOut, this.field_230708_k_ - 20, bottomRowY, 20);
        IDrawing.setPositionAndWidth((Widget)this.buttonRailActions, this.field_230708_k_ - 200, bottomRowY, 100);
        IDrawing.setPositionAndWidth((Widget)this.buttonOptions, this.field_230708_k_ - 100, bottomRowY, 60);
        IDrawing.setPositionAndWidth((Widget)this.textFieldName, 2, bottomRowY - 20 - 2, 92);
        IDrawing.setPositionAndWidth((Widget)this.colorSelector, 98, bottomRowY - 20 - 2, 44);
        this.dashboardList.x = 0;
        this.dashboardList.y = 20;
        this.dashboardList.width = 144;
        this.dashboardList.height = this.field_230709_l_ - 40;
        this.buttonDoneEditingStation.field_230694_p_ = false;
        this.buttonDoneEditingRoute.field_230694_p_ = false;
        this.buttonDoneEditingDepot.field_230694_p_ = false;
        this.textFieldName.func_146189_e(false);
        this.colorSelector.field_230694_p_ = false;
        this.dashboardList.init(this::addDrawableChild);
        this.func_230481_d_(this.widgetMap);
        this.addDrawableChild(this.buttonTabStations);
        this.addDrawableChild(this.buttonTabRoutes);
        this.addDrawableChild(this.buttonTabDepots);
        this.addDrawableChild(this.buttonAddStation);
        this.addDrawableChild(this.buttonAddRoute);
        this.addDrawableChild(this.buttonAddDepot);
        this.addDrawableChild(this.buttonDoneEditingStation);
        this.addDrawableChild(this.buttonDoneEditingRoute);
        this.addDrawableChild(this.buttonDoneEditingDepot);
        this.addDrawableChild(this.buttonZoomIn);
        this.addDrawableChild(this.buttonZoomOut);
        this.addDrawableChild(this.buttonRailActions);
        this.addDrawableChild(this.buttonOptions);
        this.addDrawableChild(this.textFieldName);
        this.addDrawableChild(this.colorSelector);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.widgetMap.func_230430_a_(matrices, mouseX, mouseY, delta);
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 500.0);
            IngameGui.func_238467_a_((MatrixStack)matrices, (int)0, (int)0, (int)144, (int)this.field_230709_l_, (int)-15592942);
            this.dashboardList.render(matrices, this.field_230712_o_);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
            matrices.func_227865_b_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.dashboardList.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        this.dashboardList.mouseScrolled(mouseX, mouseY, amount);
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public void func_231023_e_() {
        this.textFieldName.func_146178_a();
        this.dashboardList.tick();
        try {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.editingArea == null) {
                        this.dashboardList.setData(ClientData.STATIONS, true, true, true, false, false, true);
                        break;
                    }
                    Map<Long, Platform> platformData = ClientData.DATA_CACHE.requestStationIdToPlatforms(this.editingArea.id);
                    this.dashboardList.setData(platformData == null ? new ArrayList() : new ArrayList<Platform>(platformData.values()), true, false, true, false, false, false);
                    break;
                }
                case ROUTES: {
                    if (this.editingRoute == null) {
                        this.dashboardList.setData(ClientData.getFilteredDataSet(this.transportMode, ClientData.ROUTES), false, true, true, false, false, true);
                        break;
                    }
                    List routeData = this.editingRoute.platformIds.stream().map(ClientData.DATA_CACHE.platformIdMap::get).filter(Objects::nonNull).map(platform -> {
                        Station station = (Station)ClientData.DATA_CACHE.platformIdToStation.get(platform.id);
                        if (station != null) {
                            return new DataConverter(String.format("%s (%s)", station.name, platform.name), station.color);
                        }
                        return new DataConverter(String.format("(%s)", platform.name), 0);
                    }).collect(Collectors.toList());
                    this.dashboardList.setData(routeData, false, false, false, true, false, true);
                    break;
                }
                case DEPOTS: {
                    if (this.editingArea == null) {
                        this.dashboardList.setData(ClientData.getFilteredDataSet(this.transportMode, ClientData.DEPOTS), true, true, true, false, false, true);
                        break;
                    }
                    Map<Long, Siding> sidingData = ClientData.DATA_CACHE.requestDepotIdToSidings(this.editingArea.id);
                    this.dashboardList.setData(sidingData == null ? new ArrayList() : new ArrayList<Siding>(sidingData.values()), true, false, true, false, false, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void onSelectTab(SelectedTab tab) {
        this.selectedTab = tab;
        this.buttonTabStations.field_230693_o_ = tab != SelectedTab.STATIONS;
        this.buttonTabRoutes.field_230693_o_ = tab != SelectedTab.ROUTES;
        this.buttonTabDepots.field_230693_o_ = tab != SelectedTab.DEPOTS;
        this.stopEditing();
        this.widgetMap.setShowStations(this.selectedTab != SelectedTab.DEPOTS);
    }

    private void onFind(NameColorDataBase data, int index) {
        if (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) {
            if (this.editingArea == null) {
                AreaBase area = (AreaBase)data;
                if (AreaBase.nonNullCorners(area)) {
                    this.widgetMap.find(((Integer)area.corner1.func_76341_a()).intValue(), ((Integer)area.corner1.func_76340_b()).intValue(), ((Integer)area.corner2.func_76341_a()).intValue(), ((Integer)area.corner2.func_76340_b()).intValue());
                }
            } else if (this.selectedTab == SelectedTab.STATIONS) {
                Platform platform = (Platform)data;
                this.widgetMap.find(platform.getMidPos());
            }
        }
    }

    private void onDrawArea(NameColorDataBase data, int index) {
        switch (this.selectedTab) {
            case STATIONS: 
            case DEPOTS: {
                if (this.editingArea != null) break;
                this.startEditingArea((AreaBase)data, false);
                break;
            }
            case ROUTES: {
                this.startEditingRoute((Route)data, false);
            }
        }
        this.dashboardList.clearSearch();
    }

    private void onEdit(NameColorDataBase data, int index) {
        if (this.field_230706_i_ != null) {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.editingArea == null) {
                        if (!(data instanceof Station)) break;
                        UtilitiesClient.setScreen(this.field_230706_i_, new EditStationScreen((Station)data, this));
                        break;
                    }
                    if (!(data instanceof Platform)) break;
                    UtilitiesClient.setScreen(this.field_230706_i_, new PlatformScreen((Platform)data, this));
                    break;
                }
                case ROUTES: {
                    UtilitiesClient.setScreen(this.field_230706_i_, new EditRouteScreen((Route)data, this));
                    break;
                }
                case DEPOTS: {
                    if (this.editingArea == null) {
                        if (!(data instanceof Depot)) break;
                        UtilitiesClient.setScreen(this.field_230706_i_, new EditDepotScreen((Depot)data, this.transportMode, this));
                        break;
                    }
                    if (!(data instanceof Siding)) break;
                    UtilitiesClient.setScreen(this.field_230706_i_, new SidingScreen((Siding)data, this.transportMode, this));
                }
            }
        }
    }

    private void onSort() {
        if (this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null) {
            this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
        }
    }

    private void onDelete(NameColorDataBase data, int index) {
        try {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.field_230706_i_ == null) break;
                    Station station = (Station)data;
                    UtilitiesClient.setScreen(this.field_230706_i_, new DeleteConfirmationScreen(() -> {
                        PacketTrainDataGuiClient.sendDeleteData(PACKET_DELETE_STATION, station.id);
                        ClientData.STATIONS.remove(station);
                    }, IGui.formatStationName(station.name), this));
                    break;
                }
                case ROUTES: {
                    if (this.editingRoute == null) {
                        if (this.field_230706_i_ == null) break;
                        Route route = (Route)data;
                        UtilitiesClient.setScreen(this.field_230706_i_, new DeleteConfirmationScreen(() -> {
                            PacketTrainDataGuiClient.sendDeleteData(PACKET_DELETE_ROUTE, route.id);
                            ClientData.ROUTES.remove(route);
                        }, IGui.formatStationName(route.name), this));
                        break;
                    }
                    this.editingRoute.platformIds.remove(index);
                    this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
                    break;
                }
                case DEPOTS: {
                    if (this.field_230706_i_ == null) break;
                    Depot depot = (Depot)data;
                    UtilitiesClient.setScreen(this.field_230706_i_, new DeleteConfirmationScreen(() -> {
                        PacketTrainDataGuiClient.sendDeleteData(PACKET_DELETE_DEPOT, depot.id);
                        ClientData.DEPOTS.remove(depot);
                    }, IGui.formatStationName(depot.name), this));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Long> getList() {
        return this.editingRoute == null ? new ArrayList() : this.editingRoute.platformIds;
    }

    private void startEditingArea(AreaBase editingArea, boolean isNew) {
        this.editingArea = editingArea;
        this.editingRoute = null;
        this.isNew = isNew;
        this.textFieldName.func_146180_a(editingArea.name);
        this.colorSelector.setColor(editingArea.color);
        this.widgetMap.startEditingArea(editingArea);
        this.toggleButtons();
    }

    private void startEditingRoute(Route editingRoute, boolean isNew) {
        this.editingArea = null;
        this.editingRoute = editingRoute;
        this.isNew = isNew;
        this.textFieldName.func_146180_a(editingRoute.name);
        this.colorSelector.setColor(editingRoute.color);
        this.widgetMap.startEditingRoute();
        this.toggleButtons();
    }

    private void onDrawCorners(Tuple<Integer, Integer> corner1, Tuple<Integer, Integer> corner2) {
        this.editingArea.corner1 = corner1;
        this.editingArea.corner2 = corner2;
        this.toggleButtons();
    }

    private void onDrawCornersMouseRelease() {
        this.editingArea.setCorners(packet -> PacketTrainDataGuiClient.sendUpdate(this.editingArea instanceof Station ? PACKET_UPDATE_STATION : PACKET_UPDATE_DEPOT, packet));
    }

    private void onClickAddPlatformToRoute(long platformId) {
        this.editingRoute.platformIds.add(platformId);
        this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
    }

    private void onClickEditSavedRail(SavedRailBase savedRail) {
        if (savedRail instanceof Platform) {
            UtilitiesClient.setScreen(Minecraft.func_71410_x(), new PlatformScreen((Platform)savedRail, this));
        } else if (savedRail instanceof Siding) {
            UtilitiesClient.setScreen(Minecraft.func_71410_x(), new SidingScreen((Siding)savedRail, this.transportMode, this));
        }
    }

    private void onDoneEditingArea(boolean isStation) {
        if (this.isNew) {
            try {
                if (isStation) {
                    ClientData.STATIONS.add((Station)this.editingArea);
                } else {
                    ClientData.DEPOTS.add((Depot)this.editingArea);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.editingArea.name = IGui.textOrUntitled(this.textFieldName.func_146179_b());
        this.editingArea.color = this.colorSelector.getColor();
        this.editingArea.setNameColor(packet -> PacketTrainDataGuiClient.sendUpdate(isStation ? PACKET_UPDATE_STATION : PACKET_UPDATE_DEPOT, packet));
        this.stopEditing();
    }

    private void onDoneEditingRoute() {
        if (this.isNew) {
            try {
                ClientData.ROUTES.add(this.editingRoute);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.editingRoute.name = IGui.textOrUntitled(this.textFieldName.func_146179_b());
        this.editingRoute.color = this.colorSelector.getColor();
        this.editingRoute.setNameColor(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
        this.stopEditing();
    }

    private void stopEditing() {
        this.editingArea = null;
        this.editingRoute = null;
        this.widgetMap.stopEditing();
        this.toggleButtons();
    }

    private void toggleButtons() {
        boolean showTextFields;
        boolean hasPermission = ClientData.hasPermission();
        this.buttonAddStation.field_230694_p_ = this.selectedTab == SelectedTab.STATIONS && this.editingArea == null && hasPermission;
        this.buttonAddRoute.field_230694_p_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute == null && hasPermission;
        this.buttonAddDepot.field_230694_p_ = this.selectedTab == SelectedTab.DEPOTS && this.editingArea == null && hasPermission;
        this.buttonDoneEditingStation.field_230694_p_ = this.selectedTab == SelectedTab.STATIONS && this.editingArea != null;
        this.buttonDoneEditingStation.field_230693_o_ = AreaBase.nonNullCorners(this.editingArea);
        this.buttonDoneEditingRoute.field_230694_p_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null;
        this.buttonDoneEditingDepot.field_230694_p_ = this.selectedTab == SelectedTab.DEPOTS && this.editingArea != null;
        this.buttonDoneEditingDepot.field_230693_o_ = AreaBase.nonNullCorners(this.editingArea);
        this.textFieldName.field_230694_p_ = showTextFields = (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) && this.editingArea != null || this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null;
        this.colorSelector.field_230694_p_ = showTextFields;
        this.dashboardList.height = this.field_230709_l_ - 40 - (showTextFields ? 24 : 0);
    }

    private static enum SelectedTab {
        STATIONS,
        ROUTES,
        DEPOTS;

    }
}

