/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Siding;
import mtr.data.TransportMode;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class EditDepotScreen
extends EditNameColorScreenBase<Depot> {
    private final int sliderX;
    private final int sliderWidthWithText;
    private final int rightPanelsX;
    private final Map<Long, Siding> sidingsInDepot;
    private final WidgetShorterSlider[] sliders = new WidgetShorterSlider[24];
    private final Button buttonEditInstructions;
    private final Button buttonGenerateRoute;
    private final Button buttonClearTrains;
    private static final int PANELS_START = 44;
    private static final int SLIDER_WIDTH = 64;
    private static final int MAX_TRAINS_PER_HOUR = 5;
    private static final int SECONDS_PER_MC_HOUR = 50;

    public EditDepotScreen(Depot depot, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(depot, dashboardScreen, "gui.mtr.depot_name", "gui.mtr.depot_color");
        this.sidingsInDepot = ClientData.DATA_CACHE.requestDepotIdToSidings(depot.id);
        this.field_230712_o_ = Minecraft.func_71410_x().field_71466_p;
        this.sliderX = this.field_230712_o_.func_78256_a(EditDepotScreen.getTimeString(0)) + 12;
        this.sliderWidthWithText = 70 + this.field_230712_o_.func_78256_a(EditDepotScreen.getSliderString(0));
        this.rightPanelsX = this.sliderX + 64 + 12 + this.field_230712_o_.func_78256_a(EditDepotScreen.getSliderString(1));
        int i = 0;
        while (i < 24) {
            int currentIndex = i++;
            this.sliders[currentIndex] = new WidgetShorterSlider(this.sliderX, 64, 10, EditDepotScreen::getSliderString, value -> {
                for (int j = 0; j < 24; ++j) {
                    if (j == currentIndex) continue;
                    this.sliders[j].setValue((int)value);
                }
            });
        }
        this.buttonEditInstructions = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.edit_instructions"), button -> {
            if (this.field_230706_i_ != null) {
                this.saveData();
                ArrayList<NameColorDataBase> routes = new ArrayList<NameColorDataBase>(ClientData.getFilteredDataSet(transportMode, ClientData.ROUTES));
                Collections.sort(routes);
                UtilitiesClient.setScreen(this.field_230706_i_, new DashboardListSelectorScreen(this, routes, ((Depot)this.data).routeIds, false, true));
            }
        });
        this.buttonGenerateRoute = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.refresh_path"), button -> {
            this.saveData();
            depot.clientPathGenerationSuccessfulSegments = -1;
            PacketTrainDataGuiClient.generatePathC2S(depot.id);
        });
        this.buttonClearTrains = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.clear_vehicles"), button -> {
            this.sidingsInDepot.values().forEach(Siding::clearTrains);
            PacketTrainDataGuiClient.clearTrainsC2S(this.sidingsInDepot.values());
        });
    }

    protected void func_231160_c_() {
        this.setPositionsAndInit(this.rightPanelsX, this.field_230708_k_ / 4 * 3, this.field_230708_k_);
        int buttonWidth = (this.field_230708_k_ - this.rightPanelsX) / 2;
        IDrawing.setPositionAndWidth((Widget)this.buttonEditInstructions, this.rightPanelsX, 44, buttonWidth * 2);
        IDrawing.setPositionAndWidth((Widget)this.buttonGenerateRoute, this.rightPanelsX, 64, buttonWidth);
        IDrawing.setPositionAndWidth((Widget)this.buttonClearTrains, this.rightPanelsX + buttonWidth, 64, buttonWidth);
        for (WidgetShorterSlider slider : this.sliders) {
            this.addDrawableChild(slider);
        }
        for (int i = 0; i < 24; ++i) {
            this.sliders[i].setValue(((Depot)this.data).getFrequency(i));
        }
        this.addDrawableChild(this.buttonEditInstructions);
        this.addDrawableChild(this.buttonGenerateRoute);
        this.addDrawableChild(this.buttonClearTrains);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.buttonGenerateRoute.field_230693_o_ = ((Depot)this.data).clientPathGenerationSuccessfulSegments >= 0;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.func_238473_b_(matrices, this.rightPanelsX - 1, -1, this.field_230709_l_, Integer.MAX_VALUE);
            this.renderTextFields(matrices);
            int lineHeight = Math.min(20, (this.field_230709_l_ - 20) / 24);
            for (int i = 0; i < 24; ++i) {
                EditDepotScreen.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)EditDepotScreen.getTimeString(i), (int)6, (int)(20 + lineHeight * i + (int)((float)(lineHeight - 8) / 2.0f)), (int)-1);
                this.sliders[i].field_230691_m_ = 20 + lineHeight * i;
                this.sliders[i].setHeight(lineHeight);
            }
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
            this.field_230712_o_.func_243248_b(matrices, (ITextComponent)new TranslationTextComponent("gui.mtr.sidings_in_depot", new Object[]{this.sidingsInDepot.size()}), (float)(this.rightPanelsX + 6), 90.0f, -1);
            String[] stringSplit = this.getSuccessfulSegmentsText().getString().split("\\|");
            for (int i = 0; i < stringSplit.length; ++i) {
                this.field_230712_o_.func_238421_b_(matrices, stringSplit[i], (float)(this.rightPanelsX + 6), (float)(110 + 14 * i), -1);
            }
            EditDepotScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.mtr.game_time"), (int)(this.sliderX / 2), (int)6, (int)-5592406);
            EditDepotScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.mtr.vehicles_per_hour"), (int)(this.sliderX + this.sliderWidthWithText / 2), (int)6, (int)-5592406);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        for (int i = 0; i < 24; ++i) {
            ((Depot)this.data).setFrequency(this.sliders[i].getIntValue(), i);
        }
        ((Depot)this.data).setData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_DEPOT, packet));
    }

    private ITextComponent getSuccessfulSegmentsText() {
        int successfulSegments = ((Depot)this.data).clientPathGenerationSuccessfulSegments;
        if (successfulSegments < 0) {
            return new TranslationTextComponent("gui.mtr.generating_path");
        }
        if (successfulSegments == 0) {
            return new TranslationTextComponent("gui.mtr.path_not_generated");
        }
        ArrayList<String> stationNames = new ArrayList<String>();
        ArrayList<String> routeNames = new ArrayList<String>();
        String depotName = IGui.textOrUntitled(IGui.formatStationName(((Depot)this.data).name));
        if (successfulSegments == 1) {
            RailwayData.useRoutesAndStationsFromIndex(0, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                stationNames.add(IGui.textOrUntitled(IGui.formatStationName(thisStation.name)));
                routeNames.add(IGui.textOrUntitled(IGui.formatStationName(thisRoute.name)));
            });
            stationNames.add("-");
            routeNames.add("-");
            return new TranslationTextComponent("gui.mtr.path_not_found_between", new Object[]{routeNames.get(0), depotName, stationNames.get(0)});
        }
        int sum = 0;
        for (int i = 0; i < ((Depot)this.data).routeIds.size(); ++i) {
            Route nextRoute2;
            Route thisRoute2 = (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(i));
            Route route = nextRoute2 = i < ((Depot)this.data).routeIds.size() - 1 ? (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(i + 1)) : null;
            if (thisRoute2 == null) continue;
            sum += thisRoute2.platformIds.size();
            if (thisRoute2.platformIds.isEmpty() || nextRoute2 == null || nextRoute2.platformIds.isEmpty() || !thisRoute2.platformIds.get(thisRoute2.platformIds.size() - 1).equals(nextRoute2.platformIds.get(0))) continue;
            --sum;
        }
        if (successfulSegments >= sum + 2) {
            return new TranslationTextComponent("gui.mtr.path_found");
        }
        RailwayData.useRoutesAndStationsFromIndex(successfulSegments - 2, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
            stationNames.add(IGui.textOrUntitled(IGui.formatStationName(thisStation.name)));
            if (nextStation == null) {
                RailwayData.useRoutesAndStationsFromIndex(successfulSegments - 1, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex1, thisRoute1, nextRoute1, thisStation1, nextStation1, lastStation1) -> stationNames.add(IGui.textOrUntitled(IGui.formatStationName(thisStation1.name))));
            } else {
                stationNames.add(IGui.textOrUntitled(IGui.formatStationName(nextStation.name)));
            }
            routeNames.add(IGui.textOrUntitled(IGui.formatStationName(thisRoute.name)));
        });
        stationNames.add("-");
        stationNames.add("-");
        routeNames.add("-");
        if (successfulSegments < sum + 1) {
            return new TranslationTextComponent("gui.mtr.path_not_found_between", new Object[]{routeNames.get(0), stationNames.get(0), stationNames.get(1)});
        }
        return new TranslationTextComponent("gui.mtr.path_not_found_between", new Object[]{routeNames.get(0), stationNames.get(0), depotName});
    }

    private static String getSliderString(int value) {
        String headwayText = value == 0 ? "" : " (" + RailwayData.round(200.0f / (float)value, 1) + new TranslationTextComponent("gui.mtr.s").getString() + ")";
        return (float)value / 4.0f + new TranslationTextComponent("gui.mtr.tph").getString() + headwayText;
    }

    private static String getTimeString(int hour) {
        String hourString = StringUtils.leftPad((String)String.valueOf(hour), (int)2, (String)"0");
        return String.format("%s:00-%s:59", hourString, hourString);
    }
}

