/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EditRouteScreen
extends EditNameColorScreenBase<Route>
implements IGui,
IPacket {
    private RouteType routeType;
    private final ITextComponent lightRailRouteNumberText = new TranslationTextComponent("gui.mtr.light_rail_route_number");
    private final WidgetBetterTextField textFieldLightRailRouteNumber = new WidgetBetterTextField(null, "");
    private final Button buttonRouteType = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.add_value"), button -> this.setRouteTypeText(((Route)this.data).transportMode, this.routeType.next()));
    private final WidgetBetterCheckbox buttonIsLightRailRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.is_light_rail_route"), this::setIsLightRailRoute);
    private final WidgetBetterCheckbox buttonIsRouteHidden = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.is_route_hidden"), this::setIsRouteHidden);
    private final WidgetBetterCheckbox buttonIsClockwiseRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.is_clockwise_route"), this::setIsClockwise);
    private final WidgetBetterCheckbox buttonIsAntiClockwiseRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.is_anticlockwise_route"), this::setIsAntiClockwise);
    private final boolean isCircular;
    private static final int CHECKBOX_WIDTH = 160;

    public EditRouteScreen(Route route, DashboardScreen dashboardScreen) {
        super(route, dashboardScreen, "gui.mtr.route_name", "gui.mtr.route_color");
        if (route.platformIds.size() > 0) {
            Station firstStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(route.platformIds.get(0));
            Station lastStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(route.platformIds.get(route.platformIds.size() - 1));
            this.isCircular = firstStation != null && lastStation != null && firstStation.id == lastStation.id;
        } else {
            this.isCircular = false;
        }
    }

    protected void func_231160_c_() {
        this.setPositionsAndInit(20, this.field_230708_k_ / 4 * 3 - 20, this.field_230708_k_ - 20);
        IDrawing.setPositionAndWidth((Widget)this.buttonRouteType, 20, 60, 160);
        this.setRouteTypeText(((Route)this.data).transportMode, ((Route)this.data).routeType);
        IDrawing.setPositionAndWidth((Widget)this.buttonIsRouteHidden, 20, 80, 160);
        IDrawing.setPositionAndWidth((Widget)this.buttonIsLightRailRoute, 20, 100, 160);
        IDrawing.setPositionAndWidth((Widget)this.textFieldLightRailRouteNumber, 22, 142, 156);
        this.textFieldLightRailRouteNumber.func_146180_a(((Route)this.data).lightRailRouteNumber);
        IDrawing.setPositionAndWidth((Widget)this.buttonIsClockwiseRoute, 20, 164, 160);
        IDrawing.setPositionAndWidth((Widget)this.buttonIsAntiClockwiseRoute, 20, 184, 160);
        this.addDrawableChild(this.buttonRouteType);
        this.addDrawableChild(this.textFieldLightRailRouteNumber);
        this.addDrawableChild(this.buttonIsLightRailRoute);
        this.addDrawableChild(this.buttonIsRouteHidden);
        if (this.isCircular) {
            this.addDrawableChild(this.buttonIsClockwiseRoute);
            this.addDrawableChild(this.buttonIsAntiClockwiseRoute);
        }
        this.setIsLightRailRoute(((Route)this.data).isLightRailRoute);
        this.setIsRouteHidden(((Route)this.data).isHidden);
        this.setIsClockwise(((Route)this.data).circularState == Route.CircularState.CLOCKWISE);
        this.setIsAntiClockwise(((Route)this.data).circularState == Route.CircularState.ANTICLOCKWISE);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.renderTextFields(matrices);
            if (this.textFieldLightRailRouteNumber.field_230694_p_) {
                EditRouteScreen.func_238475_b_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.lightRailRouteNumberText, (int)20, (int)126, (int)-1);
            }
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Route)this.data).routeType = this.routeType;
        ((Route)this.data).isLightRailRoute = this.buttonIsLightRailRoute.func_212942_a();
        ((Route)this.data).lightRailRouteNumber = this.textFieldLightRailRouteNumber.func_146179_b();
        ((Route)this.data).isHidden = this.buttonIsRouteHidden.func_212942_a();
        ((Route)this.data).circularState = this.isCircular ? (this.buttonIsClockwiseRoute.func_212942_a() ? Route.CircularState.CLOCKWISE : (this.buttonIsAntiClockwiseRoute.func_212942_a() ? Route.CircularState.ANTICLOCKWISE : Route.CircularState.NONE)) : Route.CircularState.NONE;
        ((Route)this.data).setExtraData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
    }

    private void setRouteTypeText(TransportMode transportMode, RouteType newRouteType) {
        this.routeType = newRouteType;
        this.buttonRouteType.func_238482_a_((ITextComponent)new TranslationTextComponent(String.format("gui.mtr.route_type_%s_%s", new Object[]{transportMode, this.routeType}).toLowerCase()));
    }

    private void setIsLightRailRoute(boolean isLightRailRoute) {
        this.buttonIsLightRailRoute.setChecked(isLightRailRoute);
        this.textFieldLightRailRouteNumber.field_230694_p_ = isLightRailRoute;
    }

    private void setIsRouteHidden(boolean isRouteHidden) {
        this.buttonIsRouteHidden.setChecked(isRouteHidden);
    }

    private void setIsClockwise(boolean isClockwise) {
        this.buttonIsClockwiseRoute.setChecked(isClockwise);
        if (isClockwise) {
            this.buttonIsAntiClockwiseRoute.setChecked(false);
        }
    }

    private void setIsAntiClockwise(boolean isAntiClockwise) {
        this.buttonIsAntiClockwiseRoute.setChecked(isAntiClockwise);
        if (isAntiClockwise) {
            this.buttonIsClockwiseRoute.setChecked(false);
        }
    }
}

