/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.NameColorDataBase;
import mtr.data.Station;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EditStationScreen
extends EditNameColorScreenBase<Station> {
    String editingExit;
    int editingDestinationIndex;
    private final ITextComponent stationZoneText = new TranslationTextComponent("gui.mtr.zone");
    private final ITextComponent exitParentsText = new TranslationTextComponent("gui.mtr.exit_parents");
    private final ITextComponent exitDestinationsText = new TranslationTextComponent("gui.mtr.exit_destinations");
    private final WidgetBetterTextField textFieldZone = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.INTEGER, "", 6);
    private final WidgetBetterTextField textFieldExitParentLetter = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.LETTER, "A", 1);
    private final WidgetBetterTextField textFieldExitParentNumber = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "1", 2);
    private final WidgetBetterTextField textFieldExitDestination = new WidgetBetterTextField(null, "");
    private final Button buttonAddExitParent = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.add_exit"), button -> this.changeEditingExit("", -1));
    private final Button buttonDoneExitParent = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.onDoneExitParent());
    private final Button buttonAddExitDestination = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.add_exit_destination"), button -> this.changeEditingExit(this.editingExit, station.exits.containsKey(this.editingExit) ? station.exits.get(this.editingExit).size() : -1));
    private final Button buttonDoneExitDestination = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.onDoneExitDestination());
    private final DashboardList exitParentList = new DashboardList(null, null, this::onEditExitParent, null, null, this::onDeleteExitParent, null, () -> ClientData.EXIT_PARENTS_SEARCH, text -> {
        ClientData.EXIT_PARENTS_SEARCH = text;
    });
    private final DashboardList exitDestinationList = new DashboardList(null, null, this::onEditExitDestination, this::onSortExitDestination, null, this::onDeleteExitDestination, this::getExitDestinationList, () -> ClientData.EXIT_DESTINATIONS_SEARCH, text -> {
        ClientData.EXIT_DESTINATIONS_SEARCH = text;
    });
    private static final int EXIT_PANELS_START = 70;

    public EditStationScreen(Station station, DashboardScreen dashboardScreen) {
        super(station, dashboardScreen, "gui.mtr.station_name", "gui.mtr.station_color");
    }

    protected void func_231160_c_() {
        this.setPositionsAndInit(0, this.field_230708_k_ / 2, this.field_230708_k_ / 4 * 3);
        IDrawing.setPositionAndWidth((Widget)this.textFieldZone, this.field_230708_k_ / 4 * 3 + 2, 22, this.field_230708_k_ / 4 - 4);
        int yExitText = this.field_230709_l_ - 40 - 2;
        IDrawing.setPositionAndWidth((Widget)this.textFieldExitParentLetter, 2, yExitText, this.field_230708_k_ / 4 - 4);
        IDrawing.setPositionAndWidth((Widget)this.textFieldExitParentNumber, 2 + this.field_230708_k_ / 4, yExitText, this.field_230708_k_ / 4 - 4);
        IDrawing.setPositionAndWidth((Widget)this.textFieldExitDestination, this.field_230708_k_ / 2 + 2, yExitText, this.field_230708_k_ / 2 - 4);
        IDrawing.setPositionAndWidth((Widget)this.buttonAddExitParent, 0, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        IDrawing.setPositionAndWidth((Widget)this.buttonDoneExitParent, 0, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        IDrawing.setPositionAndWidth((Widget)this.buttonAddExitDestination, this.field_230708_k_ / 2, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        IDrawing.setPositionAndWidth((Widget)this.buttonDoneExitDestination, this.field_230708_k_ / 2, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        this.textFieldZone.func_146180_a(String.valueOf(((Station)this.data).zone));
        this.exitParentList.x = 0;
        this.exitParentList.y = 70;
        this.exitParentList.height = this.field_230709_l_ - 70 - 20;
        this.exitParentList.width = this.field_230708_k_ / 2;
        this.exitDestinationList.x = this.field_230708_k_ / 2;
        this.exitDestinationList.y = 70;
        this.exitDestinationList.height = this.field_230709_l_ - 70 - 20;
        this.exitDestinationList.width = this.field_230708_k_ / 2;
        this.exitParentList.init(this::addDrawableChild);
        this.exitDestinationList.init(this::addDrawableChild);
        this.addDrawableChild(this.textFieldZone);
        this.addDrawableChild(this.textFieldExitParentLetter);
        this.addDrawableChild(this.textFieldExitParentNumber);
        this.addDrawableChild(this.textFieldExitDestination);
        this.addDrawableChild(this.buttonAddExitParent);
        this.addDrawableChild(this.buttonDoneExitParent);
        this.addDrawableChild(this.buttonAddExitDestination);
        this.addDrawableChild(this.buttonDoneExitDestination);
        this.changeEditingExit(null, -1);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.textFieldZone.func_146178_a();
        this.textFieldExitParentLetter.func_146178_a();
        this.textFieldExitParentNumber.func_146178_a();
        this.textFieldExitDestination.func_146178_a();
        this.exitParentList.tick();
        this.exitDestinationList.tick();
        List exitParents = ((Station)this.data).exits.keySet().stream().sorted().map(value -> {
            List<String> destinations = ((Station)this.data).exits.get(value);
            String additional = destinations.size() > 1 ? "(+" + (destinations.size() - 1) + ")" : "";
            return new DataConverter(destinations.size() > 0 ? value + "|" + destinations.get(0) + "|" + additional : value, 0);
        }).collect(Collectors.toList());
        this.exitParentList.setData(exitParents, false, false, true, false, false, true);
        ArrayList exitDestinations = this.parentExists() ? ((Station)this.data).exits.get(this.editingExit).stream().map(value -> new DataConverter((String)value, 0)).collect(Collectors.toList()) : new ArrayList();
        this.exitDestinationList.setData(exitDestinations, false, false, true, true, false, true);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.renderTextFields(matrices);
            this.func_238473_b_(matrices, this.field_230708_k_ / 2, 50, this.field_230709_l_, Integer.MAX_VALUE);
            this.exitParentList.render(matrices, this.field_230712_o_);
            this.exitDestinationList.render(matrices, this.field_230712_o_);
            EditStationScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.stationZoneText, (int)(this.field_230708_k_ / 8 * 7), (int)6, (int)-1);
            EditStationScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.exitParentsText, (int)(this.field_230708_k_ / 4), (int)56, (int)-1);
            if (this.parentExists()) {
                EditStationScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.exitDestinationsText, (int)(3 * this.field_230708_k_ / 4), (int)56, (int)-1);
            }
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.exitParentList.mouseMoved(mouseX, mouseY);
        this.exitDestinationList.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        this.exitParentList.mouseScrolled(mouseX, mouseY, amount);
        this.exitDestinationList.mouseScrolled(mouseX, mouseY, amount);
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    protected void saveData() {
        super.saveData();
        try {
            ((Station)this.data).zone = Integer.parseInt(this.textFieldZone.func_146179_b());
        }
        catch (Exception ignored) {
            ((Station)this.data).zone = 0;
        }
        ((Station)this.data).setZone(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
    }

    private void changeEditingExit(String editingExit, int editingDestinationIndex) {
        this.editingExit = editingExit;
        int n = this.editingDestinationIndex = this.parentExists() ? editingDestinationIndex : -1;
        if (editingExit != null) {
            this.textFieldExitParentLetter.func_146180_a(editingExit.toUpperCase().replaceAll("[^A-Z]", ""));
            this.textFieldExitParentNumber.func_146180_a(editingExit.replaceAll("[^0-9]", ""));
        }
        if (editingDestinationIndex >= 0 && editingDestinationIndex < ((Station)this.data).exits.get(editingExit).size()) {
            this.textFieldExitDestination.func_146180_a(((Station)this.data).exits.get(editingExit).get(editingDestinationIndex));
        } else {
            this.textFieldExitDestination.func_146180_a("");
        }
        this.textFieldExitParentLetter.field_230694_p_ = editingExit != null;
        this.textFieldExitParentNumber.field_230694_p_ = editingExit != null;
        this.textFieldExitDestination.field_230694_p_ = editingDestinationIndex >= 0;
        this.buttonAddExitParent.field_230694_p_ = editingExit == null;
        this.buttonDoneExitParent.field_230694_p_ = editingExit != null;
        this.buttonAddExitDestination.field_230694_p_ = this.parentExists() && editingDestinationIndex < 0;
        this.buttonDoneExitDestination.field_230694_p_ = editingDestinationIndex >= 0;
        this.exitDestinationList.x = this.parentExists() ? this.field_230708_k_ / 2 : this.field_230708_k_;
        this.exitParentList.height = this.field_230709_l_ - 70 - (editingExit == null ? 20 : 44);
        this.exitDestinationList.height = this.field_230709_l_ - 70 - (editingDestinationIndex >= 0 ? 44 : 20);
    }

    private void onDoneExitParent() {
        String parentLetter = this.textFieldExitParentLetter.func_146179_b();
        String parentNumber = this.textFieldExitParentNumber.func_146179_b();
        if (!parentLetter.isEmpty() && !parentNumber.isEmpty()) {
            try {
                String exitParent = parentLetter + Integer.parseInt(parentNumber);
                ((Station)this.data).setExitParent(this.editingExit, exitParent, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.changeEditingExit(null, -1);
    }

    private void onDoneExitDestination() {
        String destination = this.textFieldExitDestination.func_146179_b();
        if (this.parentExists() && this.editingDestinationIndex >= 0 && !destination.isEmpty()) {
            List<String> destinations = ((Station)this.data).exits.get(this.editingExit);
            if (this.editingDestinationIndex < destinations.size()) {
                destinations.set(this.editingDestinationIndex, destination);
            } else {
                destinations.add(destination);
            }
            ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onEditExitParent(NameColorDataBase listData, int index) {
        this.changeEditingExit(EditStationScreen.formatExitName(listData.name), -1);
    }

    private void onDeleteExitParent(NameColorDataBase listData, int index) {
        ((Station)this.data).deleteExitParent(EditStationScreen.formatExitName(listData.name), packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        this.changeEditingExit(null, -1);
    }

    private void onEditExitDestination(NameColorDataBase listData, int index) {
        this.changeEditingExit(this.editingExit, index);
    }

    private void onSortExitDestination() {
        ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onDeleteExitDestination(NameColorDataBase listData, int index) {
        if (this.parentExists()) {
            ((Station)this.data).exits.get(this.editingExit).remove(listData.name);
            ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private List<String> getExitDestinationList() {
        return this.parentExists() ? ((Station)this.data).exits.get(this.editingExit) : new ArrayList<String>();
    }

    private boolean parentExists() {
        return this.editingExit != null && ((Station)this.data).exits.containsKey(this.editingExit);
    }

    private static String formatExitName(String text) {
        return text.split("\\|")[0];
    }
}

