/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import mtr.block.BlockPIDSBase;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PIDSConfigScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final BlockPos pos1;
    private final BlockPos pos2;
    private final String[] messages;
    private final boolean[] hideArrival;
    private final WidgetBetterTextField[] textFieldMessages;
    private final WidgetBetterCheckbox[] buttonsHideArrival;
    private final ITextComponent messageText = new TranslationTextComponent("gui.mtr.pids_message");
    private final ITextComponent hideArrivalText = new TranslationTextComponent("gui.mtr.hide_arrival");
    private static final int MAX_MESSAGE_LENGTH = 2048;

    public PIDSConfigScreen(BlockPos pos1, BlockPos pos2, int maxArrivals) {
        super((ITextComponent)new StringTextComponent(""));
        TileEntity entity;
        int i;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.messages = new String[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.messages[i] = "";
        }
        this.hideArrival = new boolean[maxArrivals];
        this.textFieldMessages = new WidgetBetterTextField[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.textFieldMessages[i] = new WidgetBetterTextField(null, "", 2048);
        }
        this.buttonsHideArrival = new WidgetBetterCheckbox[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.buttonsHideArrival[i] = new WidgetBetterCheckbox(0, 0, 0, 20, this.hideArrivalText, checked -> {});
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_175625_s(pos1)) instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
            for (int i2 = 0; i2 < maxArrivals; ++i2) {
                this.messages[i2] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getMessage(i2);
                this.hideArrival[i2] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getHideArrival(i2);
            }
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int textWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.hideArrivalText) + 20 + 12;
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            WidgetBetterTextField textFieldMessage = this.textFieldMessages[i];
            IDrawing.setPositionAndWidth((Widget)textFieldMessage, 22, 42 + 24 * i, this.field_230708_k_ - 40 - 4 - textWidth);
            textFieldMessage.func_146180_a(this.messages[i]);
            this.addDrawableChild(textFieldMessage);
            WidgetBetterCheckbox buttonHideArrival = this.buttonsHideArrival[i];
            IDrawing.setPositionAndWidth((Widget)buttonHideArrival, this.field_230708_k_ - 20 - textWidth + 6, 42 + 24 * i, textWidth);
            buttonHideArrival.setChecked(this.hideArrival[i]);
            this.addDrawableChild(buttonHideArrival);
        }
    }

    public void func_231023_e_() {
        for (WidgetBetterTextField textFieldMessage : this.textFieldMessages) {
            textFieldMessage.func_146178_a();
        }
    }

    public void func_231175_as__() {
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            this.messages[i] = this.textFieldMessages[i].func_146179_b();
            this.hideArrival[i] = this.buttonsHideArrival[i].func_212942_a();
        }
        PacketTrainDataGuiClient.sendPIDSConfigC2S(this.pos1, this.pos2, this.messages, this.hideArrival);
        super.func_231175_as__();
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            this.field_230712_o_.func_243248_b(matrices, this.messageText, 26.0f, 26.0f, -1);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }
}

