/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mtr.client.DynamicTrainModel;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.mappings.ScreenMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.screen.DashboardList;
import mtr.screen.FileUploaderScreen;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ResourcePackCreatorScreen
extends ScreenMapper
implements IGui {
    private DynamicTrainModel model;
    private float translation;
    private float pitch;
    private float scale = 10.0f;
    private final List<DataConverter> partsListData = new ArrayList<DataConverter>();
    private final DashboardList partsList = new DashboardList(null, null, this::onEdit, null, null, null, null, () -> "", text -> {});
    private final Button buttonChooseBlockbenchFile = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> this.buttonCallback(path -> this.readJson((Path)path, (fileName, jsonObject) -> {
        jsonObject.remove("textures");
        this.updateModelFile((String)fileName, (JsonObject)jsonObject);
    })));
    private final Button buttonChoosePropertiesFile = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> this.buttonCallback(path -> this.readJson((Path)path, this::updatePropertiesFile)));
    private final Button buttonChooseTextureFile = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> this.buttonCallback(path -> {
        if (this.field_230706_i_ != null) {
            try {
                NativeImage nativeImage = NativeImage.func_195713_a((InputStream)Files.newInputStream(path, StandardOpenOption.READ));
                ResourceLocation identifier = this.field_230706_i_.func_110434_K().func_110578_a("mtr", new DynamicTexture(nativeImage));
                this.updateTextureFile(path.getFileName().toString(), identifier);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }));
    private static final int ARGB_INTERIOR = 16497668;
    private static final int ARGB_EXTERIOR = 3450963;

    public ResourcePackCreatorScreen() {
        super((ITextComponent)new StringTextComponent(""));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.updateModelFile(RenderTrains.creatorModelFileName, RenderTrains.creatorModel);
        this.updatePropertiesFile(RenderTrains.creatorPropertiesFileName, RenderTrains.creatorProperties);
        this.updateTextureFile(RenderTrains.creatorTextureFileName, RenderTrains.creatorTexture);
        this.partsList.y = 60;
        this.partsList.width = 144;
        this.partsList.height = this.field_230709_l_ - 60;
        IDrawing.setPositionAndWidth((Widget)this.buttonChooseBlockbenchFile, 0, 0, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonChoosePropertiesFile, 0, 20, 144);
        IDrawing.setPositionAndWidth((Widget)this.buttonChooseTextureFile, 0, 40, 144);
        this.partsList.init(this::addDrawableChild);
        this.addDrawableChild(this.buttonChooseBlockbenchFile);
        this.addDrawableChild(this.buttonChoosePropertiesFile);
        this.addDrawableChild(this.buttonChooseTextureFile);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.func_230446_a_(matrices);
            if (this.model != null && RenderTrains.creatorTexture != null && this.field_230706_i_ != null) {
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)((float)(this.field_230708_k_ - 144) / 2.0f + 144.0f + this.translation), (double)((float)this.field_230709_l_ / 2.0f), 250.0);
                matrices.func_227862_a_(this.scale, this.scale, -this.scale);
                matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrices.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.pitch));
                IRenderTypeBuffer.Impl immediate = this.field_230706_i_.func_228019_au_().func_228487_b_();
                this.model.render(matrices, (IRenderTypeBuffer)immediate, RenderTrains.creatorTexture, 0xF000B0, 0.0f, 0.0f, true, true, false, true, true, false, true);
                immediate.func_228461_a_();
                matrices.func_227865_b_();
            }
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 500.0);
            IngameGui.func_238467_a_((MatrixStack)matrices, (int)0, (int)0, (int)144, (int)this.field_230709_l_, (int)-15592942);
            this.partsList.render(matrices, this.field_230712_o_);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
            matrices.func_227865_b_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.partsList.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (mouseX > 144.0) {
            this.scale = (float)((double)this.scale + amount);
        }
        this.partsList.mouseScrolled(mouseX, mouseY, amount);
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX > 144.0) {
            this.pitch = (float)((double)this.pitch + deltaY / (double)this.scale);
            this.translation = (float)((double)this.translation + deltaX);
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void func_231023_e_() {
        this.partsList.tick();
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void updateModelFile(String fileName, JsonObject jsonObject) {
        jsonObject.remove("textures");
        this.buttonChooseBlockbenchFile.func_238482_a_((ITextComponent)(fileName.isEmpty() ? new TranslationTextComponent("gui.mtr.choose_blockbench_file") : new StringTextComponent(fileName)));
        RenderTrains.creatorModelFileName = fileName;
        RenderTrains.creatorModel = jsonObject;
        this.updateModel();
        boolean isNotEmpty = jsonObject.size() > 0;
        this.partsList.x = isNotEmpty ? 0 : this.field_230708_k_;
        this.partsListData.clear();
        if (isNotEmpty) {
            try {
                jsonObject.getAsJsonArray("outliner").forEach(jsonElement -> this.partsListData.add(new DataConverter(jsonElement.getAsJsonObject().get("name").getAsString(), 3450963)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.partsList.setData(this.partsListData, false, false, true, false, false, false);
    }

    private void updatePropertiesFile(String fileName, JsonObject jsonObject) {
        this.buttonChoosePropertiesFile.func_238482_a_((ITextComponent)(fileName.isEmpty() ? new TranslationTextComponent("gui.mtr.choose_properties_file") : new StringTextComponent(fileName)));
        RenderTrains.creatorPropertiesFileName = fileName;
        RenderTrains.creatorProperties = jsonObject;
        this.updateModel();
    }

    private void updateTextureFile(String fileName, ResourceLocation identifier) {
        this.buttonChooseTextureFile.func_238482_a_((ITextComponent)(fileName.isEmpty() ? new TranslationTextComponent("gui.mtr.choose_texture_file") : new StringTextComponent(fileName)));
        RenderTrains.creatorTextureFileName = fileName;
        RenderTrains.creatorTexture = identifier;
    }

    private void updateModel() {
        try {
            this.model = new DynamicTrainModel(RenderTrains.creatorModel, RenderTrains.creatorProperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onEdit(NameColorDataBase data, int index) {
    }

    private void buttonCallback(Consumer<Path> callback) {
        if (this.field_230706_i_ != null) {
            UtilitiesClient.setScreen(this.field_230706_i_, new FileUploaderScreen(this, paths -> {
                if (!paths.isEmpty()) {
                    try {
                        callback.accept((Path)paths.get(0));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
    }

    private void readJson(Path path, BiConsumer<String, JsonObject> jsonCallback) {
        try {
            jsonCallback.accept(path.getFileName().toString(), new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(path))).getAsJsonObject());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

