/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.data.DataConverter;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.SavedRailScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SidingScreen
extends SavedRailScreenBase<Siding> {
    private boolean isSelectingTrain;
    private final float oldAcceleration;
    private final TransportMode transportMode;
    private final Button buttonSelectTrain;
    private final DashboardList availableTrainsList;
    private final WidgetBetterCheckbox buttonUnlimitedTrains;
    private final WidgetBetterTextField textFieldMaxTrains;
    private final WidgetShorterSlider sliderAccelerationConstant;
    private static final ITextComponent SELECTED_TRAIN_TEXT = new TranslationTextComponent("gui.mtr.selected_vehicle");
    private static final ITextComponent MAX_TRAINS_TEXT = new TranslationTextComponent("gui.mtr.max_vehicles");
    private static final ITextComponent ACCELERATION_CONSTANT_TEXT = new TranslationTextComponent("gui.mtr.acceleration");
    private static final int MAX_TRAINS_TEXT_LENGTH = 3;
    private static final int MAX_TRAINS_WIDTH = 80;
    private static final float MAX_ACCELERATION = 0.05f;
    private static final float MIN_ACCELERATION = 0.001f;
    private static final int SLIDER_SCALE = 1000;
    private static final float ACCELERATION_UNIT_CONVERSION_1 = 400.0f;
    private static final float ACCELERATION_UNIT_CONVERSION_2 = 1440.0f;

    public SidingScreen(Siding siding, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(siding, dashboardScreen, SELECTED_TRAIN_TEXT, MAX_TRAINS_TEXT, ACCELERATION_CONSTANT_TEXT);
        this.transportMode = transportMode;
        this.buttonSelectTrain = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> this.onSelectingTrain());
        this.availableTrainsList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.TRAINS_SEARCH, text -> {
            ClientData.TRAINS_SEARCH = text;
        });
        this.textFieldMaxTrains = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "", 3);
        this.sliderAccelerationConstant = new WidgetShorterSlider(0, 80, Math.round(49.000004f), this::sliderFormatter, null);
        this.buttonUnlimitedTrains = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.unlimited_vehicles"), checked -> {
            if (checked && !this.textFieldMaxTrains.func_146179_b().isEmpty()) {
                this.textFieldMaxTrains.func_146180_a("");
            } else if (!checked && this.textFieldMaxTrains.func_146179_b().isEmpty()) {
                this.textFieldMaxTrains.func_146180_a("1");
            }
        });
        this.oldAcceleration = ((Siding)this.savedRailBase).getAccelerationConstant();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.setIsSelectingTrain(false);
        IDrawing.setPositionAndWidth((Widget)this.buttonSelectTrain, this.startX + this.textWidth, this.field_230709_l_ / 2 + 2, 240);
        IDrawing.setPositionAndWidth((Widget)this.buttonUnlimitedTrains, this.startX + this.textWidth + 80 + 4 + 2, this.field_230709_l_ / 2 + 4 + 2 + 20, 240);
        this.addDrawableChild(this.buttonSelectTrain);
        this.addDrawableChild(this.buttonUnlimitedTrains);
        this.availableTrainsList.y = 40;
        this.availableTrainsList.height = this.field_230709_l_ - 100;
        this.availableTrainsList.width = 240;
        this.availableTrainsList.init(this::addDrawableChild);
        this.buttonUnlimitedTrains.setChecked(((Siding)this.savedRailBase).getUnlimitedTrains());
        IDrawing.setPositionAndWidth((Widget)this.textFieldMaxTrains, this.startX + this.textWidth + 2, this.field_230709_l_ / 2 + 4 + 2 + 20, 76);
        this.textFieldMaxTrains.func_146180_a(((Siding)this.savedRailBase).getUnlimitedTrains() ? "" : String.valueOf(((Siding)this.savedRailBase).getMaxTrains() + 1));
        this.textFieldMaxTrains.func_212954_a(text -> this.buttonUnlimitedTrains.setChecked(text.isEmpty()));
        this.sliderAccelerationConstant.field_230690_l_ = this.startX + this.textWidth;
        this.sliderAccelerationConstant.field_230691_m_ = this.field_230709_l_ / 2 + 8 + 2 + 40;
        this.sliderAccelerationConstant.setHeight(20);
        this.sliderAccelerationConstant.setValue(Math.round((((Siding)this.savedRailBase).getAccelerationConstant() - 0.001f) * 1000.0f));
        this.addDrawableChild(this.textFieldMaxTrains);
        this.addDrawableChild(this.sliderAccelerationConstant);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.availableTrainsList.tick();
        this.textFieldMaxTrains.func_146178_a();
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (!this.isSelectingTrain) {
            this.field_230712_o_.func_243248_b(matrices, SELECTED_TRAIN_TEXT, (float)this.startX, (float)this.field_230709_l_ / 2.0f + 2.0f + 6.0f, -1);
            this.field_230712_o_.func_243248_b(matrices, MAX_TRAINS_TEXT, (float)this.startX, (float)this.field_230709_l_ / 2.0f + 4.0f + 2.0f + 6.0f + 20.0f, -1);
            this.field_230712_o_.func_243248_b(matrices, ACCELERATION_CONSTANT_TEXT, (float)this.startX, (float)this.field_230709_l_ / 2.0f + 8.0f + 2.0f + 6.0f + 40.0f, -1);
        }
    }

    @Override
    public void func_231175_as__() {
        float accelerationConstant;
        int maxTrains;
        try {
            maxTrains = Math.max(0, Integer.parseInt(this.textFieldMaxTrains.func_146179_b()) - 1);
        }
        catch (Exception ignored) {
            maxTrains = 0;
        }
        try {
            accelerationConstant = RailwayData.round(MathHelper.func_76131_a((float)((float)this.sliderAccelerationConstant.getIntValue() / 1000.0f + 0.001f), (float)0.001f, (float)0.05f), 3);
        }
        catch (Exception ignored) {
            accelerationConstant = 0.01f;
        }
        ((Siding)this.savedRailBase).setUnlimitedTrains(this.buttonUnlimitedTrains.func_212942_a(), maxTrains, this.oldAcceleration == accelerationConstant ? 0.0f : accelerationConstant, packet -> PacketTrainDataGuiClient.sendUpdate(this.getPacketIdentifier(), packet));
        super.func_231175_as__();
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.availableTrainsList.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        this.availableTrainsList.mouseScrolled(mouseX, mouseY, amount);
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    protected boolean shouldRenderExtra() {
        return this.isSelectingTrain;
    }

    @Override
    protected void renderExtra(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.availableTrainsList.render(matrices, this.field_230712_o_);
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.siding_number";
    }

    @Override
    protected ResourceLocation getPacketIdentifier() {
        return PACKET_UPDATE_SIDING;
    }

    private void onSelectingTrain() {
        ArrayList trainList = new ArrayList();
        TrainClientRegistry.forEach(this.transportMode, (id, trainProperties) -> trainList.add(new DataConverter(trainProperties.name.getString(), trainProperties.color)));
        this.availableTrainsList.setData(trainList, false, false, false, false, true, false);
        this.setIsSelectingTrain(true);
    }

    private void setIsSelectingTrain(boolean isSelectingTrain) {
        this.isSelectingTrain = isSelectingTrain;
        this.buttonSelectTrain.field_230694_p_ = !isSelectingTrain;
        this.buttonUnlimitedTrains.field_230694_p_ = !isSelectingTrain;
        this.textFieldMaxTrains.field_230694_p_ = !isSelectingTrain;
        this.sliderAccelerationConstant.field_230694_p_ = !isSelectingTrain;
        this.buttonSelectTrain.func_238482_a_((ITextComponent)TrainClientRegistry.getTrainProperties((String)((Siding)this.savedRailBase).getTrainId(), (TrainType)((Siding)this.savedRailBase).getBaseTrainType()).name);
        this.availableTrainsList.x = isSelectingTrain ? this.field_230708_k_ / 2 - 120 : this.field_230708_k_;
    }

    private void onAdd(NameColorDataBase data, int index) {
        ((Siding)this.savedRailBase).setTrainIdAndBaseType(TrainClientRegistry.getTrainId(this.transportMode, index), TrainClientRegistry.getTrainProperties((TransportMode)this.transportMode, (int)index).baseTrainType, packet -> PacketTrainDataGuiClient.sendUpdate(IPacket.PACKET_UPDATE_SIDING, packet));
        this.setIsSelectingTrain(false);
    }

    private String sliderFormatter(int value) {
        float valueMeterPerTickSquared = (float)value / 1000.0f + 0.001f;
        return String.format("%s m/s\u00b2 (%s km/h/s)", Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 400.0f, 1)), Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 1440.0f, 1)));
    }
}

