/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.stream.Collectors;
import mtr.block.BlockTrainAnnouncer;
import mtr.data.DataConverter;
import mtr.data.RailwayData;
import mtr.screen.DashboardList;
import mtr.screen.TrainSensorScreenBase;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;

public class TrainAnnouncerScreen
extends TrainSensorScreenBase {
    private final String initialMessage;
    private final String initialSoundIdString;
    private final DashboardList availableSoundsList;
    private static final int MAX_MESSAGE_LENGTH = 256;

    public TrainAnnouncerScreen(BlockPos pos) {
        super(pos, true, new Tuple((Object)new WidgetBetterTextField(null, "", 256), (Object)new TranslationTextComponent("gui.mtr.announcement_message")), new Tuple((Object)new WidgetBetterTextField(null, "", 256), (Object)new TranslationTextComponent("gui.mtr.sound_file")));
        this.field_230706_i_ = Minecraft.func_71410_x();
        ClientWorld world = this.field_230706_i_.field_71441_e;
        if (world != null) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer) {
                this.initialMessage = ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).getMessage();
                this.initialSoundIdString = ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).getSoundIdString();
            } else {
                this.initialMessage = "";
                this.initialSoundIdString = "";
            }
        } else {
            this.initialMessage = "";
            this.initialSoundIdString = "";
        }
        this.availableSoundsList = new DashboardList((data, color) -> {
            String soundIdString = data.name;
            if (!soundIdString.isEmpty() && world != null && this.field_230706_i_.field_71439_g != null) {
                world.func_184156_a(pos, new SoundEvent(new ResourceLocation(soundIdString)), SoundCategory.BLOCKS, 1000000.0f, 1.0f, true);
            }
        }, null, null, null, (data, color) -> {
            this.textFields[1].func_146180_a(data.name);
            this.setListVisibility(false);
        }, null, null, () -> "", text -> {}, false);
        this.availableSoundsList.setData(Minecraft.func_71410_x().func_147118_V().func_195477_a().stream().map(soundId -> new DataConverter(soundId.toString(), -15592942)).sorted().collect(Collectors.toList()), true, false, false, false, true, false);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.textFields[0].func_146180_a(this.initialMessage);
        this.textFields[1].func_146180_a(this.initialSoundIdString);
        this.setListVisibility(false);
        this.availableSoundsList.y = 58;
        this.availableSoundsList.height = this.field_230709_l_ - this.availableSoundsList.y - 20;
        this.availableSoundsList.width = this.field_230708_k_ / 2 - 20;
        this.availableSoundsList.init(this::addDrawableChild);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.availableSoundsList.tick();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (RailwayData.isBetween(mouseX, this.textFields[1].field_230690_l_, this.textFields[1].field_230690_l_ + this.textFields[1].func_230998_h_()) && RailwayData.isBetween(mouseY, this.textFields[1].field_230691_m_, this.textFields[1].field_230691_m_ + this.textFields[1].func_238483_d_())) {
                this.setListVisibility(true);
            } else if (!RailwayData.isBetween(mouseX, this.availableSoundsList.x, this.availableSoundsList.x + this.availableSoundsList.width) || !RailwayData.isBetween(mouseY, this.availableSoundsList.y, this.availableSoundsList.y + this.availableSoundsList.height)) {
                this.setListVisibility(false);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.availableSoundsList.mouseMoved(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        this.availableSoundsList.mouseScrolled(mouseX, mouseY, amount);
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    protected void renderAdditional(MatrixStack matrices) {
        IngameGui.func_238467_a_((MatrixStack)matrices, (int)this.availableSoundsList.x, (int)this.availableSoundsList.y, (int)(this.availableSoundsList.x + this.availableSoundsList.width), (int)(this.availableSoundsList.y + this.availableSoundsList.height), (int)-15592942);
        this.availableSoundsList.render(matrices, this.field_230712_o_);
    }

    private void setListVisibility(boolean visible) {
        this.availableSoundsList.x = visible ? this.field_230708_k_ / 2 : this.field_230708_k_;
    }
}

