/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mtr.block.BlockTrainSensorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Route;
import mtr.mappings.ScreenMapper;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class TrainSensorScreenBase
extends ScreenMapper
implements IGui,
IPacket {
    private boolean stoppedOnly;
    private boolean movingOnly;
    protected final BlockPos pos;
    protected final WidgetBetterTextField[] textFields;
    private final Set<Long> filterRouteIds;
    private final int textFieldCount;
    private final ITextComponent[] textFieldLabels;
    private final WidgetBetterCheckbox stoppedOnlyCheckbox;
    private final WidgetBetterCheckbox movingOnlyCheckbox;
    private final Button filterButton;
    private final boolean hasSpeedCheckboxes;
    private final int yStart;

    @SafeVarargs
    public TrainSensorScreenBase(BlockPos pos, boolean hasSpeedCheckboxes, Tuple<WidgetBetterTextField, ITextComponent> ... textFieldsAndLabels) {
        super((ITextComponent)new StringTextComponent(""));
        this.pos = pos;
        this.textFieldCount = textFieldsAndLabels.length;
        this.textFields = new WidgetBetterTextField[this.textFieldCount];
        this.textFieldLabels = new ITextComponent[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            this.textFields[i] = (WidgetBetterTextField)textFieldsAndLabels[i].func_76341_a();
            this.textFieldLabels[i] = (ITextComponent)textFieldsAndLabels[i].func_76340_b();
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            this.filterRouteIds = new HashSet<Long>();
        } else {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                this.filterRouteIds = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getRouteIds();
                this.stoppedOnly = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getStoppedOnly();
                this.movingOnly = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getMovingOnly();
            } else {
                this.filterRouteIds = new HashSet<Long>();
            }
        }
        this.stoppedOnlyCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.stopped_only"), checked -> this.setChecked(checked, this.movingOnly));
        this.movingOnlyCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.moving_only"), checked -> this.setChecked(this.stoppedOnly, checked));
        this.filterButton = new Button(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> {
            if (this.field_230706_i_ != null) {
                ArrayList<NameColorDataBase> routes = new ArrayList<NameColorDataBase>(ClientData.ROUTES);
                Collections.sort(routes);
                UtilitiesClient.setScreen(this.field_230706_i_, new DashboardListSelectorScreen(this, routes, this.filterRouteIds, false, false));
            }
        });
        this.hasSpeedCheckboxes = hasSpeedCheckboxes;
        this.yStart = (this.textFieldCount == 0 ? 20 : 84) + (hasSpeedCheckboxes ? 40 : 0);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int textFieldWidth = this.textFieldCount == 0 ? 0 : (this.field_230708_k_ - 40) / this.textFieldCount;
        for (int i = 0; i < this.textFieldCount; ++i) {
            IDrawing.setPositionAndWidth((Widget)this.textFields[i], 22 + textFieldWidth * i, 36, textFieldWidth - 4);
            this.addDrawableChild(this.textFields[i]);
        }
        if (this.hasSpeedCheckboxes) {
            IDrawing.setPositionAndWidth((Widget)this.stoppedOnlyCheckbox, 20, this.yStart - 40, 144);
            IDrawing.setPositionAndWidth((Widget)this.movingOnlyCheckbox, 20, this.yStart - 20, 144);
            this.addDrawableChild(this.stoppedOnlyCheckbox);
            this.addDrawableChild(this.movingOnlyCheckbox);
            this.setChecked(this.stoppedOnly, this.movingOnly);
        }
        IDrawing.setPositionAndWidth((Widget)this.filterButton, 20, this.yStart + 40, 72);
        this.filterButton.func_238482_a_((ITextComponent)new TranslationTextComponent("selectWorld.edit"));
        this.addDrawableChild(this.filterButton);
    }

    public void func_231023_e_() {
        for (WidgetBetterTextField textField : this.textFields) {
            textField.func_146178_a();
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        try {
            int i;
            this.func_230446_a_(matrices);
            for (i = 0; i < this.textFieldCount; ++i) {
                this.field_230712_o_.func_243248_b(matrices, this.textFieldLabels[i], 20.0f + (float)(this.field_230708_k_ / 2 - 20) * (float)i, 20.0f, -1);
            }
            this.field_230712_o_.func_243248_b(matrices, (ITextComponent)new TranslationTextComponent("gui.mtr.filtered_routes", new Object[]{this.filterRouteIds.size()}), 20.0f, (float)(this.yStart + 6), -1);
            this.field_230712_o_.func_243248_b(matrices, (ITextComponent)new TranslationTextComponent(this.filterRouteIds.isEmpty() ? "gui.mtr.filtered_routes_empty" : "gui.mtr.filtered_routes_condition"), 20.0f, (float)(this.yStart + 20 + 6), -1);
            i = 0;
            for (long routeId : this.filterRouteIds) {
                Route route = (Route)ClientData.DATA_CACHE.routeIdMap.get(routeId);
                if (route != null) {
                    this.field_230712_o_.func_243248_b(matrices, (ITextComponent)new StringTextComponent(IGui.formatStationName(route.name)), 20.0f, (float)(this.yStart + 60 + 6 + i), -1);
                }
                i += 8;
            }
            this.renderAdditional(matrices);
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_231175_as__() {
        String[] strings = new String[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            strings[i] = this.textFields[i].func_146179_b();
        }
        PacketTrainDataGuiClient.sendTrainSensorC2S(this.pos, this.filterRouteIds, this.stoppedOnly, this.movingOnly, this.getNumber(), strings);
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void renderAdditional(MatrixStack matrices) {
    }

    protected int getNumber() {
        return 0;
    }

    private void setChecked(boolean newStoppedOnly, boolean newMovingOnly) {
        this.stoppedOnly = newMovingOnly && this.stoppedOnly ? false : newStoppedOnly;
        this.movingOnly = newStoppedOnly && this.movingOnly ? false : newMovingOnly;
        this.stoppedOnlyCheckbox.setChecked(this.stoppedOnly);
        this.movingOnlyCheckbox.setChecked(this.movingOnly);
    }
}

