/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import java.util.function.Consumer;
import mtr.data.IGui;
import mtr.data.RailwayData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class WidgetBetterTextField
extends TextFieldWidget
implements IGui {
    private final TextFieldFilter textFieldFilter;
    private final String suggestion;
    private final int newMaxLength;
    private static final int DEFAULT_MAX_LENGTH = 128;

    public WidgetBetterTextField(TextFieldFilter textFieldFilter, String suggestion) {
        this(textFieldFilter, suggestion, 128);
    }

    public WidgetBetterTextField(TextFieldFilter textFieldFilter, String suggestion, int maxLength) {
        super(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, (ITextComponent)new StringTextComponent(""));
        this.textFieldFilter = textFieldFilter;
        this.suggestion = suggestion;
        this.newMaxLength = maxLength;
        this.func_212954_a(text -> {});
        this.func_146203_f(0);
    }

    public void func_212954_a(Consumer<String> changedListener) {
        super.func_212954_a(text -> {
            String newText;
            if (this.textFieldFilter == null) {
                newText = this.trySetLength((String)text);
            } else {
                newText = this.trySetLength(text.toUpperCase().replaceAll(this.textFieldFilter.filter, ""));
                if (!newText.equals(text)) {
                    this.func_146180_a(newText);
                }
            }
            this.func_195612_c(newText.isEmpty() && this.suggestion != null ? this.suggestion : "");
            changedListener.accept(newText);
        });
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_146176_q() && RailwayData.isBetween(mouseX, this.field_230690_l_, this.field_230690_l_ + this.field_230688_j_) && RailwayData.isBetween(mouseY, this.field_230691_m_, this.field_230691_m_ + this.field_230689_k_)) {
            if (button == 1) {
                this.func_146180_a("");
            }
            return super.func_231044_a_(mouseX, mouseY, 0);
        }
        this.func_230996_d_(false);
        return false;
    }

    public void func_146203_f(int maxLength) {
        super.func_146203_f(Integer.MAX_VALUE);
    }

    private String trySetLength(String text) {
        return text.isEmpty() ? "" : text.substring(0, Math.min(this.newMaxLength, text.length()));
    }

    public static enum TextFieldFilter {
        POSITIVE_INTEGER("[^0-9]"),
        INTEGER("[^-0-9]"),
        HEX("[^0-9A-F]"),
        LETTER("[^A-Z]");

        private final String filter;

        private TextFieldFilter(String filter) {
            this.filter = filter;
        }
    }
}

