/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class WidgetColorSelector
extends Button
implements IGui {
    private int color;
    private final ScreenMapper screen;
    private final Runnable callback;

    public WidgetColorSelector(ScreenMapper screen, Runnable callback) {
        super(0, 0, 0, 20, (ITextComponent)new StringTextComponent(""), button -> {});
        this.screen = screen;
        this.callback = callback;
    }

    public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230431_b_(matrices, mouseX, mouseY, delta);
        IngameGui.func_238467_a_((MatrixStack)matrices, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)(0xFF000000 | this.color));
    }

    public void func_230930_b_() {
        UtilitiesClient.setScreen(Minecraft.func_71410_x(), new ColorSelectorScreen(this.color, color -> {
            UtilitiesClient.setScreen(Minecraft.func_71410_x(), this.screen);
            this.setColor((int)color);
            this.callback.run();
        }));
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int newColor) {
        int clampedColor = (newColor & 0xFFFFFF) == 0 ? new Random().nextInt(0x1000000) : newColor & 0xFFFFFF;
        this.color = clampedColor;
    }

    private static class ColorSelectorScreen
    extends ScreenMapper {
        private float hue;
        private float saturation;
        private float brightness;
        private DraggingState draggingState = DraggingState.NONE;
        private final int oldColor;
        private final Consumer<Integer> colorCallback;
        private final WidgetBetterTextField textFieldColor;
        private final WidgetBetterTextField textFieldRed;
        private final WidgetBetterTextField textFieldGreen;
        private final WidgetBetterTextField textFieldBlue;
        private final Button buttonReset;
        private static final int RIGHT_WIDTH = 60;

        private ColorSelectorScreen(int oldColor, Consumer<Integer> colorCallback) {
            super((ITextComponent)new StringTextComponent(""));
            this.oldColor = oldColor;
            this.colorCallback = colorCallback;
            this.textFieldColor = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.HEX, new StringTextComponent(Integer.toHexString(oldColor).toUpperCase()).getString(), 6);
            this.textFieldRed = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, new StringTextComponent(String.valueOf(oldColor >> 16 & 0xFF)).getString(), 3);
            this.textFieldGreen = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, new StringTextComponent(String.valueOf(oldColor >> 8 & 0xFF)).getString(), 3);
            this.textFieldBlue = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, new StringTextComponent(String.valueOf(oldColor & 0xFF)).getString(), 3);
            this.buttonReset = new Button(0, 0, 0, 20, (ITextComponent)new TranslationTextComponent("gui.mtr.reset_sign"), button -> {
                this.setHsb(oldColor, true);
                button.field_230693_o_ = false;
            });
        }

        protected void func_231160_c_() {
            super.func_231160_c_();
            int startX = 80 + this.getMainWidth();
            int startY = 36;
            IDrawing.setPositionAndWidth((Widget)this.textFieldColor, startX + 2, 36, 56);
            IDrawing.setPositionAndWidth((Widget)this.textFieldRed, startX + 2, 80, 56);
            IDrawing.setPositionAndWidth((Widget)this.textFieldGreen, startX + 2, 104, 56);
            IDrawing.setPositionAndWidth((Widget)this.textFieldBlue, startX + 2, 128, 56);
            IDrawing.setPositionAndWidth((Widget)this.buttonReset, startX, this.getMainHeight(), 60);
            this.setHsb(this.oldColor, true);
            this.textFieldColor.func_212954_a(text -> this.textCallback((String)text, -1));
            this.textFieldRed.func_212954_a(text -> this.textCallback((String)text, 16));
            this.textFieldGreen.func_212954_a(text -> this.textCallback((String)text, 8));
            this.textFieldBlue.func_212954_a(text -> this.textCallback((String)text, 0));
            this.addDrawableChild(this.textFieldColor);
            this.addDrawableChild(this.textFieldRed);
            this.addDrawableChild(this.textFieldGreen);
            this.addDrawableChild(this.textFieldBlue);
            this.addDrawableChild(this.buttonReset);
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            try {
                this.func_230446_a_(matrices);
                super.func_230430_a_(matrices, mouseX, mouseY, delta);
                int mainWidth = this.getMainWidth();
                int mainHeight = this.getMainHeight();
                ColorSelectorScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.mtr.color"), (int)(80 + mainWidth + 30), (int)20, (int)-1);
                ColorSelectorScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)"RGB", (int)(80 + mainWidth + 30), (int)64, (int)-1);
                Tessellator tesselator = Tessellator.func_178181_a();
                BufferBuilder buffer = tesselator.func_178180_c();
                UtilitiesClient.beginDrawingRectangle(buffer);
                int selectedColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
                IDrawing.drawRectangle((IVertexBuilder)buffer, 80 + mainWidth + 1, 157.0, 80 + mainWidth + 60 - 1, mainHeight - 1, selectedColor);
                for (int drawHue = 0; drawHue < mainHeight; ++drawHue) {
                    int color = Color.HSBtoRGB((float)drawHue / (float)(mainHeight - 1), 1.0f, 1.0f);
                    IDrawing.drawRectangle((IVertexBuilder)buffer, 40 + mainWidth, 20 + drawHue, 60 + mainWidth, 20 + drawHue + 1, color);
                }
                for (int drawSaturation = 0; drawSaturation < mainWidth; ++drawSaturation) {
                    for (int drawBrightness = 0; drawBrightness < mainHeight; ++drawBrightness) {
                        int color = Color.HSBtoRGB(this.hue, (float)drawSaturation / (float)(mainWidth - 1), (float)drawBrightness / (float)(mainHeight - 1));
                        IDrawing.drawRectangle((IVertexBuilder)buffer, 20 + drawSaturation, 20 + mainHeight - drawBrightness - 1, 20 + drawSaturation + 1, 20 + mainHeight - drawBrightness, color);
                    }
                }
                int selectedHueInt = Math.round(this.hue * (float)(mainHeight - 1));
                int selectedSaturationInt = Math.round(this.saturation * (float)(mainWidth - 1));
                int selectedBrightnessInt = Math.round(this.brightness * (float)(mainHeight - 1));
                IDrawing.drawRectangle((IVertexBuilder)buffer, 40 + mainWidth, 20 + selectedHueInt - 1, 60 + mainWidth, 20 + selectedHueInt + 2, -16777216);
                IDrawing.drawRectangle((IVertexBuilder)buffer, 40 + mainWidth, 20 + selectedHueInt, 60 + mainWidth, 20 + selectedHueInt + 1, -1);
                IDrawing.drawRectangle((IVertexBuilder)buffer, 20 + selectedSaturationInt - 1, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 2, 20 + mainHeight - selectedBrightnessInt, -16777216);
                IDrawing.drawRectangle((IVertexBuilder)buffer, 20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 2, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt + 1, -16777216);
                IDrawing.drawRectangle((IVertexBuilder)buffer, 20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt, -1);
                tesselator.func_78381_a();
                UtilitiesClient.finishDrawingRectangle();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void func_231023_e_() {
            this.textFieldRed.func_146178_a();
            this.textFieldGreen.func_146178_a();
            this.textFieldBlue.func_146178_a();
            this.textFieldColor.func_146178_a();
        }

        public void func_231175_as__() {
            this.colorCallback.accept(Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            this.draggingState = DraggingState.NONE;
            if (mouseY >= 20.0 && mouseY < (double)(20 + mainHeight)) {
                if (mouseX >= 20.0 && mouseX < (double)(20 + mainWidth)) {
                    this.draggingState = DraggingState.SATURATION_BRIGHTNESS;
                } else if (mouseX >= (double)(40 + mainWidth) && mouseX < (double)(60 + mainWidth)) {
                    this.draggingState = DraggingState.HUE;
                }
            }
            this.selectColor(mouseX, mouseY);
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            this.selectColor(mouseX, mouseY);
            return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }

        private void selectColor(double mouseX, double mouseY) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            switch (this.draggingState) {
                case SATURATION_BRIGHTNESS: {
                    this.saturation = (float)MathHelper.func_151237_a((double)((mouseX - 20.0) / (double)mainWidth), (double)0.0, (double)1.0);
                    this.brightness = 1.0f - (float)MathHelper.func_151237_a((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                    break;
                }
                case HUE: {
                    this.hue = (float)MathHelper.func_151237_a((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                }
            }
        }

        private void setHsb(int color, boolean padZero) {
            float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
            this.hue = hsb[0];
            this.saturation = hsb[1];
            this.brightness = hsb[2];
            this.setColorText(color, padZero);
        }

        private void setColorText(int color, boolean padZero) {
            String colorString = Integer.toHexString(color & 0xFFFFFF).toUpperCase();
            this.textFieldColor.func_146180_a(padZero ? StringUtils.leftPad((String)colorString, (int)6, (String)"0") : colorString);
            this.textFieldRed.func_146180_a(String.valueOf(color >> 16 & 0xFF));
            this.textFieldGreen.func_146180_a(String.valueOf(color >> 8 & 0xFF));
            this.textFieldBlue.func_146180_a(String.valueOf(color & 0xFF));
            this.buttonReset.field_230693_o_ = (color & 0xFFFFFF) != this.oldColor;
        }

        private void textCallback(String text, int shift) {
            try {
                boolean isHex = shift < 0;
                int compare = Integer.parseInt(text, isHex ? 16 : 10);
                int currentColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF;
                if ((isHex ? currentColor : currentColor >> shift & 0xFF) != compare) {
                    this.setHsb(isHex ? compare : (currentColor & ~(255 << shift)) + (compare << shift), !isHex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getMainWidth() {
            return this.field_230708_k_ - 100 - 60;
        }

        private int getMainHeight() {
            return this.field_230709_l_ - 40;
        }
    }

    private static enum DraggingState {
        NONE,
        SATURATION_BRIGHTNESS,
        HUE;

    }
}

