/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.AreaBase;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.SavedRailBase;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.SelectableMapper;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.Heightmap;

public class WidgetMap
implements IRenderable,
SelectableMapper,
IGuiEventListener,
IGui {
    private int x;
    private int y;
    private int width;
    private int height;
    private double scale;
    private double centerX;
    private double centerY;
    private Tuple<Integer, Integer> drawArea1;
    private Tuple<Integer, Integer> drawArea2;
    private MapState mapState;
    private boolean showStations;
    private final TransportMode transportMode;
    private final OnDrawCorners onDrawCorners;
    private final Runnable onDrawCornersMouseRelease;
    private final Consumer<Long> onClickAddPlatformToRoute;
    private final Consumer<SavedRailBase> onClickEditSavedRail;
    private final BiFunction<Double, Double, Boolean> isRestrictedMouseArea;
    private final ClientWorld world;
    private final ClientPlayerEntity player;
    private final FontRenderer textRenderer;
    private static final int ARGB_BLUE = -12417548;
    private static final int SCALE_UPPER_LIMIT = 64;
    private static final double SCALE_LOWER_LIMIT = 0.0078125;

    public WidgetMap(TransportMode transportMode, OnDrawCorners onDrawCorners, Runnable onDrawCornersMouseRelease, Consumer<Long> onClickAddPlatformToRoute, Consumer<SavedRailBase> onClickEditSavedRail, BiFunction<Double, Double, Boolean> isRestrictedMouseArea) {
        this.transportMode = transportMode;
        this.onDrawCorners = onDrawCorners;
        this.onDrawCornersMouseRelease = onDrawCornersMouseRelease;
        this.onClickAddPlatformToRoute = onClickAddPlatformToRoute;
        this.onClickEditSavedRail = onClickEditSavedRail;
        this.isRestrictedMouseArea = isRestrictedMouseArea;
        Minecraft minecraftClient = Minecraft.func_71410_x();
        this.world = minecraftClient.field_71441_e;
        this.player = minecraftClient.field_71439_g;
        this.textRenderer = minecraftClient.field_71466_p;
        if (this.player == null) {
            this.centerX = 0.0;
            this.centerY = 0.0;
        } else {
            this.centerX = this.player.func_226277_ct_();
            this.centerY = this.player.func_226281_cx_();
        }
        this.scale = 1.0;
        this.setShowStations(true);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        UtilitiesClient.beginDrawingRectangle(buffer);
        RenderSystem.enableBlend();
        Tuple<Integer, Integer> topLeft = this.coordsToWorldPos(0, 0);
        Tuple<Integer, Integer> bottomRight = this.coordsToWorldPos(this.width, this.height);
        int increment = this.scale >= 1.0 ? 1 : (int)Math.ceil(1.0 / this.scale);
        for (int i = ((Integer)topLeft.func_76341_a()).intValue(); i <= (Integer)bottomRight.func_76341_a(); i += increment) {
            for (int j = ((Integer)topLeft.func_76340_b()).intValue(); j <= (Integer)bottomRight.func_76340_b(); j += increment) {
                if (this.world == null) continue;
                int color = WidgetMap.divideColorRGB(this.world.func_180495_p((BlockPos)new BlockPos((int)i, (int)(this.world.func_201676_a((Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, (int)i, (int)j) - 1), (int)j)).func_177230_c().func_235697_s_().field_76291_p, 2);
                this.drawRectangleFromWorldCoords(buffer, i, j, i + increment, j + increment, 0xFF000000 | color);
            }
        }
        Tuple<Double, Double> mouseWorldPos = this.coordsToWorldPos((double)mouseX - (double)this.x, (double)(mouseY - this.y));
        try {
            if (this.showStations) {
                ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode).forEach((platformPos, platforms) -> this.drawRectangleFromWorldCoords(buffer, platformPos.func_177958_n(), platformPos.func_177952_p(), platformPos.func_177958_n() + 1, platformPos.func_177952_p() + 1, -1));
                for (Station station : ClientData.STATIONS) {
                    if (!AreaBase.nonNullCorners(station)) continue;
                    this.drawRectangleFromWorldCoords(buffer, (Tuple<Integer, Integer>)station.corner1, (Tuple<Integer, Integer>)station.corner2, 0x7F000000 + station.color);
                }
                this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(buffer, x1, z1, x2, z2, -1), true);
            } else {
                ClientData.DATA_CACHE.getPosToSidings(this.transportMode).forEach((sidingPos, sidings) -> this.drawRectangleFromWorldCoords(buffer, sidingPos.func_177958_n(), sidingPos.func_177952_p(), sidingPos.func_177958_n() + 1, sidingPos.func_177952_p() + 1, -1));
                for (Depot depot : ClientData.DEPOTS) {
                    if (!depot.isTransportMode(this.transportMode) || !AreaBase.nonNullCorners(depot)) continue;
                    this.drawRectangleFromWorldCoords(buffer, (Tuple<Integer, Integer>)depot.corner1, (Tuple<Integer, Integer>)depot.corner2, 0x7F000000 + depot.color);
                }
                this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(buffer, x1, z1, x2, z2, -1), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mapState == MapState.EDITING_AREA && this.drawArea1 != null && this.drawArea2 != null) {
            this.drawRectangleFromWorldCoords(buffer, this.drawArea1, this.drawArea2, Integer.MAX_VALUE);
        }
        if (this.player != null) {
            this.drawFromWorldCoords(this.player.func_226277_ct_(), this.player.func_226281_cx_(), (x1, y1) -> {
                this.drawRectangle(buffer, x1 - 2.0, y1 - 3.0, x1 + 2.0, y1 + 3.0, -1);
                this.drawRectangle(buffer, x1 - 3.0, y1 - 2.0, x1 + 3.0, y1 + 2.0, -1);
                this.drawRectangle(buffer, x1 - 2.0, y1 - 2.0, x1 + 2.0, y1 + 2.0, -12417548);
            });
        }
        tesselator.func_78381_a();
        RenderSystem.disableBlend();
        UtilitiesClient.finishDrawingRectangle();
        if (this.mapState == MapState.EDITING_AREA) {
            IngameGui.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.textRenderer, (String)new TranslationTextComponent("gui.mtr.edit_area").getString(), (int)(this.x + 6), (int)(this.y + 6), (int)-1);
        } else if (this.mapState == MapState.EDITING_ROUTE) {
            IngameGui.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.textRenderer, (String)new TranslationTextComponent("gui.mtr.edit_route").getString(), (int)(this.x + 6), (int)(this.y + 6), (int)-1);
        }
        if (this.scale >= 8.0) {
            try {
                if (this.showStations) {
                    ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode).forEach((platformPos, platforms) -> this.drawSavedRail(matrices, (BlockPos)platformPos, (List<? extends SavedRailBase>)platforms));
                } else {
                    ClientData.DATA_CACHE.getPosToSidings(this.transportMode).forEach((sidingPos, sidings) -> this.drawSavedRail(matrices, (BlockPos)sidingPos, (List<? extends SavedRailBase>)sidings));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        if (this.showStations) {
            for (Station station : ClientData.STATIONS) {
                if (!this.canDrawAreaText(station)) continue;
                BlockPos pos = station.getCenter();
                String stationString = String.format("%s|(%s)", station.name, new TranslationTextComponent("gui.mtr.zone_number", new Object[]{station.zone}).getString());
                this.drawFromWorldCoords(pos.func_177958_n(), pos.func_177952_p(), (x1, y1) -> IDrawing.drawStringWithFont(matrices, this.textRenderer, immediate, stationString, (float)this.x + (float)x1, (float)this.y + (float)y1, 0xF000F0));
            }
        } else {
            for (Depot depot : ClientData.DEPOTS) {
                if (!this.canDrawAreaText(depot)) continue;
                BlockPos pos = depot.getCenter();
                this.drawFromWorldCoords(pos.func_177958_n(), pos.func_177952_p(), (x1, y1) -> IDrawing.drawStringWithFont(matrices, this.textRenderer, immediate, depot.name, (float)this.x + (float)x1, (float)this.y + (float)y1, 0xF000F0));
            }
        }
        immediate.func_228461_a_();
        String mousePosText = String.format("(%s, %s)", Float.valueOf(RailwayData.round((Double)mouseWorldPos.func_76341_a(), 1)), Float.valueOf(RailwayData.round((Double)mouseWorldPos.func_76340_b(), 1)));
        IngameGui.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.textRenderer, (String)mousePosText, (int)(this.x + this.width - 6 - this.textRenderer.func_78256_a(mousePosText)), (int)(this.y + 6), (int)-1);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.drawArea2 = this.coordsToWorldPos((int)Math.round(mouseX - (double)this.x), (int)Math.round(mouseY - (double)this.y));
            if (((Integer)this.drawArea1.func_76341_a()).equals(this.drawArea2.func_76341_a())) {
                this.drawArea2 = new Tuple((Object)((Integer)this.drawArea2.func_76341_a() + 1), (Object)((Integer)this.drawArea2.func_76340_b()));
            }
            if (((Integer)this.drawArea1.func_76340_b()).equals(this.drawArea2.func_76340_b())) {
                this.drawArea2 = new Tuple((Object)((Integer)this.drawArea2.func_76341_a()), (Object)((Integer)this.drawArea2.func_76340_b() + 1));
            }
            this.onDrawCorners.onDrawCorners(this.drawArea1, this.drawArea2);
        } else {
            this.centerX -= deltaX / this.scale;
            this.centerY -= deltaY / this.scale;
        }
        return true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.onDrawCornersMouseRelease.run();
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            if (ClientData.hasPermission()) {
                if (this.mapState == MapState.EDITING_AREA) {
                    this.drawArea1 = this.coordsToWorldPos((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y));
                    this.drawArea2 = null;
                } else if (this.mapState == MapState.EDITING_ROUTE) {
                    Tuple<Double, Double> mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.x, mouseY - (double)this.y);
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickAddPlatformToRoute.accept(savedRail.id), true);
                } else {
                    Tuple<Double, Double> mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.x, mouseY - (double)this.y);
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickEditSavedRail.accept(savedRail), this.showStations);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        double oldScale = this.scale;
        if (oldScale > 0.0078125 && amount < 0.0) {
            this.centerX -= (mouseX - (double)this.x - (double)this.width / 2.0) / this.scale;
            this.centerY -= (mouseY - (double)this.y - (double)this.height / 2.0) / this.scale;
        }
        this.scale(amount);
        if (oldScale < 64.0 && amount > 0.0) {
            this.centerX += (mouseX - (double)this.x - (double)this.width / 2.0) / this.scale;
            this.centerY += (mouseY - (double)this.y - (double)this.height / 2.0) / this.scale;
        }
        return true;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height) && (!(mouseX >= (double)(this.x + this.width - 200)) || !(mouseY >= (double)(this.y + this.height - 20))) && this.isRestrictedMouseArea.apply(mouseX, mouseY) == false;
    }

    public void setPositionAndSize(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void scale(double amount) {
        this.scale *= Math.pow(2.0, amount);
        this.scale = MathHelper.func_151237_a((double)this.scale, (double)0.0078125, (double)64.0);
    }

    public void find(double x1, double z1, double x2, double z2) {
        this.centerX = (x1 + x2) / 2.0;
        this.centerY = (z1 + z2) / 2.0;
        this.scale = Math.max(2.0, this.scale);
    }

    public void find(BlockPos pos) {
        this.centerX = pos.func_177958_n();
        this.centerY = pos.func_177952_p();
        this.scale = Math.max(8.0, this.scale);
    }

    public void startEditingArea(AreaBase editingArea) {
        this.mapState = MapState.EDITING_AREA;
        this.drawArea1 = editingArea.corner1;
        this.drawArea2 = editingArea.corner2;
    }

    public void startEditingRoute() {
        this.mapState = MapState.EDITING_ROUTE;
    }

    public void stopEditing() {
        this.mapState = MapState.DEFAULT;
    }

    public void setShowStations(boolean showStations) {
        this.showStations = showStations;
    }

    private void mouseOnSavedRail(Tuple<Double, Double> mouseWorldPos, MouseOnSavedRailCallback mouseOnSavedRailCallback, boolean isPlatform) {
        try {
            (isPlatform ? ClientData.DATA_CACHE.getPosToPlatforms(this.transportMode) : ClientData.DATA_CACHE.getPosToSidings(this.transportMode)).forEach((savedRailPos, savedRails) -> {
                int savedRailCount = savedRails.size();
                for (int i = 0; i < savedRailCount; ++i) {
                    float left = savedRailPos.func_177958_n();
                    float right = savedRailPos.func_177958_n() + 1;
                    float top = (float)savedRailPos.func_177952_p() + (float)i / (float)savedRailCount;
                    float bottom = (float)savedRailPos.func_177952_p() + ((float)i + 1.0f) / (float)savedRailCount;
                    if (!RailwayData.isBetween((Double)mouseWorldPos.func_76341_a(), left, right) || !RailwayData.isBetween((Double)mouseWorldPos.func_76340_b(), top, bottom)) continue;
                    mouseOnSavedRailCallback.mouseOnSavedRailCallback((SavedRailBase)savedRails.get(i), left, top, right, bottom);
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Tuple<Integer, Integer> coordsToWorldPos(int mouseX, int mouseY) {
        Tuple<Double, Double> worldPos = this.coordsToWorldPos((double)mouseX, (double)mouseY);
        return new Tuple((Object)((int)Math.floor((Double)worldPos.func_76341_a())), (Object)((int)Math.floor((Double)worldPos.func_76340_b())));
    }

    private Tuple<Double, Double> coordsToWorldPos(double mouseX, double mouseY) {
        double left = (mouseX - (double)this.width / 2.0) / this.scale + this.centerX;
        double right = (mouseY - (double)this.height / 2.0) / this.scale + this.centerY;
        return new Tuple((Object)left, (Object)right);
    }

    private void drawFromWorldCoords(double worldX, double worldZ, DrawFromWorldCoords callback) {
        double coordsX = (worldX - this.centerX) * this.scale + (double)this.width / 2.0;
        double coordsY = (worldZ - this.centerY) * this.scale + (double)this.height / 2.0;
        callback.drawFromWorldCoords(coordsX, coordsY);
    }

    private void drawRectangleFromWorldCoords(BufferBuilder buffer, Tuple<Integer, Integer> corner1, Tuple<Integer, Integer> corner2, int color) {
        this.drawRectangleFromWorldCoords(buffer, ((Integer)corner1.func_76341_a()).intValue(), ((Integer)corner1.func_76340_b()).intValue(), ((Integer)corner2.func_76341_a()).intValue(), ((Integer)corner2.func_76340_b()).intValue(), color);
    }

    private void drawRectangleFromWorldCoords(BufferBuilder buffer, double posX1, double posZ1, double posX2, double posZ2, int color) {
        double x1 = (posX1 - this.centerX) * this.scale + (double)this.width / 2.0;
        double z1 = (posZ1 - this.centerY) * this.scale + (double)this.height / 2.0;
        double x2 = (posX2 - this.centerX) * this.scale + (double)this.width / 2.0;
        double z2 = (posZ2 - this.centerY) * this.scale + (double)this.height / 2.0;
        this.drawRectangle(buffer, x1, z1, x2, z2, color);
    }

    private void drawRectangle(BufferBuilder buffer, double xA, double yA, double xB, double yB, int color) {
        double x1 = Math.min(xA, xB);
        double y1 = Math.min(yA, yB);
        double x2 = Math.max(xA, xB);
        double y2 = Math.max(yA, yB);
        if (x1 < (double)this.width && y1 < (double)this.height && x2 >= 0.0 && y2 >= 0.0) {
            IDrawing.drawRectangle((IVertexBuilder)buffer, (double)this.x + Math.max(0.0, x1), (double)this.y + y1, (double)this.x + x2, (double)this.y + y2, color);
        }
    }

    private boolean canDrawAreaText(AreaBase areaBase) {
        return areaBase.getCenter() != null && this.scale >= (double)(80.0f / (float)Math.max(Math.abs((Integer)areaBase.corner1.func_76341_a() - (Integer)areaBase.corner2.func_76341_a()), Math.abs((Integer)areaBase.corner1.func_76340_b() - (Integer)areaBase.corner2.func_76340_b())));
    }

    private void drawSavedRail(MatrixStack matrices, BlockPos savedRailPos, List<? extends SavedRailBase> savedRails) {
        int savedRailCount = savedRails.size();
        for (int i = 0; i < savedRailCount; ++i) {
            int index = i;
            this.drawFromWorldCoords((double)savedRailPos.func_177958_n() + 0.5, (double)savedRailPos.func_177952_p() + ((double)i + 0.5) / (double)savedRailCount, (x1, y1) -> IngameGui.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.textRenderer, (String)((SavedRailBase)savedRails.get((int)index)).name, (int)(this.x + (int)x1), (int)(this.y + (int)y1 - 4), (int)-1));
        }
    }

    private static int divideColorRGB(int color, int amount) {
        int r = (color >> 16 & 0xFF) / amount;
        int g = (color >> 8 & 0xFF) / amount;
        int b = (color & 0xFF) / amount;
        return (r << 16) + (g << 8) + b;
    }

    @FunctionalInterface
    public static interface OnDrawCorners {
        public void onDrawCorners(Tuple<Integer, Integer> var1, Tuple<Integer, Integer> var2);
    }

    @FunctionalInterface
    private static interface MouseOnSavedRailCallback {
        public void mouseOnSavedRailCallback(SavedRailBase var1, double var2, double var4, double var6, double var8);
    }

    private static enum MapState {
        DEFAULT,
        EDITING_AREA,
        EDITING_ROUTE;

    }

    @FunctionalInterface
    private static interface DrawFromWorldCoords {
        public void drawFromWorldCoords(double var1, double var3);
    }
}

