/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataServletHandler
extends HttpServlet {
    public static MinecraftServer SERVER;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        SERVER.execute(() -> {
            JsonArray dataArray = new JsonArray();
            SERVER.func_212370_w().forEach(world -> {
                RailwayData railwayData = RailwayData.getInstance((World)world);
                JsonArray routesArray = new JsonArray();
                JsonObject stationPositionsObject = new JsonObject();
                JsonObject stationsObject = new JsonObject();
                JsonArray typesObject = new JsonArray();
                HashSet types = new HashSet();
                if (railwayData != null) {
                    DataCache dataCache = railwayData.dataCache;
                    railwayData.routes.forEach(route -> {
                        if (route.isHidden) {
                            return;
                        }
                        JsonObject routeObject = new JsonObject();
                        routeObject.addProperty("color", (Number)route.color);
                        routeObject.addProperty("name", route.name);
                        String type = DataServletHandler.createKey(route.transportMode, route.routeType);
                        routeObject.addProperty("type", type);
                        types.add(type);
                        JsonArray routeStationsArray = new JsonArray();
                        routeObject.add("stations", (JsonElement)routeStationsArray);
                        JsonArray routeDurationsArray = new JsonArray();
                        routeObject.add("durations", (JsonElement)routeDurationsArray);
                        routeObject.addProperty("circular", route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw"));
                        Depot depot = dataCache.routeIdToOneDepot.get(route.id);
                        float accumulatedTime = 0.0f;
                        for (int i = 0; i < route.platformIds.size(); ++i) {
                            Platform platform;
                            long prevPlatformId;
                            long platformId = route.platformIds.get(i);
                            float time = 0.0f;
                            if (i > 0 && depot != null && depot.platformTimes.containsKey(prevPlatformId = route.platformIds.get(i - 1).longValue()) && depot.platformTimes.get(prevPlatformId).containsKey(platformId)) {
                                time = depot.platformTimes.get(prevPlatformId).get(platformId).floatValue();
                            }
                            Station station = dataCache.platformIdToStation.get(platformId);
                            boolean addedStation = false;
                            if (station != null && (platform = dataCache.platformIdMap.get(platformId)) != null) {
                                try {
                                    JsonObject stationPositionObject;
                                    String newId = station.id + "_" + route.color;
                                    routeStationsArray.add(newId);
                                    BlockPos pos = platform.getMidPos();
                                    if (stationPositionsObject.has(newId)) {
                                        stationPositionObject = stationPositionsObject.getAsJsonObject(newId);
                                        int existingX = stationPositionObject.get("x").getAsInt();
                                        int existingZ = stationPositionObject.get("y").getAsInt();
                                        stationPositionObject.addProperty("x", (Number)((existingX + pos.func_177958_n()) / 2));
                                        stationPositionObject.addProperty("y", (Number)((existingZ + pos.func_177952_p()) / 2));
                                    } else {
                                        stationPositionObject = new JsonObject();
                                        stationPositionObject.addProperty("x", (Number)pos.func_177958_n());
                                        stationPositionObject.addProperty("y", (Number)pos.func_177952_p());
                                        stationPositionObject.addProperty("vertical", Boolean.valueOf(platform.getAxis() == Direction.Axis.Z));
                                        stationPositionsObject.add(newId, (JsonElement)stationPositionObject);
                                    }
                                    JsonObject stationObject = new JsonObject();
                                    stationObject.addProperty("name", station.name);
                                    stationObject.addProperty("color", (Number)station.color);
                                    stationObject.addProperty("zone", (Number)station.zone);
                                    BlockPos stationCenter = station.getCenter();
                                    stationObject.addProperty("x", (Number)(stationCenter == null ? 0 : stationCenter.func_177958_n()));
                                    stationObject.addProperty("z", (Number)(stationCenter == null ? 0 : stationCenter.func_177952_p()));
                                    stationsObject.add(String.valueOf(station.id), (JsonElement)stationObject);
                                    addedStation = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            accumulatedTime += time;
                            if (i <= 0 || !addedStation) continue;
                            routeDurationsArray.add((Number)Float.valueOf(accumulatedTime));
                            accumulatedTime = 0.0f;
                        }
                        routesArray.add((JsonElement)routeObject);
                    });
                }
                for (TransportMode transportMode : TransportMode.values()) {
                    for (RouteType routeType : RouteType.values()) {
                        String type = DataServletHandler.createKey(transportMode, routeType);
                        if (!types.contains(type)) continue;
                        typesObject.add(type);
                    }
                }
                JsonObject jsonObject = new JsonObject();
                jsonObject.add("routes", (JsonElement)routesArray);
                jsonObject.add("positions", (JsonElement)stationPositionsObject);
                jsonObject.add("stations", (JsonElement)stationsObject);
                jsonObject.add("types", (JsonElement)typesObject);
                dataArray.add((JsonElement)jsonObject);
            });
            IServletHandler.sendResponse(response, asyncContext, dataArray.toString());
        });
    }

    private static String createKey(TransportMode transportMode, RouteType routeType) {
        return (transportMode.toString() + "_" + routeType.toString()).toLowerCase();
    }
}

