/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.client.tooltip.AttributeTooltips;
import vazkii.quark.content.client.tooltip.EnchantedBookTooltips;
import vazkii.quark.content.client.tooltip.FoodTooltips;
import vazkii.quark.content.client.tooltip.MapTooltips;
import vazkii.quark.content.client.tooltip.ShulkerBoxTooltips;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class ImprovedTooltipsModule
extends QuarkModule {
    @Config
    public static boolean attributeTooltips = true;
    @Config
    public static boolean foodTooltips = true;
    @Config
    public static boolean shulkerTooltips = true;
    @Config
    public static boolean mapTooltips = true;
    @Config
    public static boolean enchantingTooltips = true;
    @Config
    public static boolean shulkerBoxUseColors = true;
    @Config
    public static boolean shulkerBoxRequireShift = false;
    @Config
    public static boolean mapRequireShift = false;
    @Config
    public static boolean showSaturation = true;
    @Config
    public static int foodCompressionThreshold = 4;
    @Config(description="The value of each shank of food. Tweak this when using mods like Hardcore Hunger which change that value.")
    public static int foodDivisor = 2;
    @Config
    public static List<String> enchantingStacks = Lists.newArrayList((Object[])new String[]{"minecraft:diamond_sword", "minecraft:diamond_pickaxe", "minecraft:diamond_shovel", "minecraft:diamond_axe", "minecraft:diamond_hoe", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots", "minecraft:shears", "minecraft:bow", "minecraft:fishing_rod", "minecraft:crossbow", "minecraft:trident", "minecraft:elytra", "quark:pickarang"});
    @Config(description="A list of additional stacks to display on each enchantment\nThe format is as follows:\nenchant_id=item1,item2,item3...\nSo to display a carrot on a stick on a mending book, for example, you use:\nminecraft:mending=minecraft:carrot_on_a_stick")
    public static List<String> enchantingAdditionalStacks = Lists.newArrayList();
    private static final String IGNORE_TAG = "quark:no_tooltip";

    @Override
    public void configChanged() {
        EnchantedBookTooltips.reloaded();
    }

    private static boolean ignore(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(IGNORE_TAG);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        if (ImprovedTooltipsModule.ignore(event.getItemStack())) {
            return;
        }
        if (attributeTooltips) {
            AttributeTooltips.makeTooltip(event);
        }
        if (foodTooltips || showSaturation) {
            FoodTooltips.makeTooltip(event, foodTooltips, showSaturation);
        }
        if (shulkerTooltips) {
            ShulkerBoxTooltips.makeTooltip(event);
        }
        if (mapTooltips) {
            MapTooltips.makeTooltip(event);
        }
        if (enchantingTooltips) {
            EnchantedBookTooltips.makeTooltip(event);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        if (ImprovedTooltipsModule.ignore(event.getStack())) {
            return;
        }
        if (attributeTooltips) {
            AttributeTooltips.renderTooltip(event);
        }
        if (foodTooltips) {
            FoodTooltips.renderTooltip(event);
        }
        if (shulkerTooltips) {
            ShulkerBoxTooltips.renderTooltip(event);
        }
        if (mapTooltips) {
            MapTooltips.renderTooltip(event);
        }
        if (enchantingTooltips) {
            EnchantedBookTooltips.renderTooltip(event);
        }
    }
}

