/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("textures/mob_effect/night_vision.png");
    private static final ItemStack REDSTONE = new ItemStack((IItemProvider)Items.field_151137_ax);
    private static final TranslationTextComponent REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCamera camera = (SecurityCamera)Minecraft.func_71410_x().field_175622_Z;
            if (camera.screenshotSoundCooldown == 0) {
                camera.screenshotSoundCooldown = 7;
                Minecraft.func_71410_x().field_71441_e.func_184156_a(player.func_233580_cy_(), SCSounds.CAMERASNAP.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.ClickInputEvent event) {
        if (event.isAttack() && ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if ((event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.getType() == RenderGameOverlayEvent.ElementType.JUMPBAR || event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) && ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (ClientHandler.isPlayerMountedOnCamera()) {
                SCClientEventHandler.drawCameraOverlay(event.getMatrixStack(), Minecraft.func_71410_x(), (AbstractGui)Minecraft.func_71410_x().field_71456_v, Minecraft.func_71410_x().func_228018_at_(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_175622_Z.func_233580_cy_());
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                ClientPlayerEntity player = mc.field_71439_g;
                World world = player.func_130014_f_();
                double reachDistance = mc.field_71442_b.func_78757_d();
                for (Hand hand : Hand.values()) {
                    Object[] coords;
                    BlockRayTraceResult mop;
                    int uCoord = 0;
                    ItemStack stack = player.func_184586_b(hand);
                    if (stack.func_77973_b() == SCContent.CAMERA_MONITOR.get()) {
                        double eyeHeight = player.func_70047_e();
                        Vector3d lookVec = new Vector3d(player.func_226277_ct_() + player.func_70040_Z().field_72450_a * reachDistance, eyeHeight + player.func_226278_cu_() + player.func_70040_Z().field_72448_b * reachDistance, player.func_226281_cx_() + player.func_70040_Z().field_72449_c * reachDistance);
                        mop = world.func_217299_a(new RayTraceContext(new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_()), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_216350_a()) instanceof SecurityCameraBlockEntity) {
                            CompoundNBT cameras = stack.func_196082_o();
                            uCoord = 110;
                            for (int i = 1; i < 31; ++i) {
                                if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_216350_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_216350_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_216350_a().func_177952_p()) continue;
                                uCoord = 88;
                                break;
                            }
                        }
                    } else if (stack.func_77973_b() == SCContent.REMOTE_ACCESS_MINE.get()) {
                        double eyeHeight = player.func_70047_e();
                        Vector3d lookVec = new Vector3d(player.func_226277_ct_() + player.func_70040_Z().field_72450_a * reachDistance, eyeHeight + player.func_226278_cu_() + player.func_70040_Z().field_72448_b * reachDistance, player.func_226281_cx_() + player.func_70040_Z().field_72449_c * reachDistance);
                        mop = world.func_217299_a(new RayTraceContext(new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_()), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_216350_a()).func_177230_c() instanceof IExplosive) {
                            uCoord = 110;
                            CompoundNBT mines = stack.func_196082_o();
                            for (int i = 1; i <= 6; ++i) {
                                if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = (Object[])mines.func_74759_k("mine" + i))[0] != mop.func_216350_a().func_177958_n() || coords[1] != mop.func_216350_a().func_177956_o() || coords[2] != mop.func_216350_a().func_177952_p()) continue;
                                uCoord = 88;
                                break;
                            }
                        }
                    } else if (stack.func_77973_b() == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                        Entity hitEntity = Minecraft.func_71410_x().field_147125_j;
                        if (hitEntity instanceof Sentry) {
                            uCoord = 110;
                            CompoundNBT sentries = stack.func_196082_o();
                            for (int i = 1; i <= 12; ++i) {
                                int[] coords2;
                                if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords2 = sentries.func_74759_k("sentry" + i))[0] != hitEntity.func_233580_cy_().func_177958_n() || coords2[1] != hitEntity.func_233580_cy_().func_177956_o() || coords2[2] != hitEntity.func_233580_cy_().func_177952_p()) continue;
                                uCoord = 88;
                                break;
                            }
                        }
                    } else if (stack.func_77973_b() == SCContent.SONIC_SECURITY_SYSTEM_ITEM.get()) {
                        double eyeHeight = player.func_70047_e();
                        Vector3d lookVec = new Vector3d(player.func_226277_ct_() + player.func_70040_Z().field_72450_a * reachDistance, eyeHeight + player.func_226278_cu_() + player.func_70040_Z().field_72448_b * reachDistance, player.func_226281_cx_() + player.func_70040_Z().field_72449_c * reachDistance);
                        mop = world.func_217299_a(new RayTraceContext(new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_()), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                        TileEntity te = world.func_175625_s(mop.func_216350_a());
                        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && te instanceof ILockable) {
                            Block block;
                            BlockPos pos = mop.func_216350_a();
                            if (!(te instanceof IOwnable && ((IOwnable)te).getOwner().isOwner((PlayerEntity)player) || !((block = te.func_195044_w().func_177230_c()) instanceof DisguisableBlock) || ((DisguisableBlock)block).getDisguisedBlockState((IBlockReader)world, pos) == null)) {
                                return;
                            }
                            uCoord = 110;
                            if (SonicSecuritySystemItem.isAdded(stack.func_196082_o(), pos)) {
                                uCoord = 88;
                            }
                        }
                    }
                    if (uCoord == 0) continue;
                    RenderSystem.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(BEACON_GUI);
                    AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - 90 + (hand == Hand.MAIN_HAND ? player.field_71071_by.field_70461_c * 20 : (mc.field_71474_y.field_186715_A == HandSide.LEFT ? 189 : -29))), (int)(Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 22), (float)uCoord, (float)219.0f, (int)21, (int)22, (int)256, (int)256);
                    RenderSystem.disableAlphaTest();
                }
            }
        }
    }

    private static void drawCameraOverlay(MatrixStack matrix, Minecraft mc, AbstractGui gui, MainWindow resolution, PlayerEntity player, World world, BlockPos pos) {
        if (mc.field_71474_y.field_74330_P) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof SecurityCameraBlockEntity)) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GameSettings settings = mc.field_71474_y;
        SecurityCameraBlockEntity te = (SecurityCameraBlockEntity)tile;
        boolean hasRedstoneModule = te.hasModule(ModuleType.REDSTONE);
        BlockState state = world.func_180495_p(pos);
        TranslationTextComponent lookAround = Utils.localize("gui.securitycraft:camera.lookAround", settings.field_74351_w.func_238171_j_(), settings.field_74370_x.func_238171_j_(), settings.field_74368_y.func_238171_j_(), settings.field_74366_z.func_238171_j_());
        TranslationTextComponent exit = Utils.localize("gui.securitycraft:camera.exit", settings.field_228046_af_.func_238171_j_());
        TranslationTextComponent zoom = Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.func_238171_j_(), KeyBindings.cameraZoomOut.func_238171_j_());
        TranslationTextComponent nightVision = Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.func_238171_j_());
        TranslationTextComponent redstone = Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.func_238171_j_());
        String time = ClientUtils.getFormattedMinecraftTime();
        int timeY = 25;
        if (te.func_145818_k_()) {
            ITextComponent cameraName = te.func_200201_e();
            font.func_243246_a(matrix, cameraName, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.func_238405_a_(matrix, time, (float)(resolution.func_198107_o() - font.func_78256_a(time) - 4), (float)timeY, 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)lookAround, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)lookAround) - 8), (float)(resolution.func_198087_p() - 80), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)exit, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)exit) - 8), (float)(resolution.func_198087_p() - 70), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)zoom, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)zoom) - 8), (float)(resolution.func_198087_p() - 60), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)nightVision, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)nightVision) - 8), (float)(resolution.func_198087_p() - 50), 0xFFFFFF);
        font.func_243246_a(matrix, (ITextComponent)redstone, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)redstone) - 8), (float)(resolution.func_198087_p() - 40), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        font.func_243246_a(matrix, (ITextComponent)REDSTONE_NOTE, (float)(resolution.func_198107_o() - font.func_238414_a_((ITextProperties)REDSTONE_NOTE) - 8), (float)(resolution.func_198087_p() - 30), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_238474_b_(matrix, 5, 0, 0, 0, 90, 20);
        gui.func_238474_b_(matrix, resolution.func_198107_o() - 70, 5, 190, 0, 65, 30);
        if (!player.func_70644_a(Effects.field_76439_r)) {
            gui.func_238474_b_(matrix, 28, 4, 90, 12, 16, 11);
        } else {
            mc.func_110434_K().func_110577_a(NIGHT_VISION);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)27, (int)-1, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        }
        if (state.func_185911_a((IBlockReader)world, pos, (Direction)state.func_177229_b((Property)SecurityCameraBlock.FACING)) == 0) {
            if (!hasRedstoneModule) {
                gui.func_238474_b_(matrix, 12, 2, 104, 0, 12, 12);
            } else {
                gui.func_238474_b_(matrix, 12, 3, 90, 0, 12, 11);
            }
        } else {
            Minecraft.func_71410_x().func_175599_af().func_180450_b(REDSTONE, 10, 0);
        }
    }
}

