/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRedstoneBlock;
import net.geforcemods.securitycraft.commands.SCCommand;
import net.geforcemods.securitycraft.compat.lycanitesmobs.LycanitesMobsCompat;
import net.geforcemods.securitycraft.compat.quark.QuarkCompat;
import net.geforcemods.securitycraft.compat.top.TOPDataProvider;
import net.geforcemods.securitycraft.itemgroups.SCDecorationTab;
import net.geforcemods.securitycraft.itemgroups.SCExplosivesTab;
import net.geforcemods.securitycraft.itemgroups.SCTechnicalTab;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.misc.conditions.TileEntityNBTCondition;
import net.geforcemods.securitycraft.util.HasManualPage;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="securitycraft")
@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SecurityCraft {
    public static final String MODID = "securitycraft";
    public static final String PROTOCOL_VERSION = "4";
    public static SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("securitycraft", "securitycraft"), () -> "4", "4"::equals, "4"::equals);
    public static ItemGroup groupSCTechnical = new SCTechnicalTab();
    public static ItemGroup groupSCMine = new SCExplosivesTab();
    public static ItemGroup groupSCDecoration = new SCDecorationTab();
    public static final LootConditionType TILE_ENTITY_NBT_LOOT_CONDITION = LootConditionManager.func_237475_a_((String)"securitycraft:tile_entity_nbt", (ILootSerializer)new TileEntityNBTCondition.Serializer());

    public SecurityCraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigHandler.SERVER_SPEC);
        SCContent.BLOCKS.register(modEventBus);
        SCContent.FLUIDS.register(modEventBus);
        SCContent.ITEMS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        RegistrationHandler.registerPackets();
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", ReinforcedHopperBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadChestBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", () -> {
            AbstractKeypadFurnaceBlock abstractKeypadFurnaceBlock = (AbstractKeypadFurnaceBlock)SCContent.KEYPAD_FURNACE.get();
            abstractKeypadFurnaceBlock.getClass();
            return abstractKeypadFurnaceBlock.new AbstractKeypadFurnaceBlock.Convertible(Blocks.field_150460_al);
        });
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", () -> {
            AbstractKeypadFurnaceBlock abstractKeypadFurnaceBlock = (AbstractKeypadFurnaceBlock)SCContent.KEYPAD_SMOKER.get();
            abstractKeypadFurnaceBlock.getClass();
            return abstractKeypadFurnaceBlock.new AbstractKeypadFurnaceBlock.Convertible(Blocks.field_222423_lL);
        });
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", () -> {
            AbstractKeypadFurnaceBlock abstractKeypadFurnaceBlock = (AbstractKeypadFurnaceBlock)SCContent.KEYPAD_BLAST_FURNACE.get();
            abstractKeypadFurnaceBlock.getClass();
            return abstractKeypadFurnaceBlock.new AbstractKeypadFurnaceBlock.Convertible(Blocks.field_222424_lM);
        });
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", CommonDoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", InventoryScannerBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedPressurePlateBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedRedstoneBlock.DoorActivator::new);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPDataProvider::new);
        }
        if (ModList.get().isLoaded("lycanitesmobs")) {
            InterModComms.sendTo((String)MODID, (String)"registerSentryAttackTargetCheck", LycanitesMobsCompat::new);
        }
        if (ModList.get().isLoaded("quark")) {
            QuarkCompat.registerChestConversions();
        }
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        EnumMap<PageGroup, List> groupStacks = new EnumMap<PageGroup, List>(PageGroup.class);
        for (Field field : SCContent.class.getFields()) {
            try {
                if (field.isAnnotationPresent(Reinforced.class)) {
                    Block block = (Block)((RegistryObject)field.get(null)).get();
                    IReinforcedBlock rb = (IReinforcedBlock)block;
                    IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.put(rb.getVanillaBlock(), block);
                    IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.put(block, rb.getVanillaBlock());
                }
                if (!field.isAnnotationPresent(HasManualPage.class)) continue;
                IForgeRegistryEntry o = ((RegistryObject)field.get(null)).get();
                HasManualPage hmp = field.getAnnotation(HasManualPage.class);
                Item item = ((IItemProvider)o).func_199767_j();
                PageGroup group2 = hmp.value();
                boolean wasNotAdded = false;
                TranslationTextComponent title = new TranslationTextComponent("");
                String key = "help.";
                if (group2 != PageGroup.NONE) {
                    if (!groupStacks.containsKey((Object)group2)) {
                        groupStacks.put(group2, new ArrayList());
                        title = Utils.localize(group2.getTitle(), new Object[0]);
                        key = key + group2.getSpecialInfoKey();
                        wasNotAdded = true;
                    }
                    ((List)groupStacks.get((Object)group2)).add(new ItemStack((IItemProvider)item));
                } else {
                    title = Utils.localize(item.func_77658_a(), new Object[0]);
                    key = key + item.func_77658_a().substring(5) + ".info";
                }
                if (group2 != PageGroup.NONE && !wasNotAdded) continue;
                SCManualItem.PAGES.add(new SCManualPage(item, group2, title, new TranslationTextComponent(key.replace("..", ".")), hmp.designedBy(), hmp.hasRecipeDescription()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        groupStacks.forEach((group, list) -> group.setItems(Ingredient.func_234819_a_(list.stream())));
        ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, (world, ticketHelper) -> ticketHelper.getEntityTickets().forEach((uuid, chunk) -> {
            if (world.func_217461_a(uuid) == null) {
                ticketHelper.removeAllTickets(uuid);
            }
        }));
    }

    public void registerCommands(RegisterCommandsEvent event) {
        SCCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static String getVersion() {
        return ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().getQualifier();
    }
}

