/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.List;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public interface IViewActivated {
    default public void checkView(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            if (this.getViewCooldown() > 0) {
                this.setViewCooldown(this.getViewCooldown() - 1);
                return;
            }
            List entities = world.func_175647_a(LivingEntity.class, new AxisAlignedBB(pos).func_186662_g(5.0), e -> !e.func_175149_v() && !EntityUtils.isInvisible(e) && (!this.activatedOnlyByPlayer() || e instanceof PlayerEntity));
            for (LivingEntity entity : entities) {
                double eyeHeight = entity.func_70047_e();
                Vector3d lookVec = new Vector3d(entity.func_226277_ct_() + entity.func_70040_Z().field_72450_a * 5.0, eyeHeight + entity.func_226278_cu_() + entity.func_70040_Z().field_72448_b * 5.0, entity.func_226281_cx_() + entity.func_70040_Z().field_72449_c * 5.0);
                BlockRayTraceResult rtr = world.func_217299_a(new RayTraceContext(new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_()), lookVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
                if (rtr == null || rtr.func_216350_a().func_177958_n() != pos.func_177958_n() || rtr.func_216350_a().func_177956_o() != pos.func_177956_o() || rtr.func_216350_a().func_177952_p() != pos.func_177952_p() || !this.onEntityViewed(entity, rtr)) continue;
                this.setViewCooldown(this.getDefaultViewCooldown());
            }
        }
    }

    default public int getDefaultViewCooldown() {
        return 30;
    }

    public int getViewCooldown();

    public void setViewCooldown(int var1);

    public boolean onEntityViewed(LivingEntity var1, BlockRayTraceResult var2);

    default public boolean activatedOnlyByPlayer() {
        return true;
    }
}

