/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    public Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    public Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void readFromNBT(CompoundNBT var1);

    public abstract void writeToNBT(CompoundNBT var1);

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public final String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String toString() {
        return this.value + "";
    }

    public static class FloatOption
    extends Option<Float> {
        public FloatOption(String optionName, Float value) {
            super(optionName, value);
        }

        public FloatOption(String optionName, Float value, Float min, Float max, Float increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (((Float)this.get()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMin());
                return;
            }
            if (((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue(Float.valueOf(((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue()));
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.value = tag.func_74764_b(this.getName()) ? Float.valueOf(tag.func_74760_g(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            tag.func_74776_a(this.getName(), ((Float)this.value).floatValue());
        }

        @Override
        public String toString() {
            return Float.toString(((Float)this.value).floatValue()).length() > 5 ? Float.toString(((Float)this.value).floatValue()).substring(0, 5) : Float.toString(((Float)this.value).floatValue());
        }
    }

    public static class DoubleOption
    extends Option<Double>
    implements Slider.ISlider {
        private boolean slider;
        private Supplier<BlockPos> pos;

        public DoubleOption(String optionName, Double value) {
            super(optionName, value);
            this.slider = false;
        }

        public DoubleOption(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.slider = false;
        }

        public DoubleOption(Supplier<BlockPos> pos, String optionName, Double value, Double min, Double max, Double increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Double)this.get() >= (Double)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if ((Double)this.get() + (Double)this.getIncrement() >= (Double)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue((Double)this.get() + (Double)this.getIncrement());
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.value = tag.func_74764_b(this.getName()) ? Double.valueOf(tag.func_74769_h(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            tag.func_74780_a(this.getName(), ((Double)this.value).doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return this.slider;
        }

        public void onChangeSliderValue(Slider slider) {
            if (!this.isSlider() || !(slider instanceof NamedSlider)) {
                return;
            }
            this.setValue(slider.getValue());
            slider.func_238482_a_((ITextComponent)Utils.localize("option" + ((NamedSlider)slider).getBlockName() + "." + this.getName(), this.toString()));
            SecurityCraft.channel.sendToServer((Object)new UpdateSliderValue(this.pos.get(), this, (Double)this.get()));
        }
    }

    public static class IntOption
    extends Option<Integer>
    implements Slider.ISlider {
        private boolean slider;
        private Supplier<BlockPos> pos;

        public IntOption(String optionName, Integer value) {
            super(optionName, value);
        }

        public IntOption(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
        }

        public IntOption(Supplier<BlockPos> pos, String optionName, Integer value, Integer min, Integer max, Integer increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Integer)this.get() >= (Integer)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if ((Integer)this.get() + (Integer)this.getIncrement() >= (Integer)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue((Integer)this.get() + (Integer)this.getIncrement());
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.value = tag.func_74764_b(this.getName()) ? Integer.valueOf(tag.func_74762_e(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            tag.func_74768_a(this.getName(), ((Integer)this.value).intValue());
        }

        @Override
        public boolean isSlider() {
            return this.slider;
        }

        public void onChangeSliderValue(Slider slider) {
            if (!this.isSlider() || !(slider instanceof NamedSlider)) {
                return;
            }
            this.setValue((int)slider.getValue());
            slider.func_238482_a_((ITextComponent)Utils.localize("option" + ((NamedSlider)slider).getBlockName() + "." + this.getName(), this.toString()));
            SecurityCraft.channel.sendToServer((Object)new UpdateSliderValue(this.pos.get(), this, ((Integer)this.get()).intValue()));
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.value = tag.func_74764_b(this.getName()) ? Boolean.valueOf(tag.func_74767_n(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            tag.func_74757_a(this.getName(), ((Boolean)this.value).booleanValue());
        }
    }
}

