/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.inventory.GenericBEMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractKeypadFurnaceBlockEntity
extends AbstractFurnaceTileEntity
implements IPasswordProtected,
INamedContainerProvider,
IOwnable,
INameSetter,
IModuleInventory,
ICustomizable,
ILockable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private Owner owner = new Owner();
    private String passcode;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public AbstractKeypadFurnaceBlockEntity(TileEntityType<?> teType, IRecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(teType, recipeType);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.write(tag, false);
        }
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.owner.read(tag);
        this.passcode = tag.func_74779_i("passcode");
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            ItemStack stack = this.getModule(ModuleType.DISGUISE);
            if (!stack.func_190926_b()) {
                ClientHandler.putDisguisedBeRenderer((TileEntity)this, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf((TileEntity)this);
            }
        }
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (TileEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((IInventory)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.field_214012_a.get(slot);
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.func_195044_w().func_177230_c() instanceof AbstractKeypadFurnaceBlock) {
            ((AbstractKeypadFurnaceBlock)this.func_195044_w().func_177230_c()).activate(this.func_195044_w(), this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericBEMenu(SCContent.mTypeCheckPassword, windowId, AbstractKeypadFurnaceBlockEntity.this.field_145850_b, AbstractKeypadFurnaceBlockEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return AbstractKeypadFurnaceBlockEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericBEMenu(SCContent.mTypeSetPassword, windowId, AbstractKeypadFurnaceBlockEntity.this.field_145850_b, AbstractKeypadFurnaceBlockEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return AbstractKeypadFurnaceBlockEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player) {
        this.activate(player);
        return true;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public IIntArray getFurnaceData() {
        return this.field_214013_b;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        if (module == ModuleType.DISGUISE) {
            if (!this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.field_174879_c, true, stack));
            } else {
                ClientHandler.putDisguisedBeRenderer((TileEntity)this, stack);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this.getTileEntity());
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        if (module == ModuleType.DISGUISE) {
            if (!this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.field_174879_c, false, stack));
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf((TileEntity)this);
            }
        }
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_STATE_RL, (Object)Blocks.field_150350_a.func_176223_P()).build();
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }
}

