/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public class AlarmBlockEntity
extends CustomizableBlockEntity
implements ITickableTileEntity {
    private Option.IntOption range;
    private Option.IntOption delay;
    private int cooldown;
    private boolean isPowered;

    public AlarmBlockEntity() {
        super(SCContent.beTypeAlarm);
        this.range = new Option.IntOption(() -> ((AlarmBlockEntity)this).func_174877_v(), "range", 17, 0, (Integer)ConfigHandler.SERVER.maxAlarmRange.get(), 1, true);
        this.delay = new Option.IntOption(() -> ((AlarmBlockEntity)this).func_174877_v(), "delay", 2, 1, 30, 1, true);
        this.cooldown = 0;
        this.isPowered = false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isPowered && --this.cooldown <= 0) {
            for (ServerPlayerEntity player : ((ServerWorld)this.field_145850_b).func_217490_a(p -> p.func_233580_cy_().func_177951_i((Vector3i)this.field_174879_c) <= Math.pow(((Integer)this.range.get()).intValue(), 2.0))) {
                player.func_213823_a(SCSounds.ALARM.event, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            this.setCooldown((Integer)this.delay.get() * 20);
        }
        this.requestModelDataUpdate();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("isPowered", this.isPowered);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.cooldown = tag.func_74762_e("cooldown");
        this.isPowered = tag.func_74767_n("isPowered");
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.delay};
    }
}

