/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements INamedContainerProvider,
ILockable {
    private boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    private int signature = 0;
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeycardReaderBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);

    public KeycardReaderBlockEntity() {
        super(SCContent.beTypeKeycardReader);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        CompoundNBT acceptedLevelsTag = new CompoundNBT();
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.func_74757_a("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.func_218657_a("acceptedLevels", (INBT)acceptedLevelsTag);
        tag.func_74768_a("signature", this.signature);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("passLV")) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.func_74762_e("passLV") - 1;
            if (tag.func_74764_b("requiresExactKeycard")) {
                oldRequiresExactKeycard = tag.func_74767_n("requiresExactKeycard");
            }
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.func_150297_b("acceptedLevels", 10)) {
            CompoundNBT acceptedLevelsTag = tag.func_74775_l("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.func_74767_n("lvl" + i);
            }
        }
        this.signature = tag.func_74762_e("signature");
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new KeycardReaderMenu(windowId, inv, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }
}

