/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.inventory.GenericBEMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasswordProtected,
ILockable {
    private String passcode;

    public KeypadDoorBlockEntity() {
        super(SCContent.beTypeKeypadDoor);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.passcode = tag.func_74779_i("passcode");
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.func_195044_w().func_177230_c() instanceof KeypadDoorBlock) {
            ((KeypadDoorBlock)this.func_195044_w().func_177230_c()).activate(this.func_195044_w(), this.field_145850_b, this.field_174879_c, this.getSignalLength());
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericBEMenu(SCContent.mTypeCheckPassword, windowId, KeypadDoorBlockEntity.this.field_145850_b, KeypadDoorBlockEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return KeypadDoorBlockEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericBEMenu(SCContent.mTypeSetPassword, windowId, KeypadDoorBlockEntity.this.field_145850_b, KeypadDoorBlockEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return KeypadDoorBlockEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player) {
        if (!((Boolean)blockState.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        TileEntity te = null;
        this.passcode = password;
        if (this.func_195044_w().func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
            te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        } else if (this.func_195044_w().func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        if (te instanceof KeypadDoorBlockEntity) {
            ((KeypadDoorBlockEntity)te).setPasswordExclusively(password);
        }
    }

    public void setPasswordExclusively(String password) {
        this.passcode = password;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }
}

