/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class LaserBlockBlockEntity
extends LinkableBlockEntity {
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.toggleLaser(this);
        }
    };

    public LaserBlockBlockEntity() {
        super(SCContent.beTypeLaserBlock);
    }

    private void toggleLaser(Option.BooleanOption option) {
        if (((Boolean)option.get()).booleanValue()) {
            ((LaserBlock)this.func_195044_w().func_177230_c()).setLaser(this.field_145850_b, this.field_174879_c);
        } else {
            LaserBlock.destroyAdjacentLasers((IWorld)this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedTEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.BooleanOption)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == LinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            if (((ModuleItem)module.func_77973_b()).getModuleType() == ModuleType.DISGUISE) {
                this.onInsertDisguiseModule(module);
            }
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            ModuleType module = (ModuleType)((Object)parameters[1]);
            ItemStack moduleStack = this.getModule(module);
            this.removeModule(module);
            if (module == ModuleType.DISGUISE) {
                this.onRemoveDisguiseModule(moduleStack);
            }
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(stack);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(stack);
        }
    }

    private void onInsertDisguiseModule(ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        } else {
            ClientHandler.putDisguisedBeRenderer(this, stack);
        }
    }

    private void onRemoveDisguiseModule(ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            ItemStack stack = this.getModule(ModuleType.DISGUISE);
            if (!stack.func_190926_b()) {
                ClientHandler.putDisguisedBeRenderer(this, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_STATE_RL, (Object)Blocks.field_150350_a.func_176223_P()).build();
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

