/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.PortableRadarBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PortableRadarBlockEntity
extends CustomizableBlockEntity
implements ITickableTileEntity {
    private Option.DoubleOption searchRadiusOption = new Option.DoubleOption(() -> ((PortableRadarBlockEntity)this).func_174877_v(), "searchRadius", 25.0, 5.0, 50.0, 1.0, true);
    private Option.IntOption searchDelayOption = new Option.IntOption(() -> ((PortableRadarBlockEntity)this).func_174877_v(), "searchDelay", 4, 4, 10, 1, true);
    private Option.BooleanOption repeatMessageOption = new Option.BooleanOption("repeatMessage", true);
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true);
    private boolean shouldSendNewMessage = true;
    private String lastPlayerName = "";
    private int ticksUntilNextSearch = this.getSearchDelay();

    public PortableRadarBlockEntity() {
        super(SCContent.beTypePortableRadar);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ((Boolean)this.enabledOption.get()).booleanValue() && this.ticksUntilNextSearch-- <= 0) {
            this.ticksUntilNextSearch = this.getSearchDelay();
            ServerPlayerEntity owner = this.field_145850_b.func_73046_m().func_184103_al().func_152612_a(this.getOwner().getName());
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getSearchRadius(), this.getSearchRadius(), this.getSearchRadius());
            List entities = this.field_145850_b.func_175647_a(PlayerEntity.class, area, e -> {
                boolean isNotAllowed = true;
                if (this.hasModule(ModuleType.ALLOWLIST)) {
                    isNotAllowed = !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)e);
                }
                return e != owner && isNotAllowed && !e.func_175149_v() && !EntityUtils.isInvisible((LivingEntity)e);
            });
            if (this.hasModule(ModuleType.REDSTONE)) {
                PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, !entities.isEmpty());
            }
            if (owner != null) {
                for (PlayerEntity e2 : entities) {
                    if (!this.shouldSendMessage(e2)) continue;
                    IFormattableTextComponent attackedName = e2.func_200200_C_().func_230531_f_().func_240699_a_(TextFormatting.ITALIC);
                    TranslationTextComponent text = this.func_145818_k_() ? Utils.localize("messages.securitycraft:portableRadar.withName", attackedName, this.func_200201_e().func_230531_f_().func_240699_a_(TextFormatting.ITALIC)) : Utils.localize("messages.securitycraft:portableRadar.withoutName", attackedName, Utils.getFormattedCoordinates(this.field_174879_c));
                    PlayerUtils.sendMessageToPlayer((PlayerEntity)owner, (IFormattableTextComponent)Utils.localize(((Block)SCContent.PORTABLE_RADAR.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)text, TextFormatting.BLUE);
                    this.setSentMessage();
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.REDSTONE) {
            PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("shouldSendNewMessage", this.shouldSendNewMessage);
        tag.func_74778_a("lastPlayerName", this.lastPlayerName);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.shouldSendNewMessage = tag.func_74767_n("shouldSendNewMessage");
        this.lastPlayerName = tag.func_74779_i("lastPlayerName");
    }

    public boolean shouldSendMessage(PlayerEntity player) {
        if (!player.func_200200_C_().getString().equals(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.func_200200_C_().getString();
        }
        boolean lastPlayerOwns = (Boolean)ConfigHandler.SERVER.enableTeamOwnership.get() != false ? PlayerUtils.areOnSameTeam(this.lastPlayerName, this.getOwner().getName()) : this.lastPlayerName.equals(this.getOwner().getName());
        return (this.shouldSendNewMessage || (Boolean)this.repeatMessageOption.get() != false) && !lastPlayerOwns;
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
    }

    public double getSearchRadius() {
        return (Double)this.searchRadiusOption.get();
    }

    public int getSearchDelay() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }
}

