/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;

public class ProjectorBlockEntity
extends DisguisableBlockEntity
implements IInventory,
INamedContainerProvider,
ILockable {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    public static final int RENDER_DISTANCE = 100;
    private int projectionWidth = 1;
    private int projectionHeight = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    public boolean activatedByRedstone = false;
    public boolean active = false;
    private boolean horizontal = false;
    private ItemStack projectedBlock = ItemStack.field_190927_a;
    private BlockState projectedState = Blocks.field_150350_a.func_176223_P();

    public ProjectorBlockEntity() {
        super(SCContent.beTypeProjecto);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(100.0);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("width", this.projectionWidth);
        tag.func_74768_a("height", this.projectionHeight);
        tag.func_74768_a("range", this.projectionRange);
        tag.func_74768_a("offset", this.projectionOffset);
        tag.func_74757_a("active", this.active);
        tag.func_74757_a("horizontal", this.horizontal);
        tag.func_218657_a("storedItem", (INBT)this.projectedBlock.func_77955_b(new CompoundNBT()));
        tag.func_218657_a("SavedState", (INBT)NBTUtil.func_190009_a((BlockState)this.projectedState));
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.projectionWidth = tag.func_74762_e("width");
        this.projectionHeight = tag.func_74762_e("height");
        this.projectionRange = tag.func_74762_e("range");
        this.projectionOffset = tag.func_74762_e("offset");
        this.activatedByRedstone = this.hasModule(ModuleType.REDSTONE);
        this.active = tag.func_74767_n("active");
        this.horizontal = tag.func_74767_n("horizontal");
        this.projectedBlock = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("storedItem"));
        if (!tag.func_74764_b("SavedState")) {
            this.resetSavedState();
        } else {
            this.setProjectedState(NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("SavedState")));
        }
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
    }

    public int getProjectionHeight() {
        return this.projectionHeight;
    }

    public void setProjectionHeight(int projectionHeight) {
        this.projectionHeight = projectionHeight;
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public boolean isActive() {
        return this.activatedByRedstone ? this.active : true;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
    }

    public BlockState getProjectedState() {
        return this.projectedState;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ProjectorMenu(windowId, this.field_145850_b, this.field_174879_c, inv);
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    public void func_174888_l() {
        this.projectedBlock = ItemStack.field_190927_a;
        this.resetSavedState();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            this.projectedBlock = ItemStack.field_190927_a;
            this.resetSavedState();
        }
        return stack;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.field_190927_a);
    }

    public ItemStack func_70301_a(int slot) {
        return this.getStackInSlot(slot);
    }

    public boolean func_191420_l() {
        return this.projectedBlock.func_190926_b();
    }

    public boolean func_70300_a(PlayerEntity arg0) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.projectedBlock;
        this.projectedBlock = ItemStack.field_190927_a;
        this.resetSavedState();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack = new ItemStack((IItemProvider)stack.func_77973_b(), this.func_70297_j_());
        }
        ItemStack old = this.projectedBlock;
        this.projectedBlock = stack;
        if (old.func_77973_b() != this.projectedBlock.func_77973_b()) {
            this.resetSavedState();
        }
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, this.projectedState);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    public void setProjectedState(BlockState projectedState) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (this.projectedState.func_177230_c() != projectedState.func_177230_c()) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, projectedState);
        }
        this.projectedState = projectedState;
        this.func_70296_d();
    }

    public void resetSavedState() {
        if (this.projectedBlock.func_77973_b() instanceof BlockItem) {
            this.setProjectedState(((BlockItem)this.projectedBlock.func_77973_b()).func_179223_d().func_176223_P());
        } else {
            this.projectedState = Blocks.field_150350_a.func_176223_P();
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            this.func_70296_d();
        }
    }

    public StandingOrWallType getStandingOrWallType() {
        if (this.projectedState != null && this.projectedBlock != null && this.projectedBlock.func_77973_b() instanceof WallOrFloorItem) {
            WallOrFloorItem wofi = (WallOrFloorItem)this.projectedBlock.func_77973_b();
            if (this.projectedState.func_177230_c() == wofi.func_179223_d()) {
                return StandingOrWallType.STANDING;
            }
            if (this.projectedState.func_177230_c() == wofi.field_195947_b) {
                return StandingOrWallType.WALL;
            }
        }
        return StandingOrWallType.NONE;
    }
}

