/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SonicSecuritySystemTracker;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class SonicSecuritySystemBlockEntity
extends CustomizableBlockEntity
implements ITickableTileEntity {
    private static final int PING_DELAY = 100;
    private static final int LISTEN_DELAY = 60;
    public static final int MAX_RANGE = 30;
    public static final int MAX_LINKED_BLOCKS = 30;
    private boolean emitsPings = true;
    private int pingCooldown = 100;
    public Option.IntOption signalLength = new Option.IntOption(() -> ((SonicSecuritySystemBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    public int powerCooldown = 0;
    public float radarRotationDegrees = 0.0f;
    private Set<BlockPos> linkedBlocks = new HashSet<BlockPos>();
    private boolean isActive = true;
    private boolean isRecording = false;
    private ArrayList<NoteWrapper> recordedNotes = new ArrayList();
    public boolean correctTuneWasPlayed = false;
    private boolean isListening = false;
    private int listeningTimer = 60;
    private int listenPos = 0;
    private boolean tracked = false;

    public SonicSecuritySystemBlockEntity() {
        super(SCContent.beTypeSonicSecuritySystem);
    }

    public void func_73660_a() {
        if (!this.tracked) {
            SonicSecuritySystemTracker.track(this);
            this.tracked = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isActive()) {
                return;
            }
            if (this.correctTuneWasPlayed) {
                if (this.powerCooldown > 0) {
                    --this.powerCooldown;
                } else {
                    this.correctTuneWasPlayed = false;
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                    BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
                }
            }
            if (this.isListening) {
                if (this.listeningTimer > 0) {
                    --this.listeningTimer;
                    return;
                }
                this.stopListening();
            }
            if (!this.isLinkedToBlock()) {
                return;
            }
            if (this.pingCooldown > 0) {
                --this.pingCooldown;
            } else {
                ArrayList<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
                for (BlockPos blockPos : this.linkedBlocks) {
                    if (this.field_145850_b.func_175625_s(blockPos) instanceof ILockable) continue;
                    blocksToRemove.add(blockPos);
                }
                for (BlockPos posToRemove : blocksToRemove) {
                    this.delink(posToRemove, false);
                    this.sync();
                }
                if (this.emitsPings && !this.isRecording) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SCSounds.PING.event, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
                this.pingCooldown = 100;
            }
        } else if (this.isActive() || this.isRecording()) {
            this.radarRotationDegrees = (float)((double)this.radarRotationDegrees + 0.15);
            if (this.radarRotationDegrees >= 360.0f) {
                this.radarRotationDegrees = 0.0f;
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        SonicSecuritySystemTracker.stopTracking(this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        if (module == ModuleType.REDSTONE) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
        }
        super.onModuleRemoved(stack, module);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.linkedBlocks.size() > 0 && !tag.func_74764_b("LinkedBlocks")) {
            tag.func_218657_a("LinkedBlocks", (INBT)new ListNBT());
        }
        for (BlockPos blockToSave : this.linkedBlocks) {
            CompoundNBT nbt = NBTUtil.func_186859_a((BlockPos)blockToSave);
            tag.func_150295_c("LinkedBlocks", 10).add((Object)nbt);
            if (this.linkedBlocks.contains(blockToSave)) continue;
            this.linkedBlocks.add(blockToSave);
        }
        this.saveNotes(tag);
        tag.func_74757_a("emitsPings", this.emitsPings);
        tag.func_74757_a("isActive", this.isActive);
        tag.func_74757_a("isRecording", this.isRecording);
        tag.func_74757_a("isListening", this.isListening);
        tag.func_74768_a("listenPos", this.listenPos);
        tag.func_74757_a("correctTuneWasPlayed", this.correctTuneWasPlayed);
        tag.func_74768_a("powerCooldown", this.powerCooldown);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("LinkedBlocks")) {
            ListNBT list = tag.func_150295_c("LinkedBlocks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT linkedBlock = list.func_150305_b(i);
                BlockPos linkedBlockPos = NBTUtil.func_186861_c((CompoundNBT)linkedBlock);
                this.linkedBlocks.add(linkedBlockPos);
            }
        }
        this.recordedNotes.clear();
        SonicSecuritySystemBlockEntity.loadNotes(tag, this.recordedNotes);
        if (tag.func_74764_b("emitsPings")) {
            this.emitsPings = tag.func_74767_n("emitsPings");
        }
        if (tag.func_74764_b("isActive")) {
            this.isActive = tag.func_74767_n("isActive");
        }
        this.isRecording = tag.func_74767_n("isRecording");
        this.isListening = tag.func_74767_n("isListening");
        this.listenPos = tag.func_74762_e("listenPos");
        this.correctTuneWasPlayed = tag.func_74767_n("correctTuneWasPlayed");
        this.powerCooldown = tag.func_74762_e("powerCooldown");
    }

    public void saveNotes(CompoundNBT tag) {
        ListNBT notes = new ListNBT();
        for (NoteWrapper note : this.recordedNotes) {
            CompoundNBT noteNbt = new CompoundNBT();
            noteNbt.func_74768_a("noteID", note.noteID);
            noteNbt.func_74778_a("instrument", note.instrumentName);
            notes.add((Object)noteNbt);
        }
        tag.func_218657_a("Notes", (INBT)notes);
    }

    public static <T extends Collection<NoteWrapper>> void loadNotes(CompoundNBT tag, T recordedNotes) {
        if (tag.func_74764_b("Notes")) {
            ListNBT list = tag.func_150295_c("Notes", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT note = list.func_150305_b(i);
                recordedNotes.add((NoteWrapper)new NoteWrapper(note.func_74762_e("noteID"), note.func_74779_i("instrument")));
            }
        }
    }

    public boolean transferPositionsFromItem(CompoundNBT itemTag) {
        if (itemTag == null || !itemTag.func_74764_b("LinkedBlocks")) {
            return false;
        }
        ListNBT blocks = itemTag.func_150295_c("LinkedBlocks", 10);
        for (int i = 0; i < blocks.size(); ++i) {
            CompoundNBT linkedBlock = blocks.func_150305_b(i);
            BlockPos linkedBlockPos = NBTUtil.func_186861_c((CompoundNBT)linkedBlock);
            if (this.isLinkedToBlock(linkedBlockPos)) continue;
            this.linkedBlocks.add(linkedBlockPos);
        }
        this.sync();
        return true;
    }

    public boolean isLinkedToBlock() {
        return !this.linkedBlocks.isEmpty();
    }

    public boolean isLinkedToBlock(BlockPos linkedBlockPos) {
        if (this.linkedBlocks.isEmpty()) {
            return false;
        }
        return this.linkedBlocks.contains(linkedBlockPos);
    }

    public void delink(BlockPos linkedBlockPos, boolean shouldSync) {
        if (this.linkedBlocks.isEmpty()) {
            return;
        }
        this.linkedBlocks.remove(linkedBlockPos);
        if (shouldSync) {
            this.sync();
        }
    }

    public void delinkAll() {
        this.linkedBlocks.clear();
        this.sync();
    }

    public int getNumberOfLinkedBlocks() {
        return this.linkedBlocks.size();
    }

    public boolean pings() {
        return this.emitsPings;
    }

    public void setPings(boolean pings) {
        this.emitsPings = pings;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean recording) {
        this.isRecording = recording;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void startListening() {
        this.isListening = true;
    }

    public void stopListening() {
        this.resetListeningTimer();
        this.listenPos = 0;
        this.isListening = false;
        this.field_145850_b.func_230547_a_(this.field_174879_c, (Block)SCContent.SONIC_SECURITY_SYSTEM.get());
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void resetListeningTimer() {
        this.listeningTimer = 60;
    }

    public void recordNote(int noteID, String instrumentName) {
        this.recordedNotes.add(new NoteWrapper(noteID, instrumentName));
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public boolean listenToNote(int noteID, String instrumentName) {
        if (this.getNumberOfNotes() == 0 || this.listenPos >= this.getNumberOfNotes()) {
            return false;
        }
        if (!this.isListening) {
            this.isListening = true;
            this.sync();
        }
        if (this.recordedNotes.get(this.listenPos++).isSameNote(noteID, instrumentName)) {
            this.resetListeningTimer();
            return this.listenPos >= this.recordedNotes.size();
        }
        return false;
    }

    public ArrayList<NoteWrapper> getRecordedNotes() {
        return this.recordedNotes;
    }

    public int getNumberOfNotes() {
        return this.recordedNotes.size();
    }

    public void clearNotes() {
        this.recordedNotes.clear();
    }

    private void sync() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength};
    }

    public static class NoteWrapper {
        public final int noteID;
        public final String instrumentName;

        public NoteWrapper(int note, String instrument) {
            this.noteID = note;
            this.instrumentName = instrument;
        }

        public boolean isSameNote(int note, String instrument) {
            return this.noteID == note && this.instrumentName.equals(instrument);
        }
    }
}

