/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SpecialDoorBlockEntity
extends LinkableBlockEntity {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((SpecialDoorBlockEntity)this).func_174877_v(), "signalLength", this.defaultSignalLength(), 0, 400, 5, true);

    public SpecialDoorBlockEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void onOwnerChanged(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        pos = state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.UPPER ? pos.func_177977_b() : pos.func_177984_a();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SpecialDoorBlockEntity && SpecialDoorBlockEntity.isLinkedWith(this, (SpecialDoorBlockEntity)te)) {
            ((SpecialDoorBlockEntity)te).setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!world.field_72995_K) {
                world.func_73046_m().func_184103_al().func_148540_a((IPacket)te.func_189518_D_());
            }
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        this.handleModule(stack, module, false);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        this.handleModule(stack, module, true);
    }

    private void handleModule(ItemStack stack, ModuleType module, boolean removed) {
        TileEntity otherTe;
        DoubleBlockHalf myHalf = (DoubleBlockHalf)this.func_195044_w().func_177229_b((Property)DoorBlock.field_176523_O);
        BlockPos otherPos = myHalf == DoubleBlockHalf.UPPER ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a();
        BlockState other = this.field_145850_b.func_180495_p(otherPos);
        if (other.func_177229_b((Property)DoorBlock.field_176523_O) != myHalf && (otherTe = this.field_145850_b.func_175625_s(otherPos)) instanceof SpecialDoorBlockEntity) {
            SpecialDoorBlockEntity otherDoorTe = (SpecialDoorBlockEntity)otherTe;
            if (!removed && !otherDoorTe.hasModule(module)) {
                otherDoorTe.insertModule(stack);
            } else if (removed && otherDoorTe.hasModule(module)) {
                otherDoorTe.removeModule(module);
            }
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedTEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            if (option.getName().equals(this.sendMessage.getName())) {
                this.sendMessage.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public abstract int defaultSignalLength();
}

