/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractKeypadFurnaceBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape NORTH_OPEN = Stream.of(Block.func_208617_a((double)11.0, (double)1.0, (double)1.0, (double)12.0, (double)2.0, (double)2.0), Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)1.0), Block.func_208617_a((double)4.0, (double)1.0, (double)1.0, (double)5.0, (double)2.0, (double)2.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape NORTH_CLOSED = Stream.of(Block.func_208617_a((double)4.0, (double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)2.0), Block.func_208617_a((double)11.0, (double)14.0, (double)1.0, (double)12.0, (double)15.0, (double)2.0), Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)1.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape EAST_OPEN = Stream.of(Block.func_208617_a((double)14.0, (double)1.0, (double)11.0, (double)15.0, (double)2.0, (double)12.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), Block.func_208617_a((double)15.0, (double)1.0, (double)4.0, (double)16.0, (double)2.0, (double)12.0), Block.func_208617_a((double)14.0, (double)1.0, (double)4.0, (double)15.0, (double)2.0, (double)5.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape EAST_CLOSED = Stream.of(Block.func_208617_a((double)14.0, (double)14.0, (double)4.0, (double)15.0, (double)15.0, (double)5.0), Block.func_208617_a((double)14.0, (double)14.0, (double)11.0, (double)15.0, (double)15.0, (double)12.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), Block.func_208617_a((double)15.0, (double)14.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SOUTH_OPEN = Stream.of(Block.func_208617_a((double)4.0, (double)1.0, (double)14.0, (double)5.0, (double)2.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.func_208617_a((double)4.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0, (double)16.0), Block.func_208617_a((double)11.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SOUTH_CLOSED = Stream.of(Block.func_208617_a((double)11.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0, (double)15.0), Block.func_208617_a((double)4.0, (double)14.0, (double)14.0, (double)5.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.func_208617_a((double)4.0, (double)14.0, (double)15.0, (double)12.0, (double)15.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape WEST_OPEN = Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)4.0, (double)2.0, (double)2.0, (double)5.0), Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)2.0, (double)12.0), Block.func_208617_a((double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)2.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape WEST_CLOSED = Stream.of(Block.func_208617_a((double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0, (double)12.0), Block.func_208617_a((double)1.0, (double)14.0, (double)4.0, (double)2.0, (double)15.0, (double)5.0), Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)14.0, (double)4.0, (double)1.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197882_b((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape NORTH_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_COLLISION = Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public AbstractKeypadFurnaceBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215700_a(world, pos, ctx);
        }
        switch ((Direction)disguisedState.func_177229_b((Property)FACING)) {
            case NORTH: {
                if (((Boolean)disguisedState.func_177229_b((Property)OPEN)).booleanValue()) {
                    return NORTH_OPEN;
                }
                return NORTH_CLOSED;
            }
            case EAST: {
                if (((Boolean)disguisedState.func_177229_b((Property)OPEN)).booleanValue()) {
                    return EAST_OPEN;
                }
                return EAST_CLOSED;
            }
            case SOUTH: {
                if (((Boolean)disguisedState.func_177229_b((Property)OPEN)).booleanValue()) {
                    return SOUTH_OPEN;
                }
                return SOUTH_CLOSED;
            }
            case WEST: {
                if (((Boolean)disguisedState.func_177229_b((Property)OPEN)).booleanValue()) {
                    return WEST_OPEN;
                }
                return WEST_CLOSED;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215700_a(level, pos, ctx);
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH_COLLISION;
            }
            case EAST: {
                return EAST_COLLISION;
            }
            case SOUTH: {
                return SOUTH_COLLISION;
            }
            case WEST: {
                return WEST_COLLISION;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof AbstractKeypadFurnaceBlock)) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            AbstractKeypadFurnaceBlockEntity te = (AbstractKeypadFurnaceBlockEntity)world.func_175625_s(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
            } else if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                }
                this.activate(state, world, pos, player);
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
                te.openPasswordGUI(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void activate(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        TileEntity te;
        if (!((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)));
        }
        if (player instanceof ServerPlayerEntity && (te = world.func_175625_s(pos)) instanceof INamedContainerProvider) {
            world.func_217378_a((PlayerEntity)null, 1006, pos, 0);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, OPEN, LIT});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public class Convertible
    implements IPasswordConvertible {
        private final Block originalBlock;

        public Convertible(Block originalBlock) {
            this.originalBlock = originalBlock;
        }

        @Override
        public Block getOriginalBlock() {
            return this.originalBlock;
        }

        @Override
        public boolean convert(PlayerEntity player, World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            boolean lit = (Boolean)state.func_177229_b((Property)LIT);
            AbstractFurnaceTileEntity furnace = (AbstractFurnaceTileEntity)world.func_175625_s(pos);
            CompoundNBT tag = furnace.func_189515_b(new CompoundNBT());
            furnace.func_174888_l();
            world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)AbstractKeypadFurnaceBlock.this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(lit)));
            ((AbstractKeypadFurnaceBlockEntity)world.func_175625_s(pos)).func_230337_a_(world.func_180495_p(pos), tag);
            ((IOwnable)world.func_175625_s(pos)).setOwner(player.func_110124_au().toString(), player.func_200200_C_().getString());
            return true;
        }
    }
}

